/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class I18nUtils {
    private static final SameLanguageControl INSTANCE = new SameLanguageControl();
    public static final String RSRC_BASENAME = I18nUtils.getBaseName(I18nUtils.class);

    public static final String getPackageName(Class<?> c) {
        return String.valueOf(c.getPackage().getName()) + ".translation";
    }

    protected static final String getBaseName(Class<?> c) {
        return String.valueOf(I18nUtils.getPackageName(c)) + ".messages";
    }

    public static class SameLanguageControl
    extends ResourceBundle.Control {
        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> res = super.getCandidateLocales(baseName, locale);
            int superSize = res.size();
            assert (res.get(superSize - 1) == Locale.ROOT);
            if (superSize == 1) {
                return res;
            }
            res = res.subList(0, superSize - 1);
            assert (res.get(res.size() - 1).getLanguage().equals(locale.getLanguage()));
            return res;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return null;
        }
    }
}

