/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.i18n.DefaultVariantKey;
import org.openconcerto.utils.i18n.GrammaticalNumber;
import org.openconcerto.utils.i18n.LocalizedInstances;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.Phrase;
import org.openconcerto.utils.i18n.TranslationManager;
import org.openconcerto.utils.i18n.VariantKey;

public abstract class Grammar {
    public static final DefaultVariantKey SINGULAR = new DefaultVariantKey(GrammaticalNumber.SINGULAR, null);
    public static final DefaultVariantKey PLURAL = new DefaultVariantKey(GrammaticalNumber.PLURAL, null);
    public static final DefaultVariantKey INDEFINITE_ARTICLE_SINGULAR = new DefaultVariantKey(GrammaticalNumber.SINGULAR, "indefiniteArticle");
    public static final DefaultVariantKey INDEFINITE_ARTICLE_PLURAL = new DefaultVariantKey(GrammaticalNumber.PLURAL, "indefiniteArticle");
    public static final DefaultVariantKey DEFINITE_ARTICLE_SINGULAR = new DefaultVariantKey(GrammaticalNumber.SINGULAR, "definiteArticle");
    public static final DefaultVariantKey DEFINITE_ARTICLE_PLURAL = new DefaultVariantKey(GrammaticalNumber.PLURAL, "definiteArticle");
    public static final DefaultVariantKey DEMONSTRATIVE_SINGULAR = new DefaultVariantKey(GrammaticalNumber.SINGULAR, "demonstrative");
    public static final DefaultVariantKey DEMONSTRATIVE_PLURAL = new DefaultVariantKey(GrammaticalNumber.PLURAL, "demonstrative");
    public static final DefaultVariantKey INDEFINITE_NUMERAL = new DefaultVariantKey(null, "indefiniteNumeral");
    public static final DefaultVariantKey DEFINITE_NUMERAL = new DefaultVariantKey(null, "definiteNumeral");
    public static final DefaultVariantKey DEMONSTRATIVE_NUMERAL = new DefaultVariantKey(null, "demonstrativeNumeral");
    public static final DefaultVariantKey INDEFINITE_ORDINAL = new DefaultVariantKey(GrammaticalNumber.SINGULAR, "indefiniteOrdinalSingular");
    public static final DefaultVariantKey DEFINITE_ORDINAL = new DefaultVariantKey(GrammaticalNumber.SINGULAR, "definiteOrdinalSingular");
    private static final LocalizedInstances<Grammar> LOCALIZED_INSTANCES = new LocalizedInstances<Grammar>(Grammar.class, TranslationManager.getControl()).setStaticMethodName("getInstance");
    private final Locale locale;
    private final Set<VariantKey> variantKeys;
    private final Map<String, VariantKey> variants;
    private final Map<String, NounClass> nounClassesByName;

    public static final Grammar getInstance(Locale l) throws IllegalStateException {
        return Grammar.getInstance(l, false);
    }

    public static final Grammar getInstance(Locale l, boolean lenient) throws IllegalStateException {
        Tuple2<Locale, List<Grammar>> instances = LOCALIZED_INSTANCES.createInstances(l);
        if (instances.get0() != null && instances.get0().getLanguage().equals(l.getLanguage())) {
            return instances.get1().get(0);
        }
        if (lenient) {
            return null;
        }
        throw new IllegalStateException("No grammar for the language of " + l);
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public abstract String getVariant(Phrase var1, VariantKey var2);

    public final Set<VariantKey> getVariantKeys() {
        return this.variantKeys;
    }

    public VariantKey getVariantKey(String id) {
        return this.variants.get(id);
    }

    public final NounClass getNounClass(String name) {
        return this.nounClassesByName.get(name);
    }

    public Object eval(Phrase phrase, Number count, List<String> l) {
        String inflection;
        int size = l.size();
        if (size == 0) {
            return phrase;
        }
        String last = l.get(size - 1);
        VariantKey key = this.getVariantKey(last);
        if (key == null) {
            Log.get().warning("Unknown key ID '" + last + "' for " + phrase + "\nknown keys : " + this.getVariantKeys());
            return phrase;
        }
        String res = inflection = count == null ? phrase.getVariant(key) : phrase.getNumeralVariant(count.intValue(), key);
        int i = size - 2;
        while (i >= 0) {
            String methodName = l.get(i);
            Method method = this.getStringMethod(methodName);
            if (method == null) {
                Log.get().warning("Unknown method " + methodName);
            } else {
                try {
                    Object methodRes = method.invoke((Object)this, res);
                    res = methodRes == null ? null : methodRes.toString();
                }
                catch (Exception e) {
                    Log.get().log(Level.WARNING, "error while passing " + res + " to " + method, e);
                }
            }
            --i;
        }
        return res;
    }

    private Method getStringMethod(String methodName) {
        try {
            return this.getClass().getMethod(methodName, String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for " + this.getLocale();
    }
}

