/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.change;

import java.lang.reflect.Constructor;
import java.util.Collection;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.change.CollectionChangeEventCreator;

public class ConstructorCreator
extends CollectionChangeEventCreator {
    public ConstructorCreator(Object src, String propName, Collection oldVal) {
        super(src, propName, oldVal);
    }

    @Override
    protected Collection clone(Collection col) {
        Constructor<?> ctor;
        try {
            ctor = col.getClass().getConstructor(Collection.class);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("oldVal has not accessible constructor");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("oldVal has not a constructor with a single argument of type Collection");
        }
        try {
            return (Collection)ctor.newInstance(col);
        }
        catch (Exception e) {
            throw ExceptionUtils.createExn(IllegalStateException.class, "pb using " + ctor + " with " + col, e);
        }
    }
}

