/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cache;

import org.openconcerto.utils.cache.CacheItem;

public final class CacheResult<V> {
    private static final CacheResult INTERRUPTED = new CacheResult(State.INTERRUPTED);
    private static final CacheResult NOT_IN_CACHE = new CacheResult(State.NOT_IN_CACHE);
    private final State state;
    private final CacheItem<?, V, ?> val;

    static final <V> CacheResult<V> getNotInCache() {
        return NOT_IN_CACHE;
    }

    static final <V> CacheResult<V> getInterrupted() {
        return INTERRUPTED;
    }

    private CacheResult(State state, CacheItem<?, V, ?> val) {
        this.state = state;
        this.val = val;
    }

    CacheResult(CacheItem<?, V, ?> val) {
        this(val.getState() == CacheItem.State.VALID ? State.VALID : State.NOT_IN_CACHE, val);
    }

    private CacheResult(State state) {
        this(state, null);
    }

    public V getRes() {
        if (this.state == State.VALID) {
            return this.val.getValue();
        }
        throw new IllegalStateException(this + " is not valid : " + (Object)((Object)this.getState()));
    }

    public State getState() {
        return this.state;
    }

    final CacheItem<?, V, ?> getVal() {
        return this.val;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + (Object)((Object)this.getState());
    }

    public static enum State {
        VALID,
        NOT_IN_CACHE,
        INTERRUPTED;

    }
}

