/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openconcerto.utils.CollectionMap2;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.ListAbstractMap;
import org.openconcerto.utils.UnmodifiableCollectionMap;

public class ListMap<K, V>
extends ListAbstractMap<K, List<V>, V>
implements CollectionMap2Itf.ListMapItf<K, V> {
    private static ListMap EMPTY = new ListMap(Collections.emptyMap(), CollectionMap2.Mode.NULL_FORBIDDEN){

        @Override
        public ListMap clone() {
            return this;
        }
    };

    public static <K, V> CollectionMap2Itf.ListMapItf<K, V> unmodifiableMap(CollectionMap2Itf.ListMapItf<K, V> map) {
        return new Unmodifiable(map);
    }

    public static <K, V> ListMap<K, V> empty() {
        return EMPTY;
    }

    public static <K, V> ListMap<K, V> singleton(K key, Collection<? extends V> values) {
        return ListMap.singleton(key, new ArrayList<V>(values), false);
    }

    private static <K, V> ListMap<K, V> singleton(K key, List<V> values, boolean immutable) {
        List<V> coll = immutable ? values : Collections.unmodifiableList(values);
        return new ListMap<K, V>((Map)Collections.singletonMap(key, coll), DEFAULT_MODE){

            @Override
            public ListMap<K, V> clone() {
                return this;
            }
        };
    }

    public static <K, V> ListMap<K, V> singleton(K key, V value) {
        return ListMap.singleton(key, Collections.singletonList(value), true);
    }

    public static <K, V> ListMap<K, V> decorate(Map<K, List<V>> m) {
        return new ListMap<K, V>(m, DEFAULT_MODE);
    }

    public ListMap() {
    }

    public ListMap(Map<K, List<V>> delegate, CollectionMap2.Mode mode) {
        super(delegate, mode);
    }

    public ListMap(CollectionMap2<K, List<V>, ? extends V> m) {
        super(m);
    }

    @Override
    public List<V> createCollection(Collection<? extends V> v) {
        return new ArrayList<V>(v);
    }

    @Override
    public ListMap<K, V> clone() throws CloneNotSupportedException {
        return (ListMap)super.clone();
    }

    private static class Unmodifiable<K, V>
    extends UnmodifiableCollectionMap<K, List<V>, V>
    implements CollectionMap2Itf.ListMapItf<K, V> {
        Unmodifiable(CollectionMap2Itf<K, List<V>, V> delegate) {
            super(delegate, new UnmodifiableCollectionMap.UnmodifiableMap<K, List<V>>((Map)delegate){

                @Override
                protected List<V> nonNullToUnmodifiable(List<V> coll) {
                    return Collections.unmodifiableList(coll);
                }
            });
        }
    }
}

