/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.ComboLockedMode;
import org.openconcerto.ui.component.ITextComboCache;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.ui.component.combo.ISearchableComboPopup;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.model.ListComboBoxModel;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class ITextCombo
extends JComboBox
implements InteractionMode.InteractionComponent,
ValueWrapper {
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private final String defaultValue;
    private final ComboLockedMode locked;
    private final ValueChangeSupport<String> supp;
    private KeyListener keyListener = null;
    private DocumentFilter docFilter = null;
    protected final boolean autoComplete;
    protected boolean keyPressed;
    private boolean completing;
    private boolean cacheLoading;
    private String objToSelect;
    private InteractionMode modeToSet;
    private InteractionMode interactionBridge;
    protected boolean modifyingDoc;
    private ITextComboCache cache;

    public ITextCombo() {
        this("");
    }

    public ITextCombo(String defaultValue) {
        this(defaultValue, ComboLockedMode.UNLOCKED);
    }

    public ITextCombo(String defaultValue, ComboLockedMode mode) {
        super(new ListComboBoxModel());
        this.getListModel().setSelectOnAdd(false);
        this.supp = new ValueChangeSupport(this);
        this.locked = mode;
        this.defaultValue = defaultValue;
        this.autoComplete = true;
        this.keyPressed = false;
        this.completing = false;
        this.cache = null;
        this.cacheLoading = false;
        this.modifyingDoc = false;
        this.setMinimumSize(new Dimension(80, 22));
        this.setPreferredSize(new Dimension(120, 22));
        this.setInteractionMode(InteractionMode.READ_WRITE);
        if (this.isLocked()) {
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ITextCombo.this.supp.fireValueChange();
                }
            });
        } else {
            final SimpleDocumentListener docListener = new SimpleDocumentListener(){

                @Override
                public void update(DocumentEvent e) {
                    if (!ITextCombo.this.modifyingDoc) {
                        ITextCombo.this.setValue(SimpleDocumentListener.getText(e.getDocument()));
                    }
                    ITextCombo.this.supp.fireValueChange();
                }
            };
            this.addPropertyChangeListener("editor", new PropertyChangeListener(){
                {
                    this.changeListener(ITextCombo.this.getTextComp(), true);
                    if (!($assertionsDisabled || ITextCombo.this.keyListener == null && ITextCombo.this.docFilter == null)) {
                        throw new AssertionError();
                    }
                }

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    JTextComponent newTextComp;
                    JTextComponent oldTextComp = ITextCombo.this.getTextComp((ComboBoxEditor)evt.getOldValue());
                    if (oldTextComp != null) {
                        this.changeListener(oldTextComp, false);
                        oldTextComp.removeKeyListener(ITextCombo.this.keyListener);
                        DocumentFilterList.remove((AbstractDocument)oldTextComp.getDocument(), ITextCombo.this.docFilter);
                    }
                    if ((newTextComp = ITextCombo.this.getTextComp((ComboBoxEditor)evt.getNewValue())) != null) {
                        this.changeListener(newTextComp, true);
                        ITextCombo.this.addCompletionListeners(newTextComp);
                    }
                }

                private final void changeListener(JTextComponent textComp, boolean add) {
                    if (add) {
                        textComp.getDocument().addDocumentListener(docListener);
                    } else {
                        textComp.getDocument().removeDocumentListener(docListener);
                    }
                }
            });
        }
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component res = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (!isSelected && value != null && value.equals(ITextCombo.this.getValue())) {
                    ISearchableComboPopup.setCurrentValueBG(list, res);
                }
                return res;
            }
        });
        if (Boolean.getBoolean("org.openconcerto.ui.simpleTraversal")) {
            Component[] componentArray = this.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component child = componentArray[n2];
                if (child instanceof JButton || child instanceof Button) {
                    child.setFocusable(false);
                }
                ++n2;
            }
        }
        this.resetValue();
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!anEditor.getItem().equals(anItem)) {
            super.configureEditor(anEditor, anItem);
        }
    }

    private boolean isLocked() {
        return this.locked == ComboLockedMode.LOCKED;
    }

    protected final void addCompletionListeners(JTextComponent textComp) {
        textComp.addKeyListener(this.keyListener);
        DocumentFilterList.add((AbstractDocument)textComp.getDocument(), this.docFilter);
    }

    private ListComboBoxModel getListModel() {
        return (ListComboBoxModel)this.getModel();
    }

    @Override
    public void setInteractionMode(InteractionMode mode) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.cacheLoading) {
            this.modeToSet = mode;
        } else if (mode != this.interactionBridge) {
            this.interactionBridge = mode;
            super.setEnabled(mode.isEditable());
            boolean superEditable = !this.isLocked() || mode == InteractionMode.READ_ONLY;
            super.setEditable(superEditable);
            if (superEditable) {
                JTextComponent comp = this.getTextComp(this.getEditor());
                mode.applyTo(comp);
            } else assert (this.getTextComp(this.getEditor()) == null || !this.getTextComp(this.getEditor()).isDisplayable());
        }
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(b);
    }

    @Override
    public void setEnabled(boolean b) {
        this.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
    }

    private final Object makeObj(String item) {
        return item;
    }

    public final synchronized void setValue(String val) {
        if (!CompareUtils.equals(this.getValue(), val)) {
            if (this.cacheLoading) {
                this.objToSelect = val;
                this.supp.fireValueChange();
            } else {
                this.completing = true;
                this.setSelectedItem(this.makeObj(val));
                this.completing = false;
            }
        }
    }

    public void resetValue() {
        this.setValue(this.defaultValue);
    }

    @Override
    public String getValue() {
        if (this.cacheLoading) {
            return this.objToSelect;
        }
        return this.getCurrentValue();
    }

    public String getCurrentValue() {
        return (String)(this.isLocked() ? this.getSelectedItem() : this.getEditor().getItem());
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    private final JTextComponent getTextComp(ComboBoxEditor editor) {
        Component editorComp;
        if (editor != null && (editorComp = editor.getEditorComponent()) instanceof JTextComponent) {
            return (JTextComponent)editorComp;
        }
        return null;
    }

    public JTextComponent getTextComp() {
        if (this.isLocked()) {
            return null;
        }
        return this.getTextComp(this.getEditor());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + (Object)((Object)this.locked) + " cache: " + this.cache;
    }
}

