/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrderH2;
import org.openconcerto.sql.utils.ReOrderMySQL;
import org.openconcerto.sql.utils.ReOrderPostgreSQL;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.convertor.NumberConvertor;

public abstract class ReOrder {
    public static final BigDecimal MIN_ORDER = BigDecimal.ZERO;
    public static final BigDecimal DISTANCE = BigDecimal.ONE;
    protected final SQLTable t;
    protected final Spec spec;
    private static Spec ALL = new Spec(){

        @Override
        public String getInc() {
            return String.valueOf(DISTANCE);
        }

        @Override
        public final Where getWhere(FieldRef order) {
            return null;
        }

        @Override
        public BigDecimal getFirstToReorder() {
            return MIN_ORDER;
        }

        @Override
        public boolean isFirstToReorderInclusive() {
            return true;
        }

        @Override
        public BigDecimal getFirst() {
            return this.getFirstToReorder();
        }
    };

    public static ReOrder create(SQLTable t) {
        return ReOrder.create(t, ALL);
    }

    private static ReOrder create(SQLTable t, Spec spec) {
        SQLSystem system = t.getBase().getServer().getSQLSystem();
        if (system == SQLSystem.MYSQL) {
            return new ReOrderMySQL(t, spec);
        }
        if (system == SQLSystem.POSTGRESQL) {
            return new ReOrderPostgreSQL(t, spec);
        }
        if (system == SQLSystem.H2) {
            return new ReOrderH2(t, spec);
        }
        throw new IllegalArgumentException((Object)((Object)system) + " not supported");
    }

    protected ReOrder(SQLTable t, Spec spec) {
        this.t = t;
        if (!this.t.isOrdered()) {
            throw new IllegalArgumentException(t + " is not ordered");
        }
        this.spec = spec;
    }

    protected final boolean isAll() {
        return this.spec == ALL;
    }

    protected final BigDecimal getFirstToReorder() {
        return this.spec.getFirstToReorder();
    }

    protected final boolean isFirstToReorderInclusive() {
        return this.spec.isFirstToReorderInclusive();
    }

    protected final BigDecimal getFirstOrderValue() {
        return this.spec.getFirst();
    }

    protected final String getWhere() {
        Where w = this.spec.getWhere(null);
        return w == null ? "" : " where " + w;
    }

    protected final Where getWhere(FieldRef f) {
        return this.spec.getWhere(f);
    }

    public abstract List<String> getSQL(Connection var1, BigDecimal var2) throws SQLException;

    public final boolean exec() throws SQLException {
        final UpdateBuilder updateUndef = new UpdateBuilder(this.t).setObject(this.t.getOrderField(), (Object)MIN_ORDER);
        updateUndef.setWhere(new Where((FieldRef)this.t.getKey(), "=", this.t.getUndefinedID()));
        return (Boolean)SQLUtils.executeAtomic(this.t.getBase().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException, SQLException {
                Connection conn = ds.getConnection();
                Statement stmt = conn.createStatement();
                if (ReOrder.this.isAll()) {
                    stmt.execute(updateUndef.asString());
                }
                stmt.execute("SELECT " + ReOrder.this.spec.getInc());
                BigDecimal inc = NumberConvertor.toBigDecimal((Number)SQLDataSource.SCALAR_HANDLER.handle(stmt.getResultSet()));
                if (inc.compareTo(ReOrder.this.t.getOrderULP().scaleByPowerOfTen(1)) < 0) {
                    return false;
                }
                for (String s : ReOrder.this.getSQL(conn, inc)) {
                    stmt.execute(s);
                }
                ReOrder.this.t.fireTableModified(-1, Collections.singletonList(ReOrder.this.t.getOrderField().getName()));
                return true;
            }
        });
    }

    static interface Spec {
        public String getInc();

        public Where getWhere(FieldRef var1);

        public BigDecimal getFirstToReorder();

        public boolean isFirstToReorderInclusive();

        public BigDecimal getFirst();
    }
}

