/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.request.SQLCacheWatcher;
import org.openconcerto.sql.users.UserSingleton;
import org.openconcerto.sql.users.UserSingletonManager;
import org.openconcerto.sql.users.rights.LockAdminUserRight;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.CacheWatcher;
import org.openconcerto.utils.cache.CacheWatcherFactory;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cache.ICacheSupport;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public class UserRightsManager
implements UserSingleton {
    private static final UserSingletonManager<UserRightsManager> sMngr = new UserSingletonManager<UserRightsManager>("USER_RIGHT"){

        @Override
        protected UserRightsManager createInstance(SQLTable t) {
            return new UserRightsManager(t, null);
        }
    };
    private static final ListMap<String, Tuple2<String, Boolean>> SUPERUSER_RIGHTS = ListMap.singleton(null, Tuple2.create(null, true));
    private static final ListMap<String, Tuple2<String, Boolean>> NO_RIGHTS = ListMap.singleton(null, Tuple2.create(null, false));
    public static final List<MacroRight> DEFAULT_MACRO_RIGHTS = Collections.synchronizedList(new ArrayList());
    private final Map<String, MacroRight> macroRights;
    private final Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> rights;
    private final SQLCache<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> cache;
    private final SQLTable table;
    private final Link toUserLink;
    private final JavaRights javaRights;
    private final Map userRights;
    private final ExecutorService exec;

    static {
        DEFAULT_MACRO_RIGHTS.add(new LockAdminUserRight());
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(true));
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(false));
    }

    public static UserSingletonManager<UserRightsManager> getSingletonManager() {
        return sMngr;
    }

    private UserRightsManager(SQLTable t) {
        if (t == null) {
            throw new NullPointerException("Missing table");
        }
        this.macroRights = Collections.synchronizedMap(new HashMap());
        this.rights = new HashMap<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>>();
        this.cache = new SQLCache<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>>(900, -1, "Cache of rights"){

            @Override
            protected ICacheSupport<SQLData> createSupp(String name) {
                ICacheSupport<SQLData> res = new ICacheSupport<SQLData>(name);
                res.setWatcherFactory(new CacheWatcherFactory<SQLData>(){

                    @Override
                    public CacheWatcher<SQLData> createWatcher(SQLData o) {
                        if (o instanceof JavaRightsUser) {
                            return new JavaRightsWatcher((JavaRightsUser)o);
                        }
                        return new SQLCacheWatcher(o);
                    }
                });
                return res;
            }
        };
        this.javaRights = new JavaRights();
        this.table = t;
        this.toUserLink = t.getFieldGroups().get("ID_USER_COMMON").getKey().getForeignLink();
        this.defaultRegister();
        this.userRights = new HashMap();
        this.exec = Executors.newSingleThreadExecutor(new ThreadFactory(String.valueOf(this.getClass().getSimpleName()) + " executor for " + t.getSQLName(), true).setPriority(1));
        this.cache.addItemListener(new IClosure<ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, SQLData>>(){

            public void executeChecked(ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, SQLData> evt) {
                UserRightsManager.this.cacheChanged(evt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheChanged(ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, ?> evt) {
        if (evt.getPropertyName().equals("itemAdded")) {
            Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
            synchronized (map) {
                this.rights.put((Integer)((CacheItem)evt.getNewValue()).getKey(), (CollectionMap2Itf.ListMapItf)((CacheItem)evt.getNewValue()).getValue());
            }
        }
        if (evt.getPropertyName().equals("itemRemoved")) {
            final Integer userID = (Integer)((CacheItem)evt.getOldValue()).getKey();
            CacheItem.RemovalType removalType = ((CacheItem)evt.getOldValue()).getRemovalType();
            if (removalType == CacheItem.RemovalType.DATA_CHANGE || removalType == CacheItem.RemovalType.TIMEOUT) {
                this.invokeLater(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        UserRightsManager.this.getRightsForUser(userID, false);
                        return null;
                    }
                });
            } else {
                assert (removalType != CacheItem.RemovalType.SIZE_LIMIT);
                Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
                synchronized (map) {
                    this.rights.remove(userID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultRegister() {
        List<MacroRight> list = DEFAULT_MACRO_RIGHTS;
        synchronized (list) {
            for (MacroRight macroRight : DEFAULT_MACRO_RIGHTS) {
                this.register(macroRight);
            }
        }
    }

    public void register(MacroRight userRight) {
        if (userRight == null) {
            throw new IllegalArgumentException("Missing right");
        }
        this.macroRights.put(userRight.getCode(), userRight);
    }

    public final synchronized boolean isValid() {
        return !this.cache.getSupp().isDying();
    }

    @Override
    public final synchronized void destroy() {
        if (this.isValid()) {
            this.cache.getSupp().die();
            this.exec.shutdown();
        }
        assert (!this.isValid());
    }

    @Override
    public final SQLTable getTable() {
        return this.table;
    }

    public final DBRoot getRoot() {
        return this.getTable().getDBRoot();
    }

    private final SQLTable getUserTable() {
        return (SQLTable)this.toUserLink.getTarget();
    }

    public final synchronized <T> Future<T> invokeLater(Callable<T> c) {
        if (!this.isValid()) {
            return null;
        }
        return this.exec.submit(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> getRightsForUser(int userID, boolean checkMap) {
        CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> res;
        if (checkMap) {
            Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
            synchronized (map) {
                if (this.rights.containsKey(userID)) {
                    return this.rights.get(userID);
                }
            }
        }
        HashSet<SQLData> data = new HashSet<SQLData>();
        data.add(new SQLRow(this.getUserTable(), userID));
        data.add(this.getTable());
        data.add(new JavaRightsUser(this.javaRights, userID));
        data.add(new JavaRightsUser(this.javaRights, -1));
        data.add(new JavaRightsUser(this.javaRights, this.getDefaultUserId()));
        CacheResult cached = this.cache.check(userID, data);
        if (cached.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (cached.getState() == CacheResult.State.VALID) {
            return (CollectionMap2Itf.ListMapItf)cached.getRes();
        }
        try {
            res = this.loadRightsForUser(userID);
            this.cache.put(cached, res);
        }
        catch (RuntimeException exn) {
            this.cache.removeRunning((Integer)((Object)cached));
            throw exn;
        }
        assert (res != null);
        return res;
    }

    private final CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> loadRightsForUser(final int userID) {
        CollectionMap2Itf.ListMapItf<Integer, RightTuple> javaRights = this.javaRights.getTuples();
        try {
            int defaultUser;
            SQLRow userRow = new SQLRow(this.getUserTable(), userID).fetchValues(false);
            if (userRow != null && userRow.getBoolean("SUPERUSER").booleanValue()) {
                return SUPERUSER_RIGHTS;
            }
            ListMap<String, Tuple2<String, Boolean>> res = new ListMap<String, Tuple2<String, Boolean>>();
            HashSet<Tuple2<String, String>> unicity = new HashSet<Tuple2<String, String>>();
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_MODIF_RIGHTS", this.getTable().getForeignTable("ID_RIGHT"), false));
            boolean isAdmin = userRow != null && userRow.getBoolean("ADMIN") != false;
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_RIGHTS", this.getTable(), isAdmin));
            for (RightTuple t : (List)javaRights.getNonNull(userID)) {
                this.expand(res, unicity, t);
            }
            if (isAdmin) {
                for (RightTuple t : (List)javaRights.getNonNull(-1)) {
                    this.expand(res, unicity, t);
                }
            }
            if ((defaultUser = this.getDefaultUserId()) != userID) {
                for (RightTuple t : (List)javaRights.getNonNull(defaultUser)) {
                    this.expand(res, unicity, t);
                }
            }
            SQLRowValues vals = new SQLRowValues(this.getTable()).setAllToNull();
            vals.putRowValues("ID_RIGHT").setAllToNull();
            SQLRowValuesListFetcher sel = new SQLRowValuesListFetcher(vals);
            sel.setOrdered(true);
            sel.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                public SQLSelect transformChecked(SQLSelect sel) {
                    sel.setWhere(new Where((FieldRef)UserRightsManager.this.toUserLink.getLabel(), "=", userID));
                    return sel;
                }
            });
            List<SQLRowValues> list = sel.fetch();
            for (SQLRowValues row : list) {
                SQLRowAccessor right = row.getForeign("ID_RIGHT");
                if (row.isUndefined()) {
                    Log.get().warning(row.asRow() + " has undef right");
                    continue;
                }
                String rightCode = right.getString("CODE");
                if (rightCode == null) {
                    Log.get().warning(right + " has null CODE");
                    continue;
                }
                String object = row.getString("OBJECT");
                Boolean haveRight = row.getBoolean("HAVE_RIGHT");
                this.expand(res, unicity, rightCode, object, haveRight);
            }
            return ListMap.unmodifiableMap(res);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors du chargement des droits utilisateurs pour l'utilisateur (Id:" + userID + ")", e);
            return NO_RIGHTS;
        }
    }

    private final void expand(ListMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, RightTuple t) {
        this.expand(res, unicity, (String)t.get0(), (String)t.get1(), (Boolean)t.get2());
    }

    private final void expand(ListMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, String rightCode, String object, Boolean haveRight) {
        if (haveRight == null) {
            throw new IllegalStateException("HAVE_RIGHT cannot be null");
        }
        MacroRight macroRight = this.macroRights.get(rightCode);
        if (macroRight != null) {
            for (RightTuple t : macroRight.expand(this, rightCode, object, haveRight)) {
                this.expand(res, unicity, t);
            }
        } else if (unicity.add(Tuple2.create(rightCode, object))) {
            res.add(rightCode, Tuple2.create(object, haveRight));
        }
    }

    final int getDefaultUserId() {
        return this.getUserTable().getUndefinedID();
    }

    /* synthetic */ UserRightsManager(SQLTable sQLTable, UserRightsManager userRightsManager) {
        this(sQLTable);
    }

    private static final class JavaRights {
        private CollectionMap2Itf.ListMapItf<Integer, RightTuple> tuples;
        private final PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

        public JavaRights() {
            this.tuples = ListMap.empty();
        }

        final synchronized CollectionMap2Itf.ListMapItf<Integer, RightTuple> getTuples() {
            return this.tuples;
        }
    }

    private static class JavaRightsUser
    implements SQLData {
        private final JavaRights rights;
        private final int id;

        public JavaRightsUser(JavaRights rights, int id) {
            this.rights = rights;
            this.id = id;
        }

        @Override
        public SQLTableModifiedListener createTableListener(SQLDataListener l) {
            return null;
        }

        @Override
        public SQLTable getTable() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + this.rights.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaRightsUser other = (JavaRightsUser)obj;
            return this.id == other.id && this.rights.equals(other.rights);
        }
    }

    private static class JavaRightsWatcher
    extends CacheWatcher<SQLData> {
        private final int id;
        private final PropertyChangeListener l;

        public JavaRightsWatcher(JavaRightsUser u) {
            super(u);
            this.id = u.id;
            this.l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (((Number)evt.getNewValue()).intValue() == JavaRightsWatcher.this.id) {
                        JavaRightsWatcher.this.dataChanged(evt);
                    }
                }
            };
        }

        @Override
        protected void startWatching() {
            ((JavaRightsUser)this.getData()).rights.propSupp.addPropertyChangeListener("tuple", this.l);
        }

        @Override
        protected void stopWatching() {
            ((JavaRightsUser)this.getData()).rights.propSupp.removePropertyChangeListener("tuple", this.l);
        }
    }

    public static final class RightTuple
    extends Tuple3<String, String, Boolean> {
        public RightTuple(String code, boolean haveRight) {
            this(code, null, haveRight);
        }

        public RightTuple(String code, String object, boolean haveRight) {
            super(code, object, haveRight);
        }
    }
}

