/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.UserRightsManager;

public class TableAllRights
extends MacroRight {
    public static UserRightsManager.RightTuple createRight(SQLTable t, boolean b) {
        return TableAllRights.createRight("TABLE_ALL_RIGHTS", t, b);
    }

    public static UserRightsManager.RightTuple createRight(String code, SQLTable t, boolean b) {
        return new UserRightsManager.RightTuple(code, TableAllRights.tableToString(t), b);
    }

    private static SQLName tableName(SQLTable t, boolean exact) {
        if (t == null) {
            return null;
        }
        return exact ? t.getSQLName(t.getDBRoot()) : new SQLName(t.getName());
    }

    public static String tableToString(SQLTable t) {
        return TableAllRights.tableToString(t, true);
    }

    public static String tableToString(SQLTable t, boolean exact) {
        return t == null ? null : TableAllRights.tableName(t, exact).quote();
    }

    public TableAllRights() {
        this(true);
    }

    public TableAllRights(boolean includeView) {
        super(includeView ? "TABLE_ALL_RIGHTS" : "TABLE_ALL_MODIF_RIGHTS");
    }

    @Override
    public List<UserRightsManager.RightTuple> expand(UserRightsManager mngr, String rightCode, String object, boolean haveRight) {
        ArrayList<UserRightsManager.RightTuple> res = new ArrayList<UserRightsManager.RightTuple>();
        res.add(new UserRightsManager.RightTuple("DELETE_ROW", object, haveRight));
        res.add(new UserRightsManager.RightTuple("UPDATE_ROW", object, haveRight));
        res.add(new UserRightsManager.RightTuple("INSERT_ROW", object, haveRight));
        if (this.getCode() == "TABLE_ALL_RIGHTS") {
            res.add(new UserRightsManager.RightTuple("SELECT_ROW", object, haveRight));
        }
        return res;
    }
}

