/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;

public class Step {
    private final SQLTable from;
    private final SQLTable to;
    private final Map<Link, Link.Direction> links;
    private final SQLField singleField;
    private Set<SQLField> singleFields;
    private boolean singleFieldsComputed;

    public static final Step create(SQLTable start, SQLTable end) {
        return Step.create(start, end, Link.Direction.ANY);
    }

    public static final Step create(SQLTable start, SQLTable end, Link.Direction dir) {
        Set<Link> set;
        if (dir == Link.Direction.ANY) {
            set = start.getDBSystemRoot().getGraph().getLinks(start, end);
        } else if (dir == Link.Direction.FOREIGN) {
            set = start.getDBSystemRoot().getGraph().getForeignLinks(start, end);
        } else if (dir == Link.Direction.REFERENT) {
            set = start.getDBSystemRoot().getGraph().getForeignLinks(end, start);
        } else {
            throw new IllegalStateException("Unknown direction " + (Object)((Object)dir));
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("path is broken between " + start + " and " + end + " in direction " + (Object)((Object)dir));
        }
        if (dir == Link.Direction.ANY) {
            return Step.create(start, set);
        }
        HashMap<Link, Link.Direction> links = new HashMap<Link, Link.Direction>(set.size());
        for (Link l : set) {
            links.put(l, dir);
        }
        return new Step(start, links, end);
    }

    public static final Step create(SQLTable start, Collection<Link> links) {
        if (links.size() == 0) {
            throw new IllegalArgumentException("empty fields");
        }
        SQLTable end = links.iterator().next().oppositeVertex(start);
        if (start == end) {
            throw new IllegalArgumentException("start and end are the same: " + links + " the direction can't be inferred");
        }
        HashMap<Link, Link.Direction> directions = new HashMap<Link, Link.Direction>();
        for (Link l : links) {
            if (end != l.oppositeVertex(start)) {
                throw new IllegalArgumentException("fields do not point to the same table: " + links);
            }
            directions.put(l, Link.Direction.fromForeign(start == l.getSource()));
        }
        return new Step(start, directions, end);
    }

    public static final Step create(SQLField fField, Link.Direction direction) throws IllegalArgumentException {
        Link l = fField.getDBSystemRoot().getGraph().getForeignLink(fField);
        if (l == null) {
            throw new IllegalArgumentException(fField + " is not a foreign field.");
        }
        return Step.create(Collections.singletonMap(l, direction));
    }

    private static final Tuple2.List2<SQLTable> getStartEnd(Link l, Link.Direction dir) {
        if (dir == Link.Direction.ANY) {
            throw new IllegalArgumentException("Unspecified direction");
        }
        if (dir == Link.Direction.FOREIGN) {
            return new Tuple2.List2<SQLTable>((SQLTable)l.getSource(), (SQLTable)l.getTarget());
        }
        return new Tuple2.List2<SQLTable>((SQLTable)l.getTarget(), (SQLTable)l.getSource());
    }

    public static final Step create(Map<Link, Link.Direction> links) {
        Tuple2.List2<SQLTable> startEnd = null;
        for (Map.Entry<Link, Link.Direction> e : links.entrySet()) {
            Tuple2.List2<SQLTable> currentStartEnd = Step.getStartEnd(e.getKey(), e.getValue());
            if (startEnd == null) {
                startEnd = currentStartEnd;
                continue;
            }
            if (startEnd.equals(currentStartEnd)) continue;
            throw new IllegalArgumentException("Start and end tables differ " + startEnd + " != " + currentStartEnd);
        }
        if (startEnd == null) {
            throw new IllegalArgumentException("empty links");
        }
        return new Step((SQLTable)startEnd.get0(), links, (SQLTable)startEnd.get1());
    }

    private Step(SQLTable start, Map<Link, Link.Direction> fields, SQLField singleField, SQLTable end) {
        assert (start != null && end != null);
        assert (fields.size() > 0);
        assert (!new HashSet<Link.Direction>(fields.values()).contains((Object)Link.Direction.ANY)) : "some directions are unknown : " + fields;
        assert (fields instanceof AbstractMap) : "Fields might not be thread-safe";
        this.from = start;
        this.to = end;
        this.links = Collections.unmodifiableMap(fields);
        this.singleField = singleField;
        if (singleField == null) {
            this.singleFields = null;
            this.singleFieldsComputed = false;
        } else {
            this.singleFields = Collections.singleton(singleField);
            this.singleFieldsComputed = true;
        }
    }

    private Step(SQLTable start, Map<Link, Link.Direction> fields, SQLTable end) {
        this(start, new HashMap<Link, Link.Direction>(fields), fields.size() == 1 ? CollectionUtils.getSole(fields.keySet()).getSingleField() : null, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Step reverse() {
        HashMap<Link, Link.Direction> reverseFields = new HashMap<Link, Link.Direction>(this.links.size());
        for (Map.Entry<Link, Link.Direction> e : this.links.entrySet()) {
            reverseFields.put(e.getKey(), e.getValue().reverse());
        }
        Step res = new Step(this.to, reverseFields, this.singleField, this.from);
        Step step = this;
        synchronized (step) {
            res.singleFields = this.singleFields;
            res.singleFieldsComputed = this.singleFieldsComputed;
        }
        return res;
    }

    public final SQLTable getFrom() {
        return this.from;
    }

    public final SQLTable getTo() {
        return this.to;
    }

    public final Set<Link> getLinks() {
        return this.links.keySet();
    }

    public final SQLField getSingleField() {
        return this.singleField;
    }

    public boolean isSingleLink() {
        return this.links.size() == 1;
    }

    public final boolean isForeign(Link f) {
        return this.getDirection(f) == Link.Direction.FOREIGN;
    }

    public final Link.Direction getDirection(Link f) {
        return this.links.get(f);
    }

    public final Boolean isForeign() {
        Link.Direction soleDir = this.getDirection();
        return soleDir == Link.Direction.ANY ? null : Boolean.valueOf(soleDir == Link.Direction.FOREIGN);
    }

    public final Link.Direction getDirection() {
        Link.Direction soleDir = CollectionUtils.getSole(new HashSet<Link.Direction>(this.links.values()));
        return soleDir == null ? Link.Direction.ANY : soleDir;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append(" from: ");
        sb.append(this.getFrom());
        sb.append(" through: ");
        this.linksToString(sb);
        sb.append(" to: ");
        sb.append(this.getTo());
        return sb.toString();
    }

    public StringBuilder linksToString(StringBuilder sb) {
        boolean moreThan1;
        assert (this.links.size() > 0);
        String sep = " ; ";
        boolean bl = moreThan1 = this.links.size() > 1;
        if (moreThan1) {
            sb.append("{ ");
        }
        for (Map.Entry<Link, Link.Direction> e : this.links.entrySet()) {
            Link.Direction dir = e.getValue();
            assert (dir != Link.Direction.ANY);
            boolean foreign = dir == Link.Direction.FOREIGN;
            sb.append(foreign ? "--" : "<--");
            sb.append(e.getKey().getCols());
            sb.append(foreign ? "-->" : "--");
            sb.append(" ; ");
        }
        sb.setLength(sb.length() - " ; ".length());
        if (moreThan1) {
            sb.append(" }");
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Step) {
            Step o = (Step)obj;
            return this.from.equals(o.from) && this.links.equals(o.links);
        }
        return false;
    }

    public int hashCode() {
        return this.links.hashCode();
    }
}

