/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.List;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.TableRef;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;

public final class SQLSelectHandlerBuilder {
    private final SQLSelect sel;
    private Value<TableRef> t;
    private boolean readCache;
    private boolean writeCache;

    public SQLSelectHandlerBuilder(SQLSelect sel) {
        if (sel == null) {
            throw new NullPointerException("Null query");
        }
        this.sel = sel;
        this.t = Value.getNone();
        this.setUseCache(true);
    }

    public SQLSelectHandlerBuilder setUseCache(boolean b) {
        this.setReadCache(b);
        this.setWriteCache(b);
        return this;
    }

    public SQLSelectHandlerBuilder setReadCache(boolean b) {
        this.readCache = b;
        return this;
    }

    public final boolean isReadCache() {
        return this.readCache;
    }

    public SQLSelectHandlerBuilder setWriteCache(boolean b) {
        this.writeCache = b;
        return this;
    }

    public final boolean isWriteCache() {
        return this.writeCache;
    }

    public IResultSetHandler createHandler() {
        Tuple2<SQLTable, List<String>> indexes = SQLRowListRSH.getIndexes(this.sel, this.t.toNonNull(), !this.t.hasValue());
        return SQLRowListRSH.createFromSelect(this.sel, indexes, this.isReadCache(), this.isWriteCache());
    }

    public List<SQLRow> execute() {
        return (List)this.sel.getSystemRoot().getDataSource().execute(this.sel.asString(), this.createHandler());
    }
}

