/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.utils.cc.IPredicate;

public abstract class SQLIdentifier
extends DBStructureItemJDBC {
    protected SQLIdentifier(DBStructureItemJDBC parent, String name) {
        super(parent, name);
    }

    protected final Object getTreeMutex() {
        Object res = this.getDBSystemRoot().getTreeMutex();
        assert (Thread.holdsLock(res) || !Thread.holdsLock(this)) : "Trying to lock treeMutex after locking this : " + this;
        return res;
    }

    public final String getQuotedName() {
        return SQLBase.quoteIdentifier(this.getName());
    }

    public final SQLName getSQLName() {
        return this.getSQLName(null);
    }

    public final SQLName getSQLName(DBStructureItem ancestor) {
        return this.getSQLName(ancestor, true);
    }

    public final SQLName getSQLName(DBStructureItem ancestor, boolean includeAncestor) {
        ArrayList<String> res = new ArrayList<String>();
        SQLIdentifier current = this;
        while (current != null && !current.isAlterEgoOf(ancestor)) {
            res.add(0, current.getName());
            SQLIdentifier sQLIdentifier = current = current.getParent() instanceof SQLIdentifier ? (SQLIdentifier)current.getParent() : null;
        }
        if (current == null && ancestor != null) {
            throw new IllegalArgumentException(ancestor + " is not an ancestor of " + this);
        }
        if (includeAncestor && ancestor != null) {
            res.add(0, ancestor.getName());
        }
        return new SQLName(res);
    }

    public final SQLName getContextualSQLName(SQLIdentifier from) {
        DBStructureItemJDBC common = this.getCommonAncestor(from);
        if (common instanceof SQLIdentifier) {
            return this.getSQLName(common, common == this);
        }
        return this.getSQLName();
    }

    public final SQLName getSQLNameUntilDBRoot(boolean includeAncestor) {
        return this.getSQLName(DBRoot.class, includeAncestor);
    }

    final <D extends DBStructureItemDB> SQLName getSQLName(final Class<D> ancestorClass, boolean includeAncestor) {
        SQLIdentifier ancestor = this.findAncestor(new IPredicate<SQLIdentifier>(){

            public boolean evaluateChecked(SQLIdentifier input) {
                return ancestorClass.isInstance(input.getRawAlterEgo());
            }
        });
        if (ancestor == null) {
            throw new IllegalArgumentException("no SQLIdentifier ancestor of " + this + " is of class " + ancestorClass);
        }
        return this.getSQLName(ancestor, includeAncestor);
    }

    private final SQLIdentifier findAncestor(IPredicate<SQLIdentifier> pred) {
        SQLIdentifier current = this;
        while (current != null && !pred.evaluateChecked(current)) {
            SQLIdentifier sQLIdentifier = current = current.getParent() instanceof SQLIdentifier ? (SQLIdentifier)current.getParent() : null;
        }
        return current;
    }
}

