/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.utils.EnumOrderedSet;

public class DBStructureItemDB
extends DBStructureItem<DBStructureItemDB> {
    private final DBStructureItemJDBC jdbc;
    private Map<String, ? extends DBStructureItemJDBC> childrenJDBC;
    private Map<String, DBStructureItemDB> children;

    static DBStructureItemDB create(DBStructureItemJDBC jdbc) {
        if (DBStructureItemDB.isOfLevel(jdbc, DBSystemRoot.class)) {
            return new DBSystemRoot(jdbc);
        }
        if (DBStructureItemDB.isOfLevel(jdbc, DBRoot.class)) {
            return new DBRoot(jdbc);
        }
        if (jdbc.getServer().getSQLSystem().getLevels().contains(jdbc.getLevel())) {
            return new DBStructureItemDB(jdbc);
        }
        return null;
    }

    private static boolean isOfLevel(DBStructureItemJDBC jdbc, Class<? extends DBStructureItemDB> c) {
        return jdbc.getServer().getSQLSystem().getDBLevel(c).equals((Object)jdbc.getLevel());
    }

    protected DBStructureItemDB(DBStructureItemJDBC jdbc) {
        super(DBStructureItemDB.getDB(jdbc.getParent()), jdbc.getName());
        this.jdbc = jdbc;
    }

    protected final void checkDropped() {
        this.getJDBC().checkDropped();
    }

    @Override
    public final DBStructureItemJDBC getJDBC() {
        return this.jdbc;
    }

    @Override
    protected DBStructureItemDB getDB() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ? extends DBStructureItemDB> getChildrenMap() {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent == null) {
            return Collections.emptyMap();
        }
        Map jdbcChildren = nonNullDBParent.getChildrenMap();
        assert (jdbcChildren != null) : "Cannot be null for the first comparison (when this.childrenJDBC is null)";
        Map<String, DBStructureItemDB> res = null;
        DBStructureItemDB dBStructureItemDB = this;
        synchronized (dBStructureItemDB) {
            if (this.childrenJDBC == jdbcChildren) {
                res = this.children;
                assert (res != null) : "Cannot be null for the comparison below";
            }
        }
        if (res == null) {
            res = new HashMap<String, DBStructureItemDB>(jdbcChildren.size());
            for (Map.Entry e : jdbcChildren.entrySet()) {
                res.put(e.getKey(), DBStructureItemDB.getDB((DBStructureItem)e.getValue()));
            }
            res = Collections.unmodifiableMap(res);
            dBStructureItemDB = this;
            synchronized (dBStructureItemDB) {
                this.childrenJDBC = jdbcChildren;
                this.children = res;
            }
        }
        return res;
    }

    public final void addChildrenListener(PropertyChangeListener l) {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent != null) {
            nonNullDBParent.addChildrenListener(l);
        }
    }

    public final void rmChildrenListener(PropertyChangeListener l) {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent != null) {
            nonNullDBParent.rmChildrenListener(l);
        }
    }

    @Override
    protected final EnumOrderedSet<HierarchyLevel> getLevels() {
        return this.getServer().getSQLSystem().getLevels();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getJDBC();
    }
}

