/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.changer.convert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.sql.utils.SQLCreateTableBase;

public class AddMDFields
extends Changer<SQLTable> {
    private static final List<String> fields = new ArrayList<String>();

    static {
        fields.add("ID_USER_COMMON_CREATE");
        fields.add("ID_USER_COMMON_MODIFY");
        fields.add("CREATION_DATE");
        fields.add("MODIFICATION_DATE");
    }

    private static Collection<String> getFKFields() {
        return fields.subList(0, 2);
    }

    private static Collection<String> getDateFields() {
        return fields.subList(2, 4);
    }

    public static final void addFields(SQLCreateTableBase<?> createTable, SQLTable userT) {
        if (userT == null) {
            throw new IllegalArgumentException("Missing user table");
        }
        for (String fk : AddMDFields.getFKFields()) {
            createTable.addForeignColumn(fk, userT);
        }
        for (String fk : AddMDFields.getDateFields()) {
            createTable.addDateAndTimeColumn(fk);
        }
    }

    @Override
    protected void changeImpl(SQLTable table) throws SQLException {
        if (this.testTable(table) && !table.getFieldsName().containsAll(fields)) {
            SQLTable userT = table.getDBRoot().findTable("USER_COMMON");
            if (userT == null) {
                throw new IllegalStateException("No table USER_COMMON found");
            }
            AlterTable alter = new AlterTable(table);
            for (String fk : AddMDFields.getFKFields()) {
                if (table.contains(fk)) continue;
                alter.addForeignColumn(fk, userT);
            }
            for (String fk : AddMDFields.getDateFields()) {
                if (table.contains(fk)) continue;
                alter.addDateAndTimeColumn(fk);
            }
            this.getDS().execute(alter.asString());
            table.fetchFields();
            table.getSchema().updateVersion();
            this.getStream().println("added metadata fields on " + table.getSQLName());
        }
    }

    private boolean testTable(SQLTable table) {
        return table.isRowable() && table.getOrderField() != null;
    }
}

