/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;

public final class State {
    public static final State INSTANCE = new State();
    private final DateFormat TIME_FMT;
    private final List<String> requests = new ArrayList<String>();
    private final List<String> failed = new ArrayList<String>();
    private int failedStmts = 0;
    private int connectionTotalCount = 0;
    private int connectionCount = 0;
    private int requestsTotalCount = 0;
    private final long upDate = System.currentTimeMillis();
    private int frameCount = 0;
    private int framesVisible = 0;
    private int cacheHit = 0;

    private State() {
        this.TIME_FMT = DateFormat.getTimeInstance();
        this.TIME_FMT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public synchronized void beginRequest(String req) {
        this.requests.add(req);
        ++this.requestsTotalCount;
    }

    public synchronized void endRequest(String req) {
        this.requests.remove(req);
    }

    public synchronized void addFailedRequest(String query) {
        this.failed.add(query);
    }

    public synchronized void connectionCreated() {
        ++this.connectionTotalCount;
        ++this.connectionCount;
    }

    public synchronized void connectionRemoved() {
        --this.connectionCount;
    }

    public synchronized void addCacheHit() {
        ++this.cacheHit;
    }
}

