/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.BaseDirs;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.LogUtils;
import org.openconcerto.utils.MultipleOutputStream;
import org.openconcerto.utils.NetUtils;
import org.openconcerto.utils.ProductInfo;
import org.openconcerto.utils.StreamUtils;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IPredicate;

public class PropsConfiguration
extends Configuration {
    public static final String EMPTY_PROP_VALUE;
    private static final DateFormat DATE_FORMAT;
    public static final Properties DEFAULTS;
    private final Properties props;
    private SQLServer server;
    private DBSystemRoot sysRoot;
    private DBRoot root;
    private UserManager uMngr;
    private UserRightsManager urMngr;
    private ProductInfo productInfo;
    private SQLFilter filter;
    private final Addable<SQLElementDirectory> directory;
    private File wd;
    private BaseDirs baseDirs;
    private File logDir;
    private final boolean inIDE;
    private final Object treeLock = new String("treeLock");
    private final Object restLock = new String("everythingElseLock");
    private Session conn;
    private boolean isUsingSSH;
    private boolean destroyed;

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM/dd_EEEE");
        DEFAULTS = new Properties();
        File wd = new File(System.getProperty("user.dir"));
        DEFAULTS.setProperty("wd", wd.getPath());
        DEFAULTS.setProperty("customer", "test");
        DEFAULTS.setProperty("server.ip", "127.0.0.1");
        DEFAULTS.setProperty("server.login", "root");
        EMPTY_PROP_VALUE = "";
        assert (EMPTY_PROP_VALUE != null);
    }

    public static String getHostname() {
        InetAddress addr;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "local";
        }
        return addr.getHostName();
    }

    protected static Properties create(InputStream f, Properties defaults) throws IOException {
        Properties props = new Properties(defaults);
        if (f != null) {
            props.load(f);
            f.close();
        }
        return props;
    }

    public PropsConfiguration() throws IOException {
        this(new File("fwk_SQL.properties"), DEFAULTS);
    }

    public PropsConfiguration(File f, Properties defaults) throws IOException {
        this(new FileInputStream(f), defaults);
    }

    public PropsConfiguration(InputStream f, Properties defaults) throws IOException {
        this(PropsConfiguration.create(f, defaults));
    }

    public PropsConfiguration(Properties props) {
        this.props = props;
        this.directory = new Addable<SQLElementDirectory>(this){

            @Override
            protected void destroy(Future<SQLElementDirectory> future) {
                super.destroy(future);
                try {
                    future.get().destroy();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Couldn't destroy the directory", e);
                }
            }
        };
        this.inIDE = Boolean.getBoolean("inIDE");
        this.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            if (this.server != null) {
                this.server.destroy();
            }
            this.closeSSLConnection();
            if (this.uMngr != null) {
                UserManager.getSingletonManager().clearInstanceIfSame(this.uMngr);
                this.uMngr.destroy();
            }
            if (this.urMngr != null) {
                UserRightsManager.getSingletonManager().clearInstanceIfSame(this.urMngr);
                this.urMngr.destroy();
            }
        }
        this.directory.destroy();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDestroyed() {
        Object object = this.treeLock;
        synchronized (object) {
            return this.destroyed;
        }
    }

    private final void checkDestroyed() {
        PropsConfiguration.checkDestroyed(this.isDestroyed());
    }

    private static final void checkDestroyed(boolean d) {
        if (d) {
            throw new IllegalStateException("Destroyed");
        }
    }

    public final boolean isInIDE() {
        return this.inIDE;
    }

    public final String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public final String getProperty(String name, String def) {
        return this.props.getProperty(name, def);
    }

    protected final void setProperty(String name, String val) {
        if (val == null) {
            this.props.remove(name);
        } else {
            this.props.setProperty(name, val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProductInfo(ProductInfo productInfo) {
        Object object = this.restLock;
        synchronized (object) {
            this.productInfo = productInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUp() {
        Object object = this.treeLock;
        synchronized (object) {
            this.destroyed = false;
            this.server = null;
            this.sysRoot = null;
            this.root = null;
        }
        object = this.restLock;
        synchronized (object) {
            this.setProductInfo(ProductInfo.getInstance());
            this.setFilter(null);
        }
    }

    public final SQLSystem getSystem() {
        return SQLSystem.get(this.getProperty("server.driver"));
    }

    protected String getLogin() {
        return this.getProperty("server.login");
    }

    protected String getPassword() {
        return this.getProperty("server.password");
    }

    private File getFile(String name) {
        return new File(name.startsWith("/") ? name.substring(1) : name);
    }

    private boolean mustUseClassloader(File f) {
        return this.getFileMode() == FileMode.IN_JAR || !f.exists();
    }

    public final String getResource(String name) {
        File f = this.getFile(name);
        if (this.mustUseClassloader(f)) {
            return this.getClass().getResource(name).toExternalForm();
        }
        return f.getAbsolutePath();
    }

    protected FileMode getFileMode() {
        return FileMode.IN_JAR;
    }

    protected final DBRoot createRoot() {
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            return this.getSystemRoot().getRoot(rootName.getValue());
        }
        throw new NullPointerException("no rootname");
    }

    protected UserRightsManager createUserRightsManager(DBRoot root) {
        return UserRightsManager.getSingletonManager().setInstanceIfNone(root);
    }

    public String getRootName() {
        return this.getProperty("base.root", EMPTY_PROP_VALUE);
    }

    public final Value<String> getRootNameValue() {
        String res = this.getRootName();
        return res == null || EMPTY_PROP_VALUE.equals(res) ? Value.getNone() : Value.getSome(res);
    }

    private final boolean hasWANProperties(String wanAddr, String wanPort) {
        return wanAddr != null && wanPort != null;
    }

    protected SQLServer createServer() {
        RuntimeException origExn;
        Logger log;
        String serverID;
        List<String> serverAndPort;
        String wanPort;
        String wanAddr;
        block9: {
            wanAddr = this.getProperty("server.wan.addr");
            if (!this.hasWANProperties(wanAddr, wanPort = this.getProperty("server.wan.port"))) {
                return this.doCreateServer();
            }
            String serverPropVal = this.getProperty("server.ip");
            serverAndPort = Arrays.asList(serverPropVal.split(":"));
            if (serverAndPort.size() != 2) {
                throw new IllegalStateException("Not in 'host:port' format : " + serverPropVal);
            }
            serverID = "tunnel to " + wanAddr + ":" + wanPort + " then " + serverPropVal;
            log = Log.get();
            origExn = null;
            if (!"true".equals(this.getProperty("server.wan.only"))) {
                try {
                    SQLServer defaultServer = this.doCreateServer(serverID);
                    defaultServer.getSystemRoot(this.getSystemRootName());
                    log.config("using " + defaultServer);
                    return defaultServer;
                }
                catch (RuntimeException e) {
                    origExn = e;
                    log.config(e.getLocalizedMessage());
                    if ($assertionsDisabled || origExn != null) break block9;
                    throw new AssertionError();
                }
            }
        }
        this.openSSLConnection(wanAddr, Integer.valueOf(wanPort));
        this.isUsingSSH = true;
        log.info("ssl connection to " + this.conn.getHost() + ":" + this.conn.getPort());
        int localPort = NetUtils.findFreePort(5436);
        try {
            log.info("ssl tunnel from local port " + localPort + " to remote " + serverAndPort);
            this.conn.setPortForwardingL(localPort, serverAndPort.get(0), Integer.valueOf(serverAndPort.get(1)));
        }
        catch (Exception e1) {
            throw new IllegalStateException("Impossible de cr\u00e9er la liaison s\u00e9curis\u00e9e. V\u00e9rifier que le logiciel n'est pas d\u00e9j\u00e0 lanc\u00e9.", e1);
        }
        SQLServer serverThruSSL = this.doCreateServer("localhost:" + localPort, null, serverID);
        try {
            serverThruSSL.getSystemRoot(this.getSystemRootName());
        }
        catch (Exception e) {
            this.closeSSLConnection();
            throw new IllegalStateException("Couldn't connect through SSL : " + e.getLocalizedMessage(), origExn);
        }
        return serverThruSSL;
    }

    private SQLServer doCreateServer() {
        return this.doCreateServer(null);
    }

    private SQLServer doCreateServer(String id) {
        return this.doCreateServer(this.getProperty("server.ip"), null, id);
    }

    private SQLServer doCreateServer(String host, String port, String id) {
        SQLServer res = new SQLServer(this.getSystem(), host, port, this.getLogin(), this.getPassword(), (IClosure<? super DBSystemRoot>)new IClosure<DBSystemRoot>(){

            public void executeChecked(DBSystemRoot input) {
                input.setRootsToMap(PropsConfiguration.this.getRootsToMap());
                PropsConfiguration.this.initSystemRoot(input);
            }
        }, (IClosure<? super SQLDataSource>)new IClosure<SQLDataSource>(){

            public void executeChecked(SQLDataSource input) {
                PropsConfiguration.this.initDS(input);
            }
        });
        if (id != null) {
            res.setID(id);
        }
        return res;
    }

    private void openSSLConnection(String addr, int port) {
        this.checkDestroyed();
        String username = this.getSSLUserName();
        String pass = this.getSSLPassword();
        boolean isAuthenticated = false;
        JSch jsch = new JSch();
        try {
            if (pass == null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(700);
                String name = String.valueOf(username) + "_dsa";
                InputStream in = this.getClass().getResourceAsStream(name);
                if (in == null) {
                    throw new IllegalStateException("Missing private key " + this.getClass().getCanonicalName() + "/" + name);
                }
                StreamUtils.copy(in, out);
                in.close();
                jsch.addIdentity(username, out.toByteArray(), null, null);
            }
            this.conn = jsch.getSession(username, addr, port);
            if (pass != null) {
                this.conn.setPassword(pass);
            }
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            config.put("compression.s2c", "zlib@openssh.com,zlib,none");
            config.put("compression.c2s", "zlib@openssh.com,zlib,none");
            this.conn.setConfig(config);
            this.conn.connect(6000);
            this.afterSSLConnect(this.conn);
            isAuthenticated = true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Connection failed", e);
        }
        if (!isAuthenticated) {
            throw new IllegalStateException("Authentication failed.");
        }
    }

    protected void afterSSLConnect(Session conn) {
    }

    public String getSSLUserName() {
        return this.getProperty("server.wan.user");
    }

    protected String getSSLPassword() {
        return this.getProperty("server.wan.password");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSSLConnection() {
        Object object = this.treeLock;
        synchronized (object) {
            if (this.conn != null) {
                this.conn.disconnect();
                this.conn = null;
            }
        }
    }

    protected Collection<String> getRootsToMap() {
        String rootsToMap = this.getProperty("systemRoot.rootsToMap");
        if ("*".equals(rootsToMap)) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        Value<String> rootName = this.getRootNameValue();
        if (rootName.hasValue()) {
            res.add(rootName.getValue());
        }
        if (rootsToMap != null) {
            res.addAll(SQLRow.toList(rootsToMap));
        }
        return res;
    }

    protected List<String> getRootPath() {
        return new ArrayList<String>(SQLRow.toList(this.getProperty("systemRoot.rootPath", "")));
    }

    public String getSystemRootName() {
        return this.getProperty("systemRoot");
    }

    protected DBSystemRoot createSystemRoot() {
        DBSystemRoot res = this.getServer(false).getSystemRoot(this.getSystemRootName());
        this.setupSystemRoot(res, true);
        return res;
    }

    protected final void setupSystemRoot(DBSystemRoot res) {
        this.setupSystemRoot(res, false);
    }

    private void setupSystemRoot(DBSystemRoot res, boolean brandNew) {
        if (!brandNew) {
            res.unsetRootPath();
        }
        if (res.getChildrenNames().contains(this.getRootName())) {
            res.setDefaultRoot(this.getRootName());
        }
        for (String root : this.getRootPath()) {
            if (!res.getChildrenNames().contains(root)) continue;
            res.appendToRootPath(root);
        }
    }

    protected void initSystemRoot(DBSystemRoot input) {
    }

    protected void initDS(final SQLDataSource ds) {
        ds.setCacheEnabled(true);
        String appID = this.getAppID();
        if (appID != null) {
            ds.addConnectionProperty("ApplicationName", appID);
        }
        this.propIterate(new IClosure<String>(){

            public void executeChecked(String propName) {
                String jdbcName = propName.substring("jdbc.connection.".length());
                ds.addConnectionProperty(jdbcName, PropsConfiguration.this.getProperty(propName));
            }
        }, "jdbc.connection.");
    }

    public final void propIterate(IClosure<String> cl, final String startsWith) {
        this.propIterate(cl, (IPredicate<? super String>)new IPredicate<String>(){

            public boolean evaluateChecked(String propName) {
                return propName.startsWith(startsWith);
            }
        });
    }

    public final void propIterate(IClosure<String> cl, IPredicate<? super String> filter) {
        for (String propName : this.props.stringPropertyNames()) {
            if (!filter.evaluateChecked(propName)) continue;
            cl.executeChecked(propName);
        }
    }

    public final void setLoggersLevel() {
        this.propIterate(new IClosure<String>(){

            public void executeChecked(String propName) {
                String logName = propName.substring("log.level.".length());
                LogUtils.getLogger(logName).setLevel(Level.parse(PropsConfiguration.this.getProperty(propName)));
            }
        }, "log.level.");
    }

    public void setupLogging() {
        this.setupLogging("logs");
    }

    public final void setupLogging(String dirName) {
        this.setupLogging(dirName, this.getStandardStreamsDestination());
    }

    protected final StandardStreamsDest getStandardStreamsDestination() {
        String propVal = System.getProperty("stdStreamsDest");
        if (propVal == null) {
            propVal = this.getProperty("stdStreamsDest");
        }
        StandardStreamsDest res = propVal != null ? StandardStreamsDest.valueOf(propVal) : this.getStandardStreamsDestinationDefault();
        return res;
    }

    protected StandardStreamsDest getStandardStreamsDestinationDefault() {
        return Boolean.getBoolean("redirectToFile") ? StandardStreamsDest.ALSO_TO_FILE : StandardStreamsDest.DEFAULT;
    }

    protected DateFormat getLogDateFormat() {
        return DATE_FORMAT;
    }

    private final File getValidLogDir(String dirName) {
        File logDir;
        try {
            File softLogDir = new File(this.getWD() + "/" + dirName + "/" + PropsConfiguration.getHostname() + "-" + System.getProperty("user.name"));
            softLogDir.mkdirs();
            if (softLogDir.canWrite()) {
                logDir = softLogDir;
            } else {
                File homeLogDir = new File(String.valueOf(System.getProperty("user.home")) + "/." + this.getAppName() + "/" + dirName);
                FileUtils.mkdir_p(homeLogDir);
                if (homeLogDir.canWrite()) {
                    logDir = homeLogDir;
                } else {
                    throw new IOException("Home log directory not writeable : " + homeLogDir);
                }
            }
            assert (logDir.exists() && logDir.canWrite());
            System.out.println("Log directory: " + logDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to create log dir", e);
        }
        return logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupLogging(String dirName, StandardStreamsDest stdRedirect) {
        File logFile;
        File logDir;
        Object object = this.restLock;
        synchronized (object) {
            if (this.logDir != null) {
                throw new IllegalStateException("Already set to " + this.logDir);
            }
            this.logDir = logDir = this.getValidLogDir(dirName);
        }
        String logNameBase = String.valueOf(this.getAppName()) + "_" + this.getLogDateFormat().format(new Date());
        if (stdRedirect != StandardStreamsDest.DEFAULT) {
            logFile = new File(logDir, String.valueOf(logNameBase) + ".txt");
            try {
                OutputStream err;
                OutputStream out;
                FileUtils.mkdir_p(logFile.getParentFile());
                System.out.println("Standard output and error file: " + logFile.getAbsolutePath());
                FileOutputStream fileOut = new FileOutputStream(logFile, true);
                if (this.isInIDE() || stdRedirect != StandardStreamsDest.ONLY_TO_FILE) {
                    System.out.println("Redirecting standard output to file and console");
                    out = new MultipleOutputStream(fileOut, System.out);
                    System.out.println("Redirecting error output to file and console");
                    err = new MultipleOutputStream(fileOut, System.err);
                } else {
                    System.out.println("Redirecting standard output to file");
                    out = fileOut;
                    System.out.println("Redirecting error output to file");
                    err = fileOut;
                }
                System.setErr(new PrintStream(new BufferedOutputStream(err, 128), true));
                System.setOut(new PrintStream(new BufferedOutputStream(out, 128), true));
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileUtils.ln(logFile, new File(logDir, "last.log"));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                throw new IllegalStateException("Redirection des sorties standards impossible", e);
            }
        } else {
            System.out.println("Standard streams not redirected to file");
        }
        LogUtils.rmRootHandlers();
        LogUtils.setUpConsoleHandler();
        try {
            logFile = new File(logDir, String.valueOf(this.getAppName()) + "-%u-age%g.log");
            FileUtils.mkdir_p(logFile.getParentFile());
            System.out.println("Logger logs: " + logFile.getAbsolutePath());
            FileHandler fh = new FileHandler(logFile.getPath(), 0x500000, 2, true);
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fh);
        }
        catch (Exception e) {
            throw new IllegalStateException("Enregistrement du Logger d\u00e9sactiv\u00e9", e);
        }
        this.setLoggersLevel();
    }

    public void tearDownLogging(boolean redirectToFile) {
        LogUtils.rmRootHandlers();
        if (redirectToFile) {
            System.out.close();
            System.err.close();
        }
    }

    protected File createWD() {
        return new File(this.getProperty("wd"));
    }

    protected BaseDirs createBaseDirs() {
        return BaseDirs.create(this.getProductInfo(), this.getAppVariant());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBRoot getRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.root == null) {
                this.setRoot(this.createRoot());
            }
            return this.root;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DBSystemRoot getSystemRoot() {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.sysRoot == null) {
                this.sysRoot = this.createSystemRoot();
            }
            return this.sysRoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SQLServer getServer(boolean initSysRoot) {
        Object object = this.treeLock;
        synchronized (object) {
            this.checkDestroyed();
            if (this.server == null) {
                this.setServer(this.createServer());
                if (initSysRoot && this.server.getSQLSystem().getLevel(DBSystemRoot.class) == HierarchyLevel.SQLSERVER) {
                    this.getSystemRoot();
                }
            }
            return this.server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ProductInfo getProductInfo() {
        Object object = this.restLock;
        synchronized (object) {
            return this.productInfo;
        }
    }

    @Override
    public final String getAppName() {
        ProductInfo productInfo = this.getProductInfo();
        if (productInfo != null) {
            return productInfo.getName();
        }
        return this.getProperty("app.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final File getWD() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.wd == null) {
                this.setWD(this.createWD());
            }
            return this.wd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseDirs getBaseDirs() {
        Object object = this.restLock;
        synchronized (object) {
            if (this.baseDirs == null) {
                this.baseDirs = this.createBaseDirs();
            }
            return this.baseDirs;
        }
    }

    private final void setFilter(SQLFilter filter) {
        this.filter = filter;
    }

    private void setServer(SQLServer server) {
        this.server = server;
    }

    private final void setRoot(DBRoot root) {
        this.root = root;
        this.checkDestroyed();
        this.urMngr = this.createUserRightsManager(root);
        this.uMngr = UserManager.getSingletonManager().setInstanceIfNone(root);
    }

    private final void setWD(File dir) {
        this.wd = dir;
    }

    private abstract class Addable<T> {
        private boolean destroyed;
        private final List<Configuration> toAdd;
        private Future<T> f;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Addable() {
            Addable addable = this;
            synchronized (addable) {
                this.toAdd = new ArrayList<Configuration>();
                this.f = null;
                this.destroyed = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void destroy() {
            Future<T> future;
            Addable addable = this;
            synchronized (addable) {
                this.destroyed = true;
                future = this.f;
            }
            if (future != null) {
                this.destroy(future);
            }
        }

        protected void destroy(Future<T> future) {
        }
    }

    protected static enum FileMode {
        IN_JAR,
        NORMAL_FILE;

    }

    public static enum StandardStreamsDest {
        DEFAULT(true),
        ONLY_TO_FILE(false),
        ALSO_TO_FILE(true);

        private final boolean hasDefaultStreams;

        private StandardStreamsDest(boolean hasDefaultStreams) {
            this.hasDefaultStreams = hasDefaultStreams;
        }
    }
}

