/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.io;

import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import org.openconcerto.erp.core.sales.pos.io.AbstractESCPrinter;

public class ESCStandardPrinter
extends AbstractESCPrinter {
    private String printerName;

    public ESCStandardPrinter(String printerName) {
        if (printerName.isEmpty() || printerName.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing printer name");
        }
        this.printerName = printerName;
    }

    @Override
    public void printBuffer() throws Exception {
        this.sendBytes(this.getPrintBufferBytes());
    }

    private synchronized void sendBytes(byte[] b) throws PrintException {
        HashPrintServiceAttributeSet attrSet = new HashPrintServiceAttributeSet(new PrinterName(this.printerName, null));
        PrintService[] lookupPrintServices = PrintServiceLookup.lookupPrintServices(null, attrSet);
        if (lookupPrintServices.length <= 0) {
            throw new PrintException("Printer " + this.printerName + " not found");
        }
        DocPrintJob job = lookupPrintServices[0].createPrintJob();
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        SimpleDoc doc = new SimpleDoc(b, flavor, null);
        job.print(doc, null);
    }
}

