/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.report;

import java.util.HashMap;
import java.util.Map;
import org.openconcerto.utils.i18n.TranslationManager;

public enum LignePayeSimplifiee {
    SANTE_SECURITE("sante.securite"),
    SANTE_COMPLEMENAIRE_DECES("sante.complementaire.deces"),
    SANTE_COMPLEMENAIRE_SANTE("sante.complementaire.sante"),
    ACCIDENTS_TRAVAIL("accident.accident"),
    RETRAITE_SECURITE_PLAF("retraite.securite.plaf"),
    RETRAITE_SECURITE_NON_PLAF("retraite.securite.non.plaf"),
    RETRAITE_COMPLEMENTAIRE_T1("retraite.tranche1"),
    RETRAITE_COMPLEMENTAIRE_T2("retraite.tranche2"),
    RETRAITE_COMPLEMENTAIRE_TA("retraite.trancheA"),
    RETRAITE_COMPLEMENTAIRE_GMP("retraite.GMP"),
    RETRAITE_COMPLEMENTAIRE_TB("retraite.trancheB"),
    RETRAITE_COMPLEMENTAIRE_TC("retraite.trancheC"),
    RETRAITE_SUPPLEMENTAIRE("retraite.supplementaire"),
    FAMILLE_ALLOCATIONS("famille.famille.allocations"),
    ASSURANCE_CHOMAGE_CHOMAGE("chomage.chomage"),
    ASSURANCE_CHOMAGE_APEC("chomage.apec"),
    COTISATIONS_STATUAIRES("cotisations.statuaires.ligne"),
    AUTRES_CONTRIBUTIONS("autres.contributions.ligne"),
    CSG_NON_IMP("csg.nonimp.ligne"),
    CSG_IMP("csg.imp.ligne"),
    ALLEGEMENT_COTISATIONS("allegement.cotisations.ligne"),
    IGNORE("paye.simplifie.ignore");

    private final String id;
    private static final Map<String, LignePayeSimplifiee> idToEnum;

    static {
        idToEnum = new HashMap<String, LignePayeSimplifiee>();
        LignePayeSimplifiee[] lignePayeSimplifieeArray = LignePayeSimplifiee.values();
        int n = lignePayeSimplifieeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LignePayeSimplifiee e = lignePayeSimplifieeArray[n2];
            idToEnum.put(e.getId(), e);
            ++n2;
        }
    }

    private LignePayeSimplifiee(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslation() {
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.getId());
        return translationForItem == null || translationForItem.trim().length() == 0 ? this.getId() : translationForItem;
    }

    public String toString() {
        return this.getTranslation();
    }
}

