/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeLeaf;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;
import org.h2.util.Utils;

public class PageBtreeNode
extends PageBtree {
    private final boolean pageStoreInternalCount;
    private int[] childPageIds;
    private int rowCountStored = -1;
    private int rowCount = -1;

    private PageBtreeNode(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        super(pageBtreeIndex, n, data);
        this.pageStoreInternalCount = pageBtreeIndex.getDatabase().getSettings().pageStoreInternalCount;
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n, data);
        pageBtreeNode.read();
        return pageBtreeNode;
    }

    static PageBtreeNode create(PageBtreeIndex pageBtreeIndex, int n, int n2) {
        PageBtreeNode pageBtreeNode = new PageBtreeNode(pageBtreeIndex, n, pageBtreeIndex.getPageStore().createData());
        pageBtreeIndex.getPageStore().logUndo(pageBtreeNode, null);
        pageBtreeNode.parentPageId = n2;
        pageBtreeNode.writeHead();
        pageBtreeNode.start = pageBtreeNode.data.length() + 4;
        pageBtreeNode.rows = SearchRow.EMPTY_ARRAY;
        if (pageBtreeNode.pageStoreInternalCount) {
            pageBtreeNode.rowCount = 0;
        }
        return pageBtreeNode;
    }

    private void read() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (by & 0x10) == 0;
        int n = this.data.readVarInt();
        if (n != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n);
        }
        this.rowCount = this.rowCountStored = this.data.readInt();
        this.entryCount = this.data.readShortInt();
        this.childPageIds = new int[this.entryCount + 1];
        this.childPageIds[this.entryCount] = this.data.readInt();
        this.rows = this.entryCount == 0 ? SearchRow.EMPTY_ARRAY : new SearchRow[this.entryCount];
        this.offsets = Utils.newIntArray(this.entryCount);
        for (int i = 0; i < this.entryCount; ++i) {
            this.childPageIds[i] = this.data.readInt();
            this.offsets[i] = this.data.readShortInt();
        }
        this.check();
        this.start = this.data.length();
        this.written = true;
    }

    private int addChildTry(SearchRow searchRow) {
        int n;
        if (this.entryCount < 4) {
            return -1;
        }
        if (this.onlyPosition) {
            n = this.entryCount + 10;
        } else {
            int n2 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
            int n3 = this.index.getPageStore().getPageSize();
            int n4 = this.entryCount == 0 ? n3 : this.offsets[this.entryCount - 1];
            n = n4 - n2;
        }
        if (n < this.start + 6) {
            return this.entryCount / 2;
        }
        return -1;
    }

    private void addChild(int n, int n2, SearchRow searchRow) {
        int n3;
        int n4;
        int n5 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n6 = this.index.getPageStore().getPageSize();
        int n7 = n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
        if (n4 - n5 < this.start + 6) {
            this.readAllRows();
            this.onlyPosition = true;
            n3 = n6;
            for (int i = 0; i < this.entryCount; ++i) {
                this.offsets[i] = n3 -= this.index.getRowSize(this.data, this.getRow(i), true);
            }
            n4 = this.entryCount == 0 ? n6 : this.offsets[this.entryCount - 1];
            n5 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n4 - n5 < this.start + 6) {
                throw DbException.throwInternalError();
            }
        }
        n3 = n4 - n5;
        if (this.entryCount > 0 && n < this.entryCount) {
            n3 = (n == 0 ? n6 : this.offsets[n - 1]) - n5;
        }
        this.rows = PageBtreeNode.insert(this.rows, this.entryCount, n, searchRow);
        this.offsets = PageBtreeNode.insert(this.offsets, this.entryCount, n, n3);
        PageBtreeNode.add(this.offsets, n + 1, this.entryCount + 1, -n5);
        this.childPageIds = PageBtreeNode.insert(this.childPageIds, this.entryCount + 1, n + 1, n2);
        this.start += 6;
        if (this.pageStoreInternalCount && this.rowCount != -1) {
            this.rowCount += n3;
        }
        ++this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
    }

    @Override
    int addRowTry(SearchRow searchRow) {
        int n;
        PageBtree pageBtree;
        int n2;
        while ((n2 = (pageBtree = this.index.getPage(this.childPageIds[n = this.find(searchRow, false, true, true)])).addRowTry(searchRow)) != -1) {
            SearchRow searchRow2 = pageBtree.getRow(n2 - 1);
            this.index.getPageStore().logUndo(this, this.data);
            int n3 = this.addChildTry(searchRow2);
            if (n3 != -1) {
                return n3;
            }
            PageBtree pageBtree2 = pageBtree.split(n2);
            this.readAllRows();
            this.addChild(n, pageBtree2.getPos(), searchRow2);
            this.index.getPageStore().update(pageBtree);
            this.index.getPageStore().update(pageBtree2);
            this.index.getPageStore().update(this);
        }
        this.updateRowCount(1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        return -1;
    }

    private void updateRowCount(int n) {
        if (this.rowCount != -1) {
            this.rowCount += n;
        }
        if (this.rowCountStored != -1) {
            this.rowCountStored = -1;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    @Override
    PageBtree split(int n) {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n2, this.parentPageId);
        this.index.getPageStore().logUndo(this, this.data);
        if (this.onlyPosition) {
            pageBtreeNode.onlyPosition = true;
        }
        int n3 = this.childPageIds[n];
        this.readAllRows();
        int n4 = n;
        while (n4 < this.entryCount) {
            pageBtreeNode.addChild(pageBtreeNode.entryCount, this.childPageIds[n + 1], this.getRow(n));
            this.removeChild(n);
        }
        n4 = this.childPageIds[n - 1];
        this.removeChild(n - 1);
        this.childPageIds[n - 1] = n4;
        if (pageBtreeNode.childPageIds == null) {
            pageBtreeNode.childPageIds = new int[1];
        }
        pageBtreeNode.childPageIds[0] = n3;
        pageBtreeNode.remapChildren();
        return pageBtreeNode;
    }

    @Override
    protected void remapChildren() {
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n = this.childPageIds[i];
            PageBtree pageBtree = this.index.getPage(n);
            pageBtree.setParentPageId(this.getPos());
            this.index.getPageStore().update(pageBtree);
        }
    }

    void init(PageBtree pageBtree, SearchRow searchRow, PageBtree pageBtree2) {
        this.entryCount = 0;
        this.childPageIds = new int[]{pageBtree.getPos()};
        this.rows = SearchRow.EMPTY_ARRAY;
        this.offsets = Utils.EMPTY_INT_ARRAY;
        this.addChild(0, pageBtree2.getPos(), searchRow);
        if (this.pageStoreInternalCount) {
            this.rowCount = pageBtree.getRowCount() + pageBtree2.getRowCount();
        }
        this.check();
    }

    @Override
    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) {
        int n = this.find(searchRow, bl, false, false);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
    }

    @Override
    void last(PageBtreeCursor pageBtreeCursor) {
        int n = this.childPageIds[this.entryCount];
        this.index.getPage(n).last(pageBtreeCursor);
    }

    @Override
    PageBtreeLeaf getFirstLeaf() {
        int n = this.childPageIds[0];
        return this.index.getPage(n).getFirstLeaf();
    }

    @Override
    PageBtreeLeaf getLastLeaf() {
        int n = this.childPageIds[this.entryCount];
        return this.index.getPage(n).getLastLeaf();
    }

    @Override
    SearchRow remove(SearchRow searchRow) {
        int n = this.find(searchRow, false, false, true);
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n]);
        SearchRow searchRow2 = pageBtree.remove(searchRow);
        this.index.getPageStore().logUndo(this, this.data);
        this.updateRowCount(-1);
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (searchRow2 == null) {
            return null;
        }
        if (searchRow2 == searchRow) {
            this.index.getPageStore().free(pageBtree.getPos());
            if (this.entryCount < 1) {
                return searchRow;
            }
            searchRow2 = n == this.entryCount ? this.getRow(n - 1) : null;
            this.removeChild(n);
            this.index.getPageStore().update(this);
            return searchRow2;
        }
        if (n == this.entryCount) {
            return searchRow2;
        }
        int n2 = this.childPageIds[n];
        this.removeChild(n);
        this.addChild(n, n2, searchRow2);
        int n3 = this.childPageIds[n];
        this.childPageIds[n] = this.childPageIds[n + 1];
        this.childPageIds[n + 1] = n3;
        this.index.getPageStore().update(this);
        return null;
    }

    @Override
    int getRowCount() {
        if (this.rowCount == -1) {
            int n = 0;
            for (int i = 0; i < this.entryCount + 1; ++i) {
                int n2 = this.childPageIds[i];
                PageBtree pageBtree = this.index.getPage(n2);
                this.index.getDatabase().setProgress(0, this.index.getName(), n += pageBtree.getRowCount(), Integer.MAX_VALUE);
            }
            this.rowCount = n;
        }
        return this.rowCount;
    }

    @Override
    void setRowCountStored(int n) {
        if (n < 0 && this.pageStoreInternalCount) {
            return;
        }
        this.rowCount = n;
        if (this.rowCountStored != n) {
            this.rowCountStored = n;
            this.index.getPageStore().logUndo(this, this.data);
            if (this.written) {
                this.changeCount = this.index.getPageStore().getChangeCount();
                this.writeHead();
            }
            this.index.getPageStore().update(this);
        }
    }

    private void check() {
        if (SysProperties.CHECK) {
            for (int i = 0; i < this.entryCount + 1; ++i) {
                int n = this.childPageIds[i];
                if (n != 0) continue;
                DbException.throwInternalError();
            }
        }
    }

    @Override
    public void write() {
        this.check();
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)(5 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeInt(this.rowCountStored);
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n;
        if (this.written) {
            return;
        }
        this.readAllRows();
        this.writeHead();
        this.data.writeInt(this.childPageIds[this.entryCount]);
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeInt(this.childPageIds[n]);
            this.data.writeShortInt(this.offsets[n]);
        }
        for (n = 0; n < this.entryCount; ++n) {
            this.index.writeRow(this.data, this.offsets[n], this.rows[n], this.onlyPosition);
        }
        this.written = true;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n = this.childPageIds[i];
            this.index.getPage(n).freeRecursive();
        }
    }

    private void removeChild(int n) {
        this.readAllRows();
        --this.entryCount;
        if (this.pageStoreInternalCount) {
            this.updateRowCount(-this.index.getPage(this.childPageIds[n]).getRowCount());
        }
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount < 0) {
            DbException.throwInternalError();
        }
        if (this.entryCount > n) {
            int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
            int n3 = n2 - this.offsets[n];
            PageBtreeNode.add(this.offsets, n, this.entryCount + 1, n3);
        }
        this.rows = PageBtreeNode.remove(this.rows, this.entryCount + 1, n);
        this.offsets = PageBtreeNode.remove(this.offsets, this.entryCount + 1, n);
        this.childPageIds = PageBtreeNode.remove(this.childPageIds, this.entryCount + 2, n);
        this.start -= 6;
    }

    void nextPage(PageBtreeCursor pageBtreeCursor, int n) {
        int n2;
        for (n2 = 0; n2 < this.entryCount + 1; ++n2) {
            if (this.childPageIds[n2] != n) continue;
            ++n2;
            break;
        }
        if (n2 > this.entryCount) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getFirstLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, 0);
    }

    void previousPage(PageBtreeCursor pageBtreeCursor, int n) {
        int n2;
        for (n2 = this.entryCount; n2 >= 0; --n2) {
            if (this.childPageIds[n2] != n) continue;
            --n2;
            break;
        }
        if (n2 < 0) {
            if (this.parentPageId == 0) {
                pageBtreeCursor.setCurrent(null, 0);
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
            return;
        }
        PageBtree pageBtree = this.index.getPage(this.childPageIds[n2]);
        PageBtreeLeaf pageBtreeLeaf = pageBtree.getLastLeaf();
        pageBtreeCursor.setCurrent(pageBtreeLeaf, pageBtreeLeaf.entryCount - 1);
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree node table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    @Override
    public void moveTo(Session session, int n) {
        PageStore pageStore = this.index.getPageStore();
        pageStore.logUndo(this, this.data);
        PageBtreeNode pageBtreeNode = PageBtreeNode.create(this.index, n, this.parentPageId);
        this.readAllRows();
        pageBtreeNode.rowCountStored = this.rowCountStored;
        pageBtreeNode.rowCount = this.rowCount;
        pageBtreeNode.childPageIds = this.childPageIds;
        pageBtreeNode.rows = this.rows;
        pageBtreeNode.entryCount = this.entryCount;
        pageBtreeNode.offsets = this.offsets;
        pageBtreeNode.onlyPosition = this.onlyPosition;
        pageBtreeNode.parentPageId = this.parentPageId;
        pageBtreeNode.start = this.start;
        pageStore.update(pageBtreeNode);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            Page page = pageStore.getPage(this.parentPageId);
            if (!(page instanceof PageBtreeNode)) {
                throw DbException.throwInternalError();
            }
            PageBtreeNode pageBtreeNode2 = (PageBtreeNode)page;
            pageBtreeNode2.moveChild(this.getPos(), n);
        }
        for (int i = 0; i < this.entryCount + 1; ++i) {
            int n2 = this.childPageIds[i];
            PageBtree pageBtree = this.index.getPage(n2);
            pageBtree.setParentPageId(n);
            pageStore.update(pageBtree);
        }
        pageStore.free(this.getPos());
    }

    void moveChild(int n, int n2) {
        for (int i = 0; i < this.entryCount + 1; ++i) {
            if (this.childPageIds[i] != n) continue;
            this.index.getPageStore().logUndo(this, this.data);
            this.written = false;
            this.changeCount = this.index.getPageStore().getChangeCount();
            this.childPageIds[i] = n2;
            this.index.getPageStore().update(this);
            return;
        }
        throw DbException.throwInternalError();
    }
}

