/*
 * Decompiled with CFR 0.152.
 */
package org.h2.compress;

import org.h2.compress.Compressor;

public final class CompressLZF
implements Compressor {
    private int[] cachedHashTable;

    @Override
    public void setOptions(String string) {
    }

    private static int first(byte[] byArray, int n) {
        return byArray[n] << 8 | byArray[n + 1] & 0xFF;
    }

    private static int next(int n, byte[] byArray, int n2) {
        return n << 8 | byArray[n2 + 2] & 0xFF;
    }

    private static int hash(int n) {
        return n * 2777 >> 9 & 0x3FFF;
    }

    @Override
    public int compress(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = 0;
        if (this.cachedHashTable == null) {
            this.cachedHashTable = new int[16384];
        }
        int[] nArray = this.cachedHashTable;
        int n4 = 0;
        ++n2;
        int n5 = CompressLZF.first(byArray, 0);
        while (n3 < n - 4) {
            byte by = byArray[n3 + 2];
            n5 = (n5 << 8) + (by & 0xFF);
            int n6 = CompressLZF.hash(n5);
            int n7 = nArray[n6];
            nArray[n6] = n3;
            if (n7 < n3 && n7 > 0 && (n6 = n3 - n7 - 1) < 8192 && byArray[n7 + 2] == by && byArray[n7 + 1] == (byte)(n5 >> 8) && byArray[n7] == (byte)(n5 >> 16)) {
                int n8;
                int n9 = n - n3 - 2;
                if (n9 > 264) {
                    n9 = 264;
                }
                if (n4 == 0) {
                    --n2;
                } else {
                    byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
                    n4 = 0;
                }
                for (n8 = 3; n8 < n9 && byArray[n7 + n8] == byArray[n3 + n8]; ++n8) {
                }
                if ((n8 -= 2) < 7) {
                    byArray2[n2++] = (byte)((n6 >> 8) + (n8 << 5));
                } else {
                    byArray2[n2++] = (byte)((n6 >> 8) + 224);
                    byArray2[n2++] = (byte)(n8 - 7);
                }
                byArray2[n2++] = (byte)n6;
                ++n2;
                n5 = CompressLZF.first(byArray, n3 += n8);
                n5 = CompressLZF.next(n5, byArray, n3);
                nArray[CompressLZF.hash((int)n5)] = n3++;
                n5 = CompressLZF.next(n5, byArray, n3);
                nArray[CompressLZF.hash((int)n5)] = n3++;
                continue;
            }
            byArray2[n2++] = byArray[n3++];
            if (++n4 != 32) continue;
            byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n2;
        }
        while (n3 < n) {
            byArray2[n2++] = byArray[n3++];
            if (++n4 != 32) continue;
            byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
            n4 = 0;
            ++n2;
        }
        byArray2[n2 - n4 - 1] = (byte)(n4 - 1);
        if (n4 == 0) {
            --n2;
        }
        return n2;
    }

    @Override
    public void expand(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException();
        }
        do {
            int n5;
            if ((n5 = byArray[n++] & 0xFF) < 32) {
                System.arraycopy(byArray, n, byArray2, n3, ++n5);
                n3 += n5;
                n += n5;
                continue;
            }
            int n6 = n5 >> 5;
            if (n6 == 7) {
                n6 += byArray[n++] & 0xFF;
            }
            n5 = -((n5 & 0x1F) << 8) - 1;
            n5 -= byArray[n++] & 0xFF;
            n5 += n3;
            if (n3 + (n6 += 2) >= byArray2.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < n6; ++i) {
                byArray2[n3++] = byArray2[n5++];
            }
        } while (n3 < n4);
    }

    @Override
    public int getAlgorithm() {
        return 1;
    }
}

