/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.dbcp.AbandonedConfig;

public class AbandonedTrace {
    private final AbandonedConfig config;
    private volatile Exception createdBy;
    private final List traceList = new ArrayList();
    private volatile long lastUsed = 0L;

    public AbandonedTrace() {
        this.config = null;
        this.init(null);
    }

    public AbandonedTrace(AbandonedConfig config) {
        this.config = config;
        this.init(null);
    }

    public AbandonedTrace(AbandonedTrace parent) {
        this.config = parent.getConfig();
        this.init(parent);
    }

    private void init(AbandonedTrace parent) {
        if (parent != null) {
            parent.addTrace(this);
        }
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new AbandonedObjectException();
        }
    }

    protected AbandonedConfig getConfig() {
        return this.config;
    }

    protected long getLastUsed() {
        return this.lastUsed;
    }

    protected void setLastUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    protected void setLastUsed(long time) {
        this.lastUsed = time;
    }

    protected void setStackTrace() {
        if (this.config == null) {
            return;
        }
        if (this.config.getLogAbandoned()) {
            this.createdBy = new AbandonedObjectException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTrace(AbandonedTrace trace) {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.add(trace);
        }
        this.setLastUsed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTrace() {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getTrace() {
        List list = this.traceList;
        synchronized (list) {
            return new ArrayList(this.traceList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        if (this.createdBy != null && this.config != null) {
            this.createdBy.printStackTrace(this.config.getLogWriter());
        }
        List list = this.traceList;
        synchronized (list) {
            for (AbandonedTrace at : this.traceList) {
                at.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTrace(AbandonedTrace trace) {
        List list = this.traceList;
        synchronized (list) {
            this.traceList.remove(trace);
        }
    }

    static class AbandonedObjectException
    extends Exception {
        private static final SimpleDateFormat format = new SimpleDateFormat("'DBCP object created' yyyy-MM-dd HH:mm:ss 'by the following code was never closed:'");
        private final long _createdTime = System.currentTimeMillis();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            String msg;
            SimpleDateFormat simpleDateFormat = format;
            synchronized (simpleDateFormat) {
                msg = format.format(new Date(this._createdTime));
            }
            return msg;
        }
    }
}

