/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.collection.UnmodifiableCollection;

public class CollectionUtils {
    private static Integer INTEGER_ONE = new Integer(1);
    public static final Collection EMPTY_COLLECTION = UnmodifiableCollection.decorate(new ArrayList());

    public static Collection intersection(Collection a, Collection b) {
        ArrayList list = new ArrayList();
        Map mapa = CollectionUtils.getCardinalityMap(a);
        Map mapb = CollectionUtils.getCardinalityMap(b);
        HashSet elts = new HashSet(a);
        elts.addAll(b);
        Iterator it = elts.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int m = Math.min(CollectionUtils.getFreq(obj, mapa), CollectionUtils.getFreq(obj, mapb));
            for (int i = 0; i < m; ++i) {
                list.add(obj);
            }
        }
        return list;
    }

    public static Collection subtract(Collection a, Collection b) {
        ArrayList list = new ArrayList(a);
        Iterator it = b.iterator();
        while (it.hasNext()) {
            list.remove(it.next());
        }
        return list;
    }

    public static Map getCardinalityMap(Collection coll) {
        HashMap count = new HashMap();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Integer c = (Integer)count.get(obj);
            if (c == null) {
                count.put(obj, INTEGER_ONE);
                continue;
            }
            count.put(obj, new Integer(c + 1));
        }
        return count;
    }

    private static final int getFreq(Object obj, Map freqMap) {
        Integer count = (Integer)freqMap.get(obj);
        if (count != null) {
            return count;
        }
        return 0;
    }
}

