/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

public class EncodingGuesser {
    private static Logger log = Logger.getLogger(EncodingGuesser.class.getName());
    private static String defaultJVMEncoding = Charset.forName(new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding()).name();
    private static Collection supportedEncodings = new TreeSet();
    private static Map boms = new HashMap();

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -2;
        byArray[3] = -1;
        boms.put("UTF-32BE", byArray);
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -2;
        boms.put("UTF-32LE", byArray2);
        boms.put("UTF-16BE", new byte[]{-2, -1});
        boms.put("UTF-16LE", new byte[]{-1, -2});
        boms.put("UTF-8", new byte[]{-17, -69, -65});
        boms.put("UTF-7", new byte[]{43, 47, 118});
        boms.put("UTF-1", new byte[]{-9, 100, 76});
        boms.put("UTF-EBCDIC", new byte[]{-35, 115, 102, 115});
        boms.put("SCSU", new byte[]{14, -2, -1});
        boms.put("BOCU-1", new byte[]{-5, -18, 40});
    }

    public static Collection getValidEncodings(String[] encodings) {
        ArrayList<String> c = new ArrayList<String>();
        int i = 0;
        while (i < encodings.length) {
            if (supportedEncodings.contains(encodings[i])) {
                c.add(encodings[i]);
            }
            ++i;
        }
        return c;
    }
}

