/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.detector.MimeDetector;
import eu.medsea.util.EncodingGuesser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public final class TextMimeDetector
extends MimeDetector {
    private static Logger log = Logger.getLogger(TextMimeDetector.class.getName());
    private static Collection preferredEncodings = new ArrayList();
    private static Collection handlers;

    static {
        TextMimeDetector.setPreferredEncodings(new String[]{"UTF-16", "UTF-8", "ISO-8859-1", "windows-1252", "US-ASCII"});
        handlers = new ArrayList();
    }

    private TextMimeDetector() {
    }

    TextMimeDetector(int dummy) {
        this();
    }

    @Override
    public String getDescription() {
        return "Determine if a file or stream contains a text mime type. If so then return TextMimeType with text/plain and the best guess encoding.";
    }

    public static void setPreferredEncodings(String[] encodings) {
        preferredEncodings = EncodingGuesser.getValidEncodings(encodings);
        log.finest("Preferred Encodings set to " + preferredEncodings);
    }
}

