/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.MimeException;
import java.io.Serializable;
import java.util.regex.Pattern;

public class MimeType
implements Serializable,
Comparable {
    private static final Pattern mimeSplitter = Pattern.compile("[/;]++");
    protected String mediaType = "*";
    protected String subType = "*";
    private int specificity = 1;

    public MimeType(String mimeType) throws MimeException {
        if (mimeType == null || mimeType.trim().length() == 0) {
            throw new MimeException("Invalid MimeType [" + mimeType + "]");
        }
        String[] parts = mimeSplitter.split(mimeType.trim());
        if (parts.length > 0) {
            this.mediaType = this.getValidMediaType(parts[0]);
        }
        if (parts.length > 1) {
            this.subType = this.getValidSubType(parts[1]);
        }
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getSubType() {
        return this.subType;
    }

    private boolean match(String mimeType) {
        return this.toString().equals(mimeType);
    }

    public int hashCode() {
        return 31 * this.mediaType.hashCode() + this.subType.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MimeType) {
            if (this.mediaType.equals(((MimeType)o).mediaType) && this.subType.equals(((MimeType)o).subType)) {
                return true;
            }
        } else if (o instanceof String) {
            return this.match((String)o);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.mediaType) + "/" + this.subType;
    }

    private String getValidMediaType(String mediaType) {
        if (mediaType == null || mediaType.trim().length() == 0) {
            return "*";
        }
        return mediaType;
    }

    private String getValidSubType(String subType) {
        if (subType == null || subType.trim().length() == 0 || "*".equals(this.mediaType)) {
            return "*";
        }
        return subType;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof MimeType) {
            return this.toString().compareTo(((MimeType)arg0).toString());
        }
        return 0;
    }
}

