/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil;

import eu.medsea.mimeutil.TextMimeDetector;
import eu.medsea.mimeutil.detector.MimeDetector;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

class MimeDetectorRegistry {
    private static Logger log = Logger.getLogger(MimeDetectorRegistry.class.getName());
    private TextMimeDetector TextMimeDetector = new TextMimeDetector(1);
    private Map mimeDetectors = new TreeMap();

    MimeDetectorRegistry() {
    }

    MimeDetector registerMimeDetector(String mimeDetector) {
        if (this.mimeDetectors.containsKey(mimeDetector)) {
            log.warning("MimeDetector [" + mimeDetector + "] will not be registered as a MimeDetector with this name is already registered.");
            return (MimeDetector)this.mimeDetectors.get(mimeDetector);
        }
        try {
            MimeDetector md = (MimeDetector)Class.forName(mimeDetector).newInstance();
            md.init();
            log.finest("Registering MimeDetector with name [" + md.getName() + "] and description [" + md.getDescription() + "]");
            this.mimeDetectors.put(mimeDetector, md);
            return md;
        }
        catch (Exception e) {
            log.severe("Exception while registering MimeDetector [" + mimeDetector + "].");
            return null;
        }
    }
}

