/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.impl.Pair;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.TimeUnit;
import com.ibm.icu.util.UResourceBundle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;

public class MeasureUnit
implements Serializable {
    private static final String[] unitKeys = new String[]{"units", "unitsShort", "unitsNarrow"};
    private static final Map<String, Map<String, MeasureUnit>> cache = new HashMap<String, Map<String, MeasureUnit>>();
    @Deprecated
    protected final String type;
    @Deprecated
    protected final String subType;
    static final UnicodeSet ASCII = new UnicodeSet(97, 122).freeze();
    static final UnicodeSet ASCII_HYPHEN_DIGITS = new UnicodeSet(45, 45, 48, 57, 97, 122).freeze();
    private static Factory UNIT_FACTORY = new Factory(){

        public MeasureUnit create(String type, String subType) {
            return new MeasureUnit(type, subType);
        }
    };
    static Factory CURRENCY_FACTORY = new Factory(){

        public MeasureUnit create(String unusedType, String subType) {
            return new Currency(subType);
        }
    };
    static Factory TIMEUNIT_FACTORY = new Factory(){

        public MeasureUnit create(String type, String subType) {
            return new TimeUnit(type, subType);
        }
    };
    public static final MeasureUnit G_FORCE;
    public static final MeasureUnit METER_PER_SECOND_SQUARED;
    public static final MeasureUnit ARC_MINUTE;
    public static final MeasureUnit ARC_SECOND;
    public static final MeasureUnit DEGREE;
    public static final MeasureUnit RADIAN;
    public static final MeasureUnit REVOLUTION_ANGLE;
    public static final MeasureUnit ACRE;
    public static final MeasureUnit HECTARE;
    public static final MeasureUnit SQUARE_CENTIMETER;
    public static final MeasureUnit SQUARE_FOOT;
    public static final MeasureUnit SQUARE_INCH;
    public static final MeasureUnit SQUARE_KILOMETER;
    public static final MeasureUnit SQUARE_METER;
    public static final MeasureUnit SQUARE_MILE;
    public static final MeasureUnit SQUARE_YARD;
    public static final MeasureUnit LITER_PER_100KILOMETERS;
    public static final MeasureUnit LITER_PER_KILOMETER;
    public static final MeasureUnit MILE_PER_GALLON;
    public static final MeasureUnit BIT;
    public static final MeasureUnit BYTE;
    public static final MeasureUnit GIGABIT;
    public static final MeasureUnit GIGABYTE;
    public static final MeasureUnit KILOBIT;
    public static final MeasureUnit KILOBYTE;
    public static final MeasureUnit MEGABIT;
    public static final MeasureUnit MEGABYTE;
    public static final MeasureUnit TERABIT;
    public static final MeasureUnit TERABYTE;
    public static final MeasureUnit CENTURY;
    public static final TimeUnit DAY;
    public static final TimeUnit HOUR;
    public static final MeasureUnit MICROSECOND;
    public static final MeasureUnit MILLISECOND;
    public static final TimeUnit MINUTE;
    public static final TimeUnit MONTH;
    public static final MeasureUnit NANOSECOND;
    public static final TimeUnit SECOND;
    public static final TimeUnit WEEK;
    public static final TimeUnit YEAR;
    public static final MeasureUnit AMPERE;
    public static final MeasureUnit MILLIAMPERE;
    public static final MeasureUnit OHM;
    public static final MeasureUnit VOLT;
    public static final MeasureUnit CALORIE;
    public static final MeasureUnit FOODCALORIE;
    public static final MeasureUnit JOULE;
    public static final MeasureUnit KILOCALORIE;
    public static final MeasureUnit KILOJOULE;
    public static final MeasureUnit KILOWATT_HOUR;
    public static final MeasureUnit GIGAHERTZ;
    public static final MeasureUnit HERTZ;
    public static final MeasureUnit KILOHERTZ;
    public static final MeasureUnit MEGAHERTZ;
    public static final MeasureUnit ASTRONOMICAL_UNIT;
    public static final MeasureUnit CENTIMETER;
    public static final MeasureUnit DECIMETER;
    public static final MeasureUnit FATHOM;
    public static final MeasureUnit FOOT;
    public static final MeasureUnit FURLONG;
    public static final MeasureUnit INCH;
    public static final MeasureUnit KILOMETER;
    public static final MeasureUnit LIGHT_YEAR;
    public static final MeasureUnit METER;
    public static final MeasureUnit MICROMETER;
    public static final MeasureUnit MILE;
    public static final MeasureUnit MILE_SCANDINAVIAN;
    public static final MeasureUnit MILLIMETER;
    public static final MeasureUnit NANOMETER;
    public static final MeasureUnit NAUTICAL_MILE;
    public static final MeasureUnit PARSEC;
    public static final MeasureUnit PICOMETER;
    public static final MeasureUnit YARD;
    public static final MeasureUnit LUX;
    public static final MeasureUnit CARAT;
    public static final MeasureUnit GRAM;
    public static final MeasureUnit KILOGRAM;
    public static final MeasureUnit METRIC_TON;
    public static final MeasureUnit MICROGRAM;
    public static final MeasureUnit MILLIGRAM;
    public static final MeasureUnit OUNCE;
    public static final MeasureUnit OUNCE_TROY;
    public static final MeasureUnit POUND;
    public static final MeasureUnit STONE;
    public static final MeasureUnit TON;
    public static final MeasureUnit GIGAWATT;
    public static final MeasureUnit HORSEPOWER;
    public static final MeasureUnit KILOWATT;
    public static final MeasureUnit MEGAWATT;
    public static final MeasureUnit MILLIWATT;
    public static final MeasureUnit WATT;
    public static final MeasureUnit HECTOPASCAL;
    public static final MeasureUnit INCH_HG;
    public static final MeasureUnit MILLIBAR;
    public static final MeasureUnit MILLIMETER_OF_MERCURY;
    public static final MeasureUnit POUND_PER_SQUARE_INCH;
    public static final MeasureUnit KARAT;
    public static final MeasureUnit KILOMETER_PER_HOUR;
    public static final MeasureUnit KNOT;
    public static final MeasureUnit METER_PER_SECOND;
    public static final MeasureUnit MILE_PER_HOUR;
    public static final MeasureUnit CELSIUS;
    public static final MeasureUnit FAHRENHEIT;
    public static final MeasureUnit GENERIC_TEMPERATURE;
    public static final MeasureUnit KELVIN;
    public static final MeasureUnit ACRE_FOOT;
    public static final MeasureUnit BUSHEL;
    public static final MeasureUnit CENTILITER;
    public static final MeasureUnit CUBIC_CENTIMETER;
    public static final MeasureUnit CUBIC_FOOT;
    public static final MeasureUnit CUBIC_INCH;
    public static final MeasureUnit CUBIC_KILOMETER;
    public static final MeasureUnit CUBIC_METER;
    public static final MeasureUnit CUBIC_MILE;
    public static final MeasureUnit CUBIC_YARD;
    public static final MeasureUnit CUP;
    public static final MeasureUnit CUP_METRIC;
    public static final MeasureUnit DECILITER;
    public static final MeasureUnit FLUID_OUNCE;
    public static final MeasureUnit GALLON;
    public static final MeasureUnit HECTOLITER;
    public static final MeasureUnit LITER;
    public static final MeasureUnit MEGALITER;
    public static final MeasureUnit MILLILITER;
    public static final MeasureUnit PINT;
    public static final MeasureUnit PINT_METRIC;
    public static final MeasureUnit QUART;
    public static final MeasureUnit TABLESPOON;
    public static final MeasureUnit TEASPOON;
    private static HashMap<Pair<MeasureUnit, MeasureUnit>, MeasureUnit> unitPerUnitToSingleUnit;

    @Deprecated
    protected MeasureUnit(String type, String subType) {
        this.type = type;
        this.subType = subType;
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + this.subType.hashCode();
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof MeasureUnit)) {
            return false;
        }
        MeasureUnit c = (MeasureUnit)rhs;
        return this.type.equals(c.type) && this.subType.equals(c.subType);
    }

    public String toString() {
        return this.type + "-" + this.subType;
    }

    @Deprecated
    public static MeasureUnit internalGetInstance(String type, String subType) {
        if (type == null || subType == null) {
            throw new NullPointerException("Type and subType must be non-null");
        }
        if (!("currency".equals(type) || ASCII.containsAll(type) && ASCII_HYPHEN_DIGITS.containsAll(subType))) {
            throw new IllegalArgumentException("The type or subType are invalid.");
        }
        Factory factory = "currency".equals(type) ? CURRENCY_FACTORY : ("duration".equals(type) ? TIMEUNIT_FACTORY : UNIT_FACTORY);
        return MeasureUnit.addUnit(type, subType, factory);
    }

    @Deprecated
    protected static synchronized MeasureUnit addUnit(String type, String unitName, Factory factory) {
        Map<String, MeasureUnit> tmp = cache.get(type);
        if (tmp == null) {
            tmp = new HashMap<String, MeasureUnit>();
            cache.put(type, tmp);
        } else {
            type = tmp.entrySet().iterator().next().getValue().type;
        }
        MeasureUnit unit = tmp.get(unitName);
        if (unit == null) {
            unit = factory.create(type, unitName);
            tmp.put(unitName, unit);
        }
        return unit;
    }

    static {
        ICUResourceBundle resource = (ICUResourceBundle)UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt56b", "en");
        for (String key : unitKeys) {
            try {
                ICUResourceBundle unitsTypeRes = resource.getWithFallback(key);
                int size = unitsTypeRes.getSize();
                for (int index = 0; index < size; ++index) {
                    UResourceBundle unitsRes = unitsTypeRes.get(index);
                    String type = unitsRes.getKey();
                    if (type.equals("compound")) continue;
                    int unitsSize = unitsRes.getSize();
                    for (int index2 = 0; index2 < unitsSize; ++index2) {
                        ICUResourceBundle unitNameRes = (ICUResourceBundle)unitsRes.get(index2);
                        if (unitNameRes.get("other") == null) continue;
                        MeasureUnit.internalGetInstance(type, unitNameRes.getKey());
                    }
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        try {
            UResourceBundle bundle = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudt56b", "currencyNumericCodes", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle codeMap = bundle.get("codeMap");
            Enumeration<String> it = codeMap.getKeys();
            while (it.hasMoreElements()) {
                MeasureUnit.internalGetInstance("currency", it.nextElement());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        G_FORCE = MeasureUnit.internalGetInstance("acceleration", "g-force");
        METER_PER_SECOND_SQUARED = MeasureUnit.internalGetInstance("acceleration", "meter-per-second-squared");
        ARC_MINUTE = MeasureUnit.internalGetInstance("angle", "arc-minute");
        ARC_SECOND = MeasureUnit.internalGetInstance("angle", "arc-second");
        DEGREE = MeasureUnit.internalGetInstance("angle", "degree");
        RADIAN = MeasureUnit.internalGetInstance("angle", "radian");
        REVOLUTION_ANGLE = MeasureUnit.internalGetInstance("angle", "revolution");
        ACRE = MeasureUnit.internalGetInstance("area", "acre");
        HECTARE = MeasureUnit.internalGetInstance("area", "hectare");
        SQUARE_CENTIMETER = MeasureUnit.internalGetInstance("area", "square-centimeter");
        SQUARE_FOOT = MeasureUnit.internalGetInstance("area", "square-foot");
        SQUARE_INCH = MeasureUnit.internalGetInstance("area", "square-inch");
        SQUARE_KILOMETER = MeasureUnit.internalGetInstance("area", "square-kilometer");
        SQUARE_METER = MeasureUnit.internalGetInstance("area", "square-meter");
        SQUARE_MILE = MeasureUnit.internalGetInstance("area", "square-mile");
        SQUARE_YARD = MeasureUnit.internalGetInstance("area", "square-yard");
        LITER_PER_100KILOMETERS = MeasureUnit.internalGetInstance("consumption", "liter-per-100kilometers");
        LITER_PER_KILOMETER = MeasureUnit.internalGetInstance("consumption", "liter-per-kilometer");
        MILE_PER_GALLON = MeasureUnit.internalGetInstance("consumption", "mile-per-gallon");
        BIT = MeasureUnit.internalGetInstance("digital", "bit");
        BYTE = MeasureUnit.internalGetInstance("digital", "byte");
        GIGABIT = MeasureUnit.internalGetInstance("digital", "gigabit");
        GIGABYTE = MeasureUnit.internalGetInstance("digital", "gigabyte");
        KILOBIT = MeasureUnit.internalGetInstance("digital", "kilobit");
        KILOBYTE = MeasureUnit.internalGetInstance("digital", "kilobyte");
        MEGABIT = MeasureUnit.internalGetInstance("digital", "megabit");
        MEGABYTE = MeasureUnit.internalGetInstance("digital", "megabyte");
        TERABIT = MeasureUnit.internalGetInstance("digital", "terabit");
        TERABYTE = MeasureUnit.internalGetInstance("digital", "terabyte");
        CENTURY = MeasureUnit.internalGetInstance("duration", "century");
        DAY = (TimeUnit)MeasureUnit.internalGetInstance("duration", "day");
        HOUR = (TimeUnit)MeasureUnit.internalGetInstance("duration", "hour");
        MICROSECOND = MeasureUnit.internalGetInstance("duration", "microsecond");
        MILLISECOND = MeasureUnit.internalGetInstance("duration", "millisecond");
        MINUTE = (TimeUnit)MeasureUnit.internalGetInstance("duration", "minute");
        MONTH = (TimeUnit)MeasureUnit.internalGetInstance("duration", "month");
        NANOSECOND = MeasureUnit.internalGetInstance("duration", "nanosecond");
        SECOND = (TimeUnit)MeasureUnit.internalGetInstance("duration", "second");
        WEEK = (TimeUnit)MeasureUnit.internalGetInstance("duration", "week");
        YEAR = (TimeUnit)MeasureUnit.internalGetInstance("duration", "year");
        AMPERE = MeasureUnit.internalGetInstance("electric", "ampere");
        MILLIAMPERE = MeasureUnit.internalGetInstance("electric", "milliampere");
        OHM = MeasureUnit.internalGetInstance("electric", "ohm");
        VOLT = MeasureUnit.internalGetInstance("electric", "volt");
        CALORIE = MeasureUnit.internalGetInstance("energy", "calorie");
        FOODCALORIE = MeasureUnit.internalGetInstance("energy", "foodcalorie");
        JOULE = MeasureUnit.internalGetInstance("energy", "joule");
        KILOCALORIE = MeasureUnit.internalGetInstance("energy", "kilocalorie");
        KILOJOULE = MeasureUnit.internalGetInstance("energy", "kilojoule");
        KILOWATT_HOUR = MeasureUnit.internalGetInstance("energy", "kilowatt-hour");
        GIGAHERTZ = MeasureUnit.internalGetInstance("frequency", "gigahertz");
        HERTZ = MeasureUnit.internalGetInstance("frequency", "hertz");
        KILOHERTZ = MeasureUnit.internalGetInstance("frequency", "kilohertz");
        MEGAHERTZ = MeasureUnit.internalGetInstance("frequency", "megahertz");
        ASTRONOMICAL_UNIT = MeasureUnit.internalGetInstance("length", "astronomical-unit");
        CENTIMETER = MeasureUnit.internalGetInstance("length", "centimeter");
        DECIMETER = MeasureUnit.internalGetInstance("length", "decimeter");
        FATHOM = MeasureUnit.internalGetInstance("length", "fathom");
        FOOT = MeasureUnit.internalGetInstance("length", "foot");
        FURLONG = MeasureUnit.internalGetInstance("length", "furlong");
        INCH = MeasureUnit.internalGetInstance("length", "inch");
        KILOMETER = MeasureUnit.internalGetInstance("length", "kilometer");
        LIGHT_YEAR = MeasureUnit.internalGetInstance("length", "light-year");
        METER = MeasureUnit.internalGetInstance("length", "meter");
        MICROMETER = MeasureUnit.internalGetInstance("length", "micrometer");
        MILE = MeasureUnit.internalGetInstance("length", "mile");
        MILE_SCANDINAVIAN = MeasureUnit.internalGetInstance("length", "mile-scandinavian");
        MILLIMETER = MeasureUnit.internalGetInstance("length", "millimeter");
        NANOMETER = MeasureUnit.internalGetInstance("length", "nanometer");
        NAUTICAL_MILE = MeasureUnit.internalGetInstance("length", "nautical-mile");
        PARSEC = MeasureUnit.internalGetInstance("length", "parsec");
        PICOMETER = MeasureUnit.internalGetInstance("length", "picometer");
        YARD = MeasureUnit.internalGetInstance("length", "yard");
        LUX = MeasureUnit.internalGetInstance("light", "lux");
        CARAT = MeasureUnit.internalGetInstance("mass", "carat");
        GRAM = MeasureUnit.internalGetInstance("mass", "gram");
        KILOGRAM = MeasureUnit.internalGetInstance("mass", "kilogram");
        METRIC_TON = MeasureUnit.internalGetInstance("mass", "metric-ton");
        MICROGRAM = MeasureUnit.internalGetInstance("mass", "microgram");
        MILLIGRAM = MeasureUnit.internalGetInstance("mass", "milligram");
        OUNCE = MeasureUnit.internalGetInstance("mass", "ounce");
        OUNCE_TROY = MeasureUnit.internalGetInstance("mass", "ounce-troy");
        POUND = MeasureUnit.internalGetInstance("mass", "pound");
        STONE = MeasureUnit.internalGetInstance("mass", "stone");
        TON = MeasureUnit.internalGetInstance("mass", "ton");
        GIGAWATT = MeasureUnit.internalGetInstance("power", "gigawatt");
        HORSEPOWER = MeasureUnit.internalGetInstance("power", "horsepower");
        KILOWATT = MeasureUnit.internalGetInstance("power", "kilowatt");
        MEGAWATT = MeasureUnit.internalGetInstance("power", "megawatt");
        MILLIWATT = MeasureUnit.internalGetInstance("power", "milliwatt");
        WATT = MeasureUnit.internalGetInstance("power", "watt");
        HECTOPASCAL = MeasureUnit.internalGetInstance("pressure", "hectopascal");
        INCH_HG = MeasureUnit.internalGetInstance("pressure", "inch-hg");
        MILLIBAR = MeasureUnit.internalGetInstance("pressure", "millibar");
        MILLIMETER_OF_MERCURY = MeasureUnit.internalGetInstance("pressure", "millimeter-of-mercury");
        POUND_PER_SQUARE_INCH = MeasureUnit.internalGetInstance("pressure", "pound-per-square-inch");
        KARAT = MeasureUnit.internalGetInstance("proportion", "karat");
        KILOMETER_PER_HOUR = MeasureUnit.internalGetInstance("speed", "kilometer-per-hour");
        KNOT = MeasureUnit.internalGetInstance("speed", "knot");
        METER_PER_SECOND = MeasureUnit.internalGetInstance("speed", "meter-per-second");
        MILE_PER_HOUR = MeasureUnit.internalGetInstance("speed", "mile-per-hour");
        CELSIUS = MeasureUnit.internalGetInstance("temperature", "celsius");
        FAHRENHEIT = MeasureUnit.internalGetInstance("temperature", "fahrenheit");
        GENERIC_TEMPERATURE = MeasureUnit.internalGetInstance("temperature", "generic");
        KELVIN = MeasureUnit.internalGetInstance("temperature", "kelvin");
        ACRE_FOOT = MeasureUnit.internalGetInstance("volume", "acre-foot");
        BUSHEL = MeasureUnit.internalGetInstance("volume", "bushel");
        CENTILITER = MeasureUnit.internalGetInstance("volume", "centiliter");
        CUBIC_CENTIMETER = MeasureUnit.internalGetInstance("volume", "cubic-centimeter");
        CUBIC_FOOT = MeasureUnit.internalGetInstance("volume", "cubic-foot");
        CUBIC_INCH = MeasureUnit.internalGetInstance("volume", "cubic-inch");
        CUBIC_KILOMETER = MeasureUnit.internalGetInstance("volume", "cubic-kilometer");
        CUBIC_METER = MeasureUnit.internalGetInstance("volume", "cubic-meter");
        CUBIC_MILE = MeasureUnit.internalGetInstance("volume", "cubic-mile");
        CUBIC_YARD = MeasureUnit.internalGetInstance("volume", "cubic-yard");
        CUP = MeasureUnit.internalGetInstance("volume", "cup");
        CUP_METRIC = MeasureUnit.internalGetInstance("volume", "cup-metric");
        DECILITER = MeasureUnit.internalGetInstance("volume", "deciliter");
        FLUID_OUNCE = MeasureUnit.internalGetInstance("volume", "fluid-ounce");
        GALLON = MeasureUnit.internalGetInstance("volume", "gallon");
        HECTOLITER = MeasureUnit.internalGetInstance("volume", "hectoliter");
        LITER = MeasureUnit.internalGetInstance("volume", "liter");
        MEGALITER = MeasureUnit.internalGetInstance("volume", "megaliter");
        MILLILITER = MeasureUnit.internalGetInstance("volume", "milliliter");
        PINT = MeasureUnit.internalGetInstance("volume", "pint");
        PINT_METRIC = MeasureUnit.internalGetInstance("volume", "pint-metric");
        QUART = MeasureUnit.internalGetInstance("volume", "quart");
        TABLESPOON = MeasureUnit.internalGetInstance("volume", "tablespoon");
        TEASPOON = MeasureUnit.internalGetInstance("volume", "teaspoon");
        unitPerUnitToSingleUnit = new HashMap();
        unitPerUnitToSingleUnit.put(Pair.of(KILOMETER, HOUR), KILOMETER_PER_HOUR);
        unitPerUnitToSingleUnit.put(Pair.of(MILE, GALLON), MILE_PER_GALLON);
        unitPerUnitToSingleUnit.put(Pair.of(MILE, HOUR), MILE_PER_HOUR);
        unitPerUnitToSingleUnit.put(Pair.of(METER, SECOND), METER_PER_SECOND);
        unitPerUnitToSingleUnit.put(Pair.of(LITER, KILOMETER), LITER_PER_KILOMETER);
        unitPerUnitToSingleUnit.put(Pair.of(POUND, SQUARE_INCH), POUND_PER_SQUARE_INCH);
    }

    @Deprecated
    protected static interface Factory {
        @Deprecated
        public MeasureUnit create(String var1, String var2);
    }
}

