/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

public final class UTF16 {
    public static int charAt(String source, int offset16) {
        char single = source.charAt(offset16);
        if (single < '\ud800') {
            return single;
        }
        return UTF16._charAt(source, offset16, single);
    }

    private static int _charAt(String source, int offset16, char single) {
        char lead;
        if (single > '\udfff') {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && (trail = source.charAt(offset16)) >= '\udc00' && trail <= '\udfff') {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && (lead = source.charAt(offset16)) >= '\ud800' && lead <= '\udbff') {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    public static int charAt(CharSequence source, int offset16) {
        char single = source.charAt(offset16);
        if (single < '\ud800') {
            return single;
        }
        return UTF16._charAt(source, offset16, single);
    }

    private static int _charAt(CharSequence source, int offset16, char single) {
        char lead;
        if (single > '\udfff') {
            return single;
        }
        if (single <= '\udbff') {
            char trail;
            if (source.length() != ++offset16 && (trail = source.charAt(offset16)) >= '\udc00' && trail <= '\udfff') {
                return Character.toCodePoint(single, trail);
            }
        } else if (--offset16 >= 0 && (lead = source.charAt(offset16)) >= '\ud800' && lead <= '\udbff') {
            return Character.toCodePoint(lead, single);
        }
        return single;
    }

    public static int charAt(char[] source, int start, int limit, int offset16) {
        if ((offset16 += start) < start || offset16 >= limit) {
            throw new ArrayIndexOutOfBoundsException(offset16);
        }
        char single = source[offset16];
        if (!UTF16.isSurrogate(single)) {
            return single;
        }
        if (single <= '\udbff') {
            if (++offset16 >= limit) {
                return single;
            }
            char trail = source[offset16];
            if (UTF16.isTrailSurrogate(trail)) {
                return Character.toCodePoint(single, trail);
            }
        } else {
            char lead;
            if (offset16 == start) {
                return single;
            }
            if (UTF16.isLeadSurrogate(lead = source[--offset16])) {
                return Character.toCodePoint(lead, single);
            }
        }
        return single;
    }

    public static int getCharCount(int char32) {
        if (char32 < 65536) {
            return 1;
        }
        return 2;
    }

    public static boolean isSurrogate(char char16) {
        return (char16 & 0xFFFFF800) == 55296;
    }

    public static boolean isTrailSurrogate(char char16) {
        return (char16 & 0xFFFFFC00) == 56320;
    }

    public static boolean isLeadSurrogate(char char16) {
        return (char16 & 0xFFFFFC00) == 55296;
    }

    public static char getLeadSurrogate(int char32) {
        if (char32 >= 65536) {
            return (char)(55232 + (char32 >> 10));
        }
        return '\u0000';
    }

    public static char getTrailSurrogate(int char32) {
        if (char32 >= 65536) {
            return (char)(56320 + (char32 & 0x3FF));
        }
        return (char)char32;
    }

    public static String valueOf(int char32) {
        if (char32 < 0 || char32 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        return UTF16.toString(char32);
    }

    private static String toString(int ch) {
        if (ch < 65536) {
            return String.valueOf((char)ch);
        }
        StringBuilder result = new StringBuilder();
        result.append(UTF16.getLeadSurrogate(ch));
        result.append(UTF16.getTrailSurrogate(ch));
        return result.toString();
    }
}

