/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2_16;
import com.ibm.icu.impl.Trie2_32;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Trie2
implements Iterable<Range> {
    private static ValueMapper defaultValueMapper = new ValueMapper(){

        public int map(int in) {
            return in;
        }
    };
    UTrie2Header header;
    char[] index;
    int data16;
    int[] data32;
    int indexLength;
    int dataLength;
    int index2NullOffset;
    int initialValue;
    int errorValue;
    int highStart;
    int highValueIndex;
    int dataNullOffset;
    int fHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Trie2 createFromSerialized(ByteBuffer bytes) throws IOException {
        ByteOrder outerByteOrder = bytes.order();
        try {
            Trie2 This;
            ValueWidth width;
            UTrie2Header header = new UTrie2Header();
            header.signature = bytes.getInt();
            switch (header.signature) {
                case 1416784178: {
                    break;
                }
                case 845771348: {
                    boolean isBigEndian = outerByteOrder == ByteOrder.BIG_ENDIAN;
                    bytes.order(isBigEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    header.signature = 1416784178;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Buffer does not contain a serialized UTrie2");
                }
            }
            header.options = bytes.getChar();
            header.indexLength = bytes.getChar();
            header.shiftedDataLength = bytes.getChar();
            header.index2NullOffset = bytes.getChar();
            header.dataNullOffset = bytes.getChar();
            header.shiftedHighStart = bytes.getChar();
            if ((header.options & 0xF) > 1) {
                throw new IllegalArgumentException("UTrie2 serialized format error.");
            }
            if ((header.options & 0xF) == 0) {
                width = ValueWidth.BITS_16;
                This = new Trie2_16();
            } else {
                width = ValueWidth.BITS_32;
                This = new Trie2_32();
            }
            This.header = header;
            This.indexLength = header.indexLength;
            This.dataLength = header.shiftedDataLength << 2;
            This.index2NullOffset = header.index2NullOffset;
            This.dataNullOffset = header.dataNullOffset;
            This.highStart = header.shiftedHighStart << 11;
            This.highValueIndex = This.dataLength - 4;
            if (width == ValueWidth.BITS_16) {
                This.highValueIndex += This.indexLength;
            }
            int indexArraySize = This.indexLength;
            if (width == ValueWidth.BITS_16) {
                indexArraySize += This.dataLength;
            }
            This.index = ICUBinary.getChars(bytes, indexArraySize, 0);
            if (width == ValueWidth.BITS_16) {
                This.data16 = This.indexLength;
            } else {
                This.data32 = ICUBinary.getInts(bytes, This.dataLength, 0);
            }
            switch (width) {
                case BITS_16: {
                    This.data32 = null;
                    This.initialValue = This.index[This.dataNullOffset];
                    This.errorValue = This.index[This.data16 + 128];
                    break;
                }
                case BITS_32: {
                    This.data16 = 0;
                    This.initialValue = This.data32[This.dataNullOffset];
                    This.errorValue = This.data32[128];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("UTrie2 serialized format error.");
                }
            }
            Trie2 trie2 = This;
            return trie2;
        }
        finally {
            bytes.order(outerByteOrder);
        }
    }

    public abstract int get(int var1);

    public abstract int getFromU16SingleLead(char var1);

    public final boolean equals(Object other) {
        if (!(other instanceof Trie2)) {
            return false;
        }
        Trie2 OtherTrie = (Trie2)other;
        Iterator<Range> otherIter = OtherTrie.iterator();
        for (Range rangeFromThis : this) {
            if (!otherIter.hasNext()) {
                return false;
            }
            Range rangeFromOther = otherIter.next();
            if (rangeFromThis.equals(rangeFromOther)) continue;
            return false;
        }
        if (otherIter.hasNext()) {
            return false;
        }
        return this.errorValue == OtherTrie.errorValue && this.initialValue == OtherTrie.initialValue;
    }

    public int hashCode() {
        if (this.fHash == 0) {
            int hash = Trie2.initHash();
            for (Range r : this) {
                hash = Trie2.hashInt(hash, r.hashCode());
            }
            if (hash == 0) {
                hash = 1;
            }
            this.fHash = hash;
        }
        return this.fHash;
    }

    @Override
    public Iterator<Range> iterator() {
        return this.iterator(defaultValueMapper);
    }

    public Iterator<Range> iterator(ValueMapper mapper) {
        return new Trie2Iterator(mapper);
    }

    int rangeEnd(int start, int limitp, int val) {
        int c;
        int limit = Math.min(this.highStart, limitp);
        for (c = start + 1; c < limit && this.get(c) == val; ++c) {
        }
        if (c >= this.highStart) {
            c = limitp;
        }
        return c - 1;
    }

    private static int initHash() {
        return -2128831035;
    }

    private static int hashByte(int h, int b) {
        h *= 16777619;
        return h ^= b;
    }

    private static int hashUChar32(int h, int c) {
        h = Trie2.hashByte(h, c & 0xFF);
        h = Trie2.hashByte(h, c >> 8 & 0xFF);
        h = Trie2.hashByte(h, c >> 16);
        return h;
    }

    private static int hashInt(int h, int i) {
        h = Trie2.hashByte(h, i & 0xFF);
        h = Trie2.hashByte(h, i >> 8 & 0xFF);
        h = Trie2.hashByte(h, i >> 16 & 0xFF);
        h = Trie2.hashByte(h, i >> 24 & 0xFF);
        return h;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Trie2Iterator
    implements Iterator<Range> {
        private ValueMapper mapper;
        private Range returnValue = new Range();
        private int nextStart;
        private int limitCP;
        private boolean doingCodePoints = true;
        private boolean doLeadSurrogates = true;

        Trie2Iterator(ValueMapper vm) {
            this.mapper = vm;
            this.nextStart = 0;
            this.limitCP = 0x110000;
            this.doLeadSurrogates = true;
        }

        @Override
        public Range next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.nextStart >= this.limitCP) {
                this.doingCodePoints = false;
                this.nextStart = 55296;
            }
            int endOfRange = 0;
            int val = 0;
            int mappedVal = 0;
            if (this.doingCodePoints) {
                val = Trie2.this.get(this.nextStart);
                mappedVal = this.mapper.map(val);
                endOfRange = Trie2.this.rangeEnd(this.nextStart, this.limitCP, val);
                while (endOfRange < this.limitCP - 1 && this.mapper.map(val = Trie2.this.get(endOfRange + 1)) == mappedVal) {
                    endOfRange = Trie2.this.rangeEnd(endOfRange + 1, this.limitCP, val);
                }
            } else {
                val = Trie2.this.getFromU16SingleLead((char)this.nextStart);
                mappedVal = this.mapper.map(val);
                endOfRange = this.rangeEndLS((char)this.nextStart);
                while (endOfRange < 56319 && this.mapper.map(val = Trie2.this.getFromU16SingleLead((char)(endOfRange + 1))) == mappedVal) {
                    endOfRange = this.rangeEndLS((char)(endOfRange + 1));
                }
            }
            this.returnValue.startCodePoint = this.nextStart;
            this.returnValue.endCodePoint = endOfRange;
            this.returnValue.value = mappedVal;
            this.returnValue.leadSurrogate = !this.doingCodePoints;
            this.nextStart = endOfRange + 1;
            return this.returnValue;
        }

        @Override
        public boolean hasNext() {
            return this.doingCodePoints && (this.doLeadSurrogates || this.nextStart < this.limitCP) || this.nextStart < 56320;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int rangeEndLS(char startingLS) {
            int c;
            if (startingLS >= '\udbff') {
                return 56319;
            }
            int val = Trie2.this.getFromU16SingleLead(startingLS);
            for (c = startingLS + '\u0001'; c <= 56319 && Trie2.this.getFromU16SingleLead((char)c) == val; ++c) {
            }
            return c - 1;
        }
    }

    static class UTrie2Header {
        int signature;
        int options;
        int indexLength;
        int shiftedDataLength;
        int index2NullOffset;
        int dataNullOffset;
        int shiftedHighStart;

        UTrie2Header() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ValueWidth {
        BITS_16,
        BITS_32;

    }

    public static interface ValueMapper {
        public int map(int var1);
    }

    public static class Range {
        public int startCodePoint;
        public int endCodePoint;
        public int value;
        public boolean leadSurrogate;

        public boolean equals(Object other) {
            if (other == null || !other.getClass().equals(this.getClass())) {
                return false;
            }
            Range tother = (Range)other;
            return this.startCodePoint == tother.startCodePoint && this.endCodePoint == tother.endCodePoint && this.value == tother.value && this.leadSurrogate == tother.leadSurrogate;
        }

        public int hashCode() {
            int h = Trie2.initHash();
            h = Trie2.hashUChar32(h, this.startCodePoint);
            h = Trie2.hashUChar32(h, this.endCodePoint);
            h = Trie2.hashInt(h, this.value);
            h = Trie2.hashByte(h, this.leadSurrogate ? 1 : 0);
            return h;
        }
    }
}

