/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.jxpath.JXPathContext;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

public class JXPathXPath
extends XPath {
    private static final Pattern quotePattern = Pattern.compile("\"");
    private final String path;
    private final List<Namespace> namespaces;
    private final Map<String, Object> variables;

    public static final String toLiteral(String s) {
        return String.valueOf('\"') + quotePattern.matcher(s).replaceAll("&quot;") + '\"';
    }

    public JXPathXPath(String path) {
        this.path = path;
        this.namespaces = new ArrayList<Namespace>();
        this.variables = new HashMap<String, Object>();
    }

    @Override
    public String getXPath() {
        return this.path;
    }

    @Override
    public void addNamespace(Namespace namespace) {
        this.namespaces.add(namespace);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    @Override
    public String valueOf(Object context) throws JDOMException {
        return (String)this.getJXPath(context).getValue("fn:string(" + this.getXPath() + ")");
    }

    @Override
    public Number numberValueOf(Object context) throws JDOMException {
        return (Number)this.getJXPath(context).getValue(this.getXPath(), Number.class);
    }

    @Override
    public Object selectSingleNode(Object context) throws JDOMException {
        return this.getJXPath(context).selectSingleNode(this.getXPath());
    }

    @Override
    public List selectNodes(Object context) throws JDOMException {
        return this.getJXPath(context).selectNodes(this.getXPath());
    }

    private JXPathContext getJXPath(Object context) {
        JXPathContext newContext = JXPathContext.newContext((Object)context);
        for (Namespace namespace : this.namespaces) {
            newContext.registerNamespace(namespace.getPrefix(), namespace.getURI());
        }
        for (Map.Entry entry : this.variables.entrySet()) {
            newContext.getVariables().declareVariable((String)entry.getKey(), entry.getValue());
        }
        newContext.setLenient(true);
        return newContext;
    }
}

