/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.prog;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CorrectPathEncoding {
    public static final String VERSION = "0.5.1";
    public static final int EXIT_INCONCLUSIVE = 2;
    public static final int EXIT_USAGE = 3;
    public static final String FIND_BIN_PROP = "find.path";
    private static final Charset cp850 = Charset.forName("cp850");
    private static final Charset cp1252 = Charset.forName("cp1252");
    private static final Charset[] nonUTF8 = new Charset[]{cp850, cp1252};
    private static final Charset utf8 = Charset.forName("utf8");
    private static final String LIST_FILE = "list.print0";
    private static final String DATA_FILE = "renameData";
    private static final String ERROR_FILE = "renameError";
    private static final String RENAME_SCRIPT = "rename.sh";
    private static final String[] GENERATED_FILES = new String[]{"list.print0", "renameData", "renameError", "rename.sh"};
    private final File outDir;
    private final Map<String, Charset> dirMap;
    private boolean verbose = false;

    private static int lastIndexOf(byte[] array, byte b) {
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] == b) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        int res;
        if (args.length == 0 || args.length > 2) {
            res = CorrectPathEncoding.usage();
        } else {
            String correctOption = "--correct";
            String option = args.length == 1 ? "--correct" : args[0];
            String value = args.length == 1 ? args[0] : args[1];
            boolean find = option.equals("--find");
            if (option.equals("--list")) {
                File list = new File(value);
                res = CorrectPathEncoding.generateScript(new CorrectPathEncoding(list.getParentFile()), list, find);
            } else {
                CorrectPathEncoding renamer = new CorrectPathEncoding(new File(value));
                if (find) {
                    res = CorrectPathEncoding.generateScript(renamer, renamer.find(), find);
                } else if (option.equals("--resolve")) {
                    renamer.resolve();
                    res = 0;
                } else if (option.equals("--exec")) {
                    res = renamer.exec();
                } else if (option.equals("--correct")) {
                    res = renamer.correct();
                } else if (option.equals("--clean")) {
                    renamer.clean(true);
                    res = 0;
                } else {
                    res = CorrectPathEncoding.usage();
                }
            }
            if (res != 0) {
                System.err.println(String.valueOf(option) + " returned code " + res);
            }
        }
        System.exit(res);
    }

    private static int generateScript(CorrectPathEncoding renamer, File list, boolean find) throws IOException {
        if (!list.isFile()) {
            throw new IllegalStateException("not a file " + list);
        }
        if (list.length() == 0L) {
            if (find) {
                System.out.println("No files to correct found.");
                list.delete();
            } else {
                System.out.println("List empty : " + list.getAbsolutePath());
            }
            return 0;
        }
        System.out.println("Generated " + renamer.generateScript(new BufferedInputStream(new FileInputStream(list))) + " renames in " + renamer.dirMap.size() + " directories.");
        return renamer.hasErrors() ? 2 : 0;
    }

    private static int usage() {
        System.out.println(String.valueOf(CorrectPathEncoding.class.getSimpleName()) + " version " + VERSION);
        System.out.println(String.valueOf(CorrectPathEncoding.class.getName()) + " [--correct] dir | --find dir | --resolve dir | --clean dir | --list fileList");
        System.out.println("--find will search for files to correct in dir and will output rename.sh in it");
        System.out.println("--resolve will ask how to rename files in renameError");
        System.out.println("--exec will execute a previously generated script");
        System.out.println("--clean will remove any generated files");
        System.out.println("--correct will call successively --find, --resolve, --exec, --clean");
        System.out.println("--list allow to take an already generated list and output rename.sh in the same directory");
        System.out.println("\tfileList must be a list of filenames separated by NUL, depth-first");
        System.out.println("\nfind.path : system property to point to the 'find' program");
        return 3;
    }

    protected CorrectPathEncoding() {
        this(new File("."));
    }

    protected CorrectPathEncoding(File outDir) {
        if (!outDir.isDirectory()) {
            throw new IllegalArgumentException(outDir + " is not a directory");
        }
        this.outDir = outDir;
        this.dirMap = new HashMap<String, Charset>(4096);
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private final File getErrorFile() {
        return new File(this.outDir, ERROR_FILE);
    }

    private boolean hasErrors() {
        return this.getErrorFile().exists() && this.getErrorFile().length() > 0L;
    }

    public final File find() throws Exception {
        String findBin = System.getProperty(FIND_BIN_PROP, "find");
        ProcessBuilder procBuilder = new ProcessBuilder(findBin, ".", "-depth", "-not", "-name", "*", "-fprint0", LIST_FILE).directory(this.outDir);
        Process proc = procBuilder.start();
        int exitCode = proc.waitFor();
        if (exitCode != 0) {
            throw new IllegalStateException("find returned " + exitCode);
        }
        return new File(this.outDir, LIST_FILE);
    }

    public final Long generateScript(InputStream ins) throws IOException {
        int i;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(this.outDir, DATA_FILE)));
        OutputStream err = null;
        long count = 0L;
        boolean containsNonASCII = false;
        ByteBuffer buffer = ByteBuffer.allocate(4096);
        while ((i = ins.read()) != -1) {
            if (i == 0) {
                if (containsNonASCII) {
                    boolean validUTF8;
                    int bufferCount = buffer.position();
                    buffer.limit(bufferCount);
                    buffer.position(0);
                    try {
                        utf8.newDecoder().decode(buffer);
                        validUTF8 = true;
                    }
                    catch (Exception e) {
                        validUTF8 = false;
                    }
                    if (!validUTF8) {
                        byte[] dst = new byte[bufferCount];
                        buffer.position(0);
                        buffer.get(dst);
                        try {
                            byte[] fixedName = this.guessName(dst);
                            ((OutputStream)out).write(dst);
                            ((OutputStream)out).write(0);
                            ((OutputStream)out).write(fixedName);
                            ((OutputStream)out).write(0);
                            ++count;
                        }
                        catch (IOException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (err == null) {
                                err = new BufferedOutputStream(new FileOutputStream(this.getErrorFile()));
                            }
                            err.write(dst);
                            err.write(0);
                        }
                    }
                }
                buffer.clear();
                containsNonASCII = false;
                continue;
            }
            buffer.put((byte)i);
            if (i < 128) continue;
            containsNonASCII = true;
        }
        ((OutputStream)out).close();
        if (err != null) {
            err.close();
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.outDir, RENAME_SCRIPT)), utf8));
        writer.write("#!/bin/bash");
        writer.newLine();
        writer.newLine();
        writer.write("xargs -0 -a renameData -L2 mv");
        writer.newLine();
        writer.close();
        return count;
    }

    public final long resolve() throws IOException {
        long res = 0L;
        File errFile = this.getErrorFile();
        if (errFile.isFile() && errFile.length() > 0L) {
            int i;
            System.out.println("Please provide the correct name (just the filename, without the directory) :");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            BufferedInputStream errStream = new BufferedInputStream(new FileInputStream(errFile));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(errFile.getParentFile(), DATA_FILE), true));
            while ((i = ((InputStream)errStream).read()) != -1) {
                if (i != 0) {
                    buffer.put((byte)i);
                    continue;
                }
                buffer.limit(buffer.position());
                buffer.position(0);
                Path p = new Path(buffer);
                System.out.println(new String(p.getBytes(), utf8));
                Pattern patrn = Pattern.compile("[\\p{Space}&&[^ ]]");
                String answer = patrn.matcher(br.readLine()).replaceAll("");
                while (answer.indexOf(47) >= 0) {
                    System.out.println("Do not include the directory");
                    answer = patrn.matcher(br.readLine()).replaceAll("");
                }
                ((OutputStream)out).write(p.getBytes());
                ((OutputStream)out).write(0);
                ((OutputStream)out).write(p.getFixedPath(answer));
                ((OutputStream)out).write(0);
                ++res;
                buffer.clear();
            }
            ((OutputStream)out).close();
            ((InputStream)errStream).close();
            errFile.delete();
        } else {
            System.out.println("Nothing to resolve");
        }
        return res;
    }

    public final int exec() throws Exception {
        if (new File(this.outDir, RENAME_SCRIPT).exists()) {
            System.out.print("Beginning renames...");
            ProcessBuilder procBuilder = new ProcessBuilder("bash", RENAME_SCRIPT).directory(this.outDir);
            Process proc = procBuilder.start();
            int res = proc.waitFor();
            if (res == 0) {
                System.out.println(" done");
            }
            return res;
        }
        System.out.println("Nothing to execute.");
        return 0;
    }

    public final void clean(boolean ask) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        String[] stringArray = GENERATED_FILES;
        int n = GENERATED_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File f = new File(this.outDir, name);
            if (f.exists()) {
                files.add(f);
            }
            ++n2;
        }
        if (files.size() == 0) {
            System.out.println("No files to remove.");
        } else {
            boolean proceed;
            if (ask) {
                System.out.println("Remove " + files + " ?");
                int read = System.in.read();
                proceed = read == 121;
            } else {
                proceed = true;
            }
            if (proceed) {
                for (File f : files) {
                    if (f.delete()) continue;
                    throw new IOException("Couldn't remove " + f);
                }
                if (ask) {
                    System.out.println("Done.");
                } else {
                    System.out.println("Removed " + files + ".");
                }
            } else {
                System.out.println("No files removed.");
            }
        }
    }

    public final int correct() throws Exception {
        int execCode;
        CorrectPathEncoding.generateScript(this, this.find(), true);
        if (this.hasErrors()) {
            this.resolve();
        }
        if ((execCode = this.exec()) != 0) {
            return execCode;
        }
        this.clean(false);
        return 0;
    }

    private byte[] guessName(byte[] array) {
        Path p = new Path(array);
        int cp850Count = 0;
        int cp1252Count = 0;
        int i = p.getStart();
        while (i < array.length) {
            byte b = array[i];
            if (b < 0) {
                Charset cp;
                int positive = b + 256;
                try {
                    cp = this.guessCP(positive);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Couldn't guess at " + i + " : " + new String(array), e);
                }
                if (cp == cp850) {
                    ++cp850Count;
                } else if (cp == cp1252) {
                    ++cp1252Count;
                }
            }
            ++i;
        }
        Charset cp = cp1252Count > 0 && cp850Count == 0 ? cp1252 : (cp850Count > 0 && cp1252Count == 0 ? cp850 : this.guessWithAllBytes(array));
        if (cp == null) {
            throw new IllegalStateException("couldn't guess the encoding ; cp850Count: " + cp850Count + " : " + new String(array, cp850) + ", cp1252Count: " + cp1252Count + " : " + new String(array, cp1252));
        }
        String fixedName = p.getFileName(cp);
        String dir = p.getDir();
        if (!this.dirMap.containsKey(dir)) {
            this.dirMap.put(dir, cp);
        } else if (this.dirMap.get(dir) != cp) {
            throw new IllegalStateException("current encoding was " + this.dirMap.get(dir) + " for " + dir + "\nbut " + cp + " for " + fixedName);
        }
        if (this.verbose) {
            System.out.println("found charset: " + cp + " : " + fixedName);
        }
        return p.getFixedPath(fixedName);
    }

    private Charset guessWithAllBytes(byte[] array) {
        Charset[] charsetArray = nonUTF8;
        int n = nonUTF8.length;
        int n2 = 0;
        while (n2 < n) {
            Charset cs = charsetArray[n2];
            String s = new String(array, cs).toLowerCase();
            if (s.endsWith(".rep\u00b5.doc") || s.endsWith(".rlp\u00b5.doc")) {
                return cs;
            }
            ++n2;
        }
        return null;
    }

    private Charset guessCP(int positive) {
        Charset cp;
        switch (positive) {
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: {
                cp = cp850;
                break;
            }
            case 156: {
                cp = cp1252;
                break;
            }
            case 157: 
            case 158: 
            case 159: 
            case 161: 
            case 162: 
            case 172: 
            case 173: {
                cp = cp850;
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                cp = cp1252;
                break;
            }
            case 183: 
            case 184: {
                cp = cp850;
                break;
            }
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                cp = cp1252;
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 206: {
                cp = cp1252;
                break;
            }
            case 208: 
            case 209: {
                throw new IllegalStateException("shouldn't happen " + Integer.toHexString(positive));
            }
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: {
                cp = cp1252;
                break;
            }
            case 224: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 231: 
            case 232: 
            case 233: 
            case 236: 
            case 237: 
            case 238: {
                cp = cp1252;
                break;
            }
            case 240: {
                throw new IllegalStateException("shouldn't happen " + Integer.toHexString(positive));
            }
            case 244: 
            case 247: {
                cp = cp1252;
                break;
            }
            case 248: {
                cp = cp850;
                break;
            }
            case 250: 
            case 251: {
                cp = cp1252;
                break;
            }
            case 253: {
                cp = cp850;
                break;
            }
            case 255: {
                cp = cp850;
                break;
            }
            default: {
                System.err.println("Inconclusive : " + Integer.toHexString(positive));
                cp = null;
            }
        }
        return cp;
    }

    private static byte[] bufferToArray(ByteBuffer buffer) {
        byte[] res = new byte[buffer.limit() - buffer.position()];
        buffer.get(res);
        return res;
    }

    private static final class Path {
        private final byte[] bytes;
        private final int start;

        public Path(ByteBuffer buffer) {
            this(CorrectPathEncoding.bufferToArray(buffer));
        }

        public Path(byte[] bytes) {
            this.bytes = bytes;
            this.start = CorrectPathEncoding.lastIndexOf(this.bytes, (byte)47) + 1;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public final int getStart() {
            return this.start;
        }

        public final String getDir() {
            return new String(this.getBytes(), 0, this.getStart() - 1, utf8);
        }

        public final String getFileName(Charset cp) {
            return new String(this.getBytes(), this.getStart(), this.getBytes().length - this.getStart(), cp);
        }

        public final byte[] getFixedPath(String fixedName) {
            byte[] fixedNameB = fixedName.getBytes(utf8);
            byte[] res = new byte[this.getStart() + fixedNameB.length];
            System.arraycopy(this.getBytes(), 0, res, 0, this.getStart());
            System.arraycopy(fixedNameB, 0, res, this.getStart(), fixedNameB.length);
            return res;
        }
    }
}

