/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Transport;
import org.openconcerto.utils.ExceptionUtils;

public class MailAccount {
    private final String name;
    private final String address;
    private final String smtpServer;
    private final int port;
    private PasswordAuthentication auth;

    public static void addTimeouts(Properties props, String protocol) {
        props.setProperty("mail." + protocol + ".connectiontimeout", "180000");
        props.setProperty("mail." + protocol + ".timeout", "180000");
        props.setProperty("mail." + protocol + ".writetimeout", "180000");
    }

    public static final String handle(MessagingException mex) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(String.valueOf(ExceptionUtils.getStackTrace((Throwable)mex)) + "\n");
        Object ex = mex;
        do {
            if (ex instanceof SendFailedException) {
                Address[] validSent;
                Address[] validUnsent;
                SendFailedException sfex = (SendFailedException)ex;
                Address[] invalid = sfex.getInvalidAddresses();
                if (invalid != null) {
                    sb.append("    ** Invalid Addresses\n");
                    if (invalid != null) {
                        int i = 0;
                        while (i < invalid.length) {
                            sb.append("         " + invalid[i]);
                            ++i;
                        }
                    }
                }
                if ((validUnsent = sfex.getValidUnsentAddresses()) != null) {
                    sb.append("    ** ValidUnsent Addresses\n");
                    if (validUnsent != null) {
                        int i = 0;
                        while (i < validUnsent.length) {
                            sb.append("         " + validUnsent[i]);
                            ++i;
                        }
                    }
                }
                if ((validSent = sfex.getValidSentAddresses()) != null) {
                    sb.append("    ** ValidSent Addresses\n");
                    if (validSent != null) {
                        int i = 0;
                        while (i < validSent.length) {
                            sb.append("         " + validSent[i]);
                            ++i;
                        }
                    }
                }
            }
            sb.append("\n");
        } while ((ex = ex instanceof MessagingException ? ex.getNextException() : null) != null);
        return sb.toString();
    }

    public MailAccount(String name, String address, String smtpServer) {
        this(name, address, smtpServer, -1);
    }

    public MailAccount(String name, String address, String smtpServer, int port) {
        this.name = name;
        this.address = address;
        this.smtpServer = smtpServer;
        this.port = port;
        this.auth = null;
    }

    public final String getName() {
        return this.name;
    }

    public final String getAddress() {
        return this.address;
    }

    public final String getSMTPServer() {
        return this.smtpServer;
    }

    public final int getPort() {
        return this.port;
    }

    public final PasswordAuthentication getAuth() {
        return this.auth;
    }

    public void setAuth(PasswordAuthentication auth) {
        this.auth = auth;
    }

    public String getSMTPProtocol() {
        return "smtp";
    }

    public final Properties createProperties() {
        return this.createProperties(false);
    }

    public final Properties createProperties(boolean trustServer) {
        Properties props = new Properties();
        String proto = this.getSMTPProtocol();
        props.setProperty("mail.transport.protocol", proto);
        String prefix = "mail." + proto + ".";
        props.setProperty(String.valueOf(prefix) + "host", this.getSMTPServer());
        props.setProperty(String.valueOf(prefix) + "port", this.getPort() < 0 ? "587" : String.valueOf(this.getPort()));
        props.setProperty(String.valueOf(prefix) + "starttls.required", "true");
        if (trustServer) {
            props.setProperty(String.valueOf(prefix) + "ssl.trust", this.getSMTPServer());
        }
        MailAccount.addTimeouts(props, proto);
        return props;
    }

    public final void send(Message msg) throws MessagingException {
        PasswordAuthentication auth = this.getAuth();
        msg.getSession().getProperties().setProperty("mail." + this.getSMTPProtocol() + ".auth", auth == null ? "false" : "true");
        Throwable throwable = null;
        Object var4_5 = null;
        try (Transport mailTransport = msg.getSession().getTransport();){
            if (auth == null) {
                mailTransport.connect();
            } else {
                mailTransport.connect(auth.getUserName(), auth.getPassword());
            }
            mailTransport.sendMessage(msg, msg.getAllRecipients());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getAddress() + " through " + this.getSMTPServer();
    }
}

