/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.NounClass;
import org.openconcerto.utils.i18n.VariantKey;

public class Phrase {
    private final Grammar grammar;
    private final String base;
    private final NounClass nounClass;
    private final Map<Object, String> variants;
    private final Set<Object> explicitVariants;

    public static final Phrase getInvariant(String s) {
        return new Phrase(null, s, null);
    }

    public Phrase(Grammar grammar, String base, NounClass nounClass) {
        if (base == null) {
            throw new NullPointerException("null base");
        }
        this.base = base;
        this.grammar = grammar;
        this.nounClass = nounClass;
        if (grammar == null && nounClass == null) {
            this.variants = null;
            this.explicitVariants = null;
        } else {
            this.variants = new HashMap<Object, String>();
            this.variants.put(null, this.getBase());
            this.explicitVariants = new HashSet<Object>();
        }
    }

    public final Grammar getGrammar() {
        return this.grammar;
    }

    public final String getBase() {
        return this.base;
    }

    public final NounClass getNounClass() {
        return this.nounClass;
    }

    public final String putVariant(VariantKey key, String variant) {
        return this.putVariant(key, variant, true);
    }

    private final synchronized String putVariant(VariantKey key, String variant, boolean explicit) {
        String res = this.variants.put(key, variant);
        if (explicit) {
            this.explicitVariants.add(key);
            this.variants.keySet().retainAll(this.explicitVariants);
        }
        return res;
    }

    public final synchronized String getVariant(VariantKey key) {
        if (this.variants == null) {
            return this.getBase();
        }
        String res = this.variants.get(key);
        if (res == null) {
            res = this.getGrammar().getVariant(this, key);
            if (res == null) {
                Log.get().warning("No variant " + key + " for " + this);
                res = this.getBase();
            } else {
                this.putVariant(key, res, false);
            }
        }
        return res;
    }

    public final synchronized String getNumeralVariant(int count, VariantKey key) {
        if (this.variants == null) {
            return String.valueOf(count) + " " + this.getBase();
        }
        return new MessageFormat(this.getVariant(key), this.getGrammar().getLocale()).format(new Object[]{count});
    }

    public String toString() {
        String cl = this.getNounClass() == null ? " " : " (" + this.getNounClass().getName() + ") ";
        String gr = this.getGrammar() == null ? "" : " with " + this.getGrammar();
        return String.valueOf(this.getClass().getSimpleName()) + cl + this.getBase() + gr;
    }
}

