/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.checks;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openconcerto.utils.cc.IPredicate;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.EmptyObj;
import org.openconcerto.utils.checks.ValueObject;

public class EmptyObjFromVO<V>
implements EmptyObj {
    private static final IPredicate<Object> DEFAULT_PREDICATE = new IPredicate<Object>(){

        @Override
        public boolean evaluateChecked(Object object) {
            if (object instanceof String) {
                return ((String)object).length() == 0;
            }
            return object == null;
        }
    };
    private final ValueObject<V> vo;
    private final IPredicate<V> testEmptiness;
    private final EmptyChangeSupport supp;

    public static final <T> IPredicate<T> getDefaultPredicate() {
        return DEFAULT_PREDICATE;
    }

    public EmptyObjFromVO(ValueObject<V> vo, IPredicate<V> testEmptiness) {
        this.vo = vo;
        if (testEmptiness == null) {
            throw new IllegalArgumentException("null testEmptiness");
        }
        this.testEmptiness = testEmptiness;
        this.supp = new EmptyChangeSupport(this, this.isEmpty());
        this.vo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EmptyObjFromVO.this.valueChanged();
            }
        });
    }

    @Override
    public final boolean isEmpty() {
        return this.testEmptiness.evaluateChecked(this.vo.getValue());
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.supp.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.supp.removeEmptyListener(l);
    }

    private void valueChanged() {
        this.supp.fireEmptyChange(this.isEmpty());
    }
}

