/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openconcerto.utils.AbstractXMLDateFormat;

public class XMLCalendarFormat
extends AbstractXMLDateFormat {
    private final boolean alwaysParseGregorian;

    public XMLCalendarFormat() {
        this(null, null);
    }

    public XMLCalendarFormat(TimeZone timezone, Locale aLocale) {
        this(timezone, aLocale, false);
    }

    public XMLCalendarFormat(TimeZone timezone, Locale aLocale, boolean alwaysParseGregorian) {
        super(timezone, aLocale);
        this.alwaysParseGregorian = alwaysParseGregorian;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        GregorianCalendar cal;
        if (obj instanceof Date) {
            cal = new GregorianCalendar(this.getTimeZone(), this.getLocale());
            cal.setTime((Date)obj);
        } else if (obj instanceof GregorianCalendar) {
            cal = (GregorianCalendar)obj;
        } else {
            Calendar nonGregCal = (Calendar)obj;
            cal = new GregorianCalendar(nonGregCal.getTimeZone());
            cal.setTime(nonGregCal.getTime());
        }
        XMLGregorianCalendar xmlCal = factory.newXMLGregorianCalendar(cal);
        xmlCal.setTimezone(Integer.MIN_VALUE);
        return toAppendTo.append(xmlCal.toXMLFormat());
    }

    @Override
    public Calendar parseObject(String source, ParsePosition pos) {
        try {
            Calendar res;
            XMLGregorianCalendar xmlCal = factory.newXMLGregorianCalendar(source.substring(pos.getIndex()));
            pos.setIndex(source.length());
            GregorianCalendar gregorianCalendar = xmlCal.toGregorianCalendar(this.getTimeZone(), this.getLocale(), null);
            if (this.alwaysParseGregorian) {
                res = gregorianCalendar;
            } else {
                res = Calendar.getInstance(this.getTimeZone(), this.getLocale());
                res.setTime(gregorianCalendar.getTime());
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            pos.setErrorIndex(pos.getIndex());
            return null;
        }
    }
}

