/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ThreadHandler
extends Handler {
    private static ThreadHandler instance = new ThreadHandler();
    private Socket socket;
    private PrintWriter out;
    static Logger l = Logger.getLogger("org.openconcerto.test");

    private ThreadHandler() {
        try {
            this.socket = new Socket("localhost", 3200);
            this.out = new PrintWriter(this.socket.getOutputStream(), false);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }

    public static synchronized ThreadHandler getInstance() {
        return instance;
    }

    @Override
    public void close() throws SecurityException {
        this.out.flush();
        this.out.close();
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public void publish(LogRecord record) {
        String str = "[" + record.getThreadID() + "]" + record.getMessage();
        try {
            this.send(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void send(String str) {
        this.out.println(str);
    }

    public static void main(String[] args) {
        l.addHandler(ThreadHandler.getInstance());
        l.setLevel(Level.ALL);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadHandler.log("Test1");
                ThreadHandler.log("Test11");
                ThreadHandler.log("Test11");
                ThreadHandler.log("Test11");
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadHandler.log("Test2");
                ThreadHandler.log("Test22");
                ThreadHandler.log("Test22");
                ThreadHandler.log("Test22");
                ThreadHandler.log("Test22");
            }
        }).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadHandler.log("Test3");
                ThreadHandler.log("Test3");
                ThreadHandler.log("Test3");
                ThreadHandler.log("Test3");
                ThreadHandler.log("Test3");
                ThreadHandler.log("Test3");
            }
        }).start();
    }

    protected static void log(String string) {
        l.fine(string);
    }
}

