/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class IFutureTask<V>
extends FutureTask<V> {
    private static final Runnable NOOP_RUNNABLE = new Runnable(){

        @Override
        public void run() {
        }
    };
    private static final Callable<Object> NOOP_CALLABLE = new Callable<Object>(){

        @Override
        public Object call() throws Exception {
            return null;
        }
    };
    private final Runnable runnable;
    private final String detail;

    public static final Runnable getNoOpRunnable() {
        return NOOP_RUNNABLE;
    }

    public static final <T> Callable<T> getNoOpCallable() {
        return NOOP_CALLABLE;
    }

    public static final <V> FutureTask<V> createNoOp() {
        return IFutureTask.createNoOp(null);
    }

    public static final <V> FutureTask<V> createNoOp(V result) {
        return new IFutureTask<V>(IFutureTask.getNoOpRunnable(), result);
    }

    public IFutureTask(Runnable runnable, V result) {
        this(runnable, result, "");
    }

    public IFutureTask(Runnable runnable, V result, String detail) {
        super(runnable, result);
        this.runnable = runnable;
        this.detail = detail;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public String toString() {
        return String.valueOf(this.isCancelled() ? "[cancelled] " : "") + this.getClass().getSimpleName() + " running {" + this.getRunnable() + "}" + this.detail;
    }
}

