/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openconcerto.utils.cc.IClosure;

public abstract class DropperQueue<T>
extends Thread {
    private final Deque<T> items = new LinkedList<T>();
    private final Lock itemsLock = new ReentrantLock();
    private final Condition notEmpty = this.itemsLock.newCondition();
    private boolean stop = false;
    private boolean sleeping = false;
    private boolean executing = false;

    public DropperQueue(String name) {
        super(name);
    }

    public final synchronized boolean setSleeping(boolean b) {
        if (this.sleeping != b) {
            this.sleeping = b;
            this.signalChange();
            return true;
        }
        return false;
    }

    public synchronized boolean isSleeping() {
        return this.sleeping;
    }

    private synchronized void signalChange() {
        this.signalChange(false);
    }

    private synchronized void signalChange(boolean signalClosure) {
        if (signalClosure || !this.isExecuting()) {
            this.interrupt();
        }
    }

    private synchronized void setExecuting(boolean b) {
        this.executing = b;
    }

    private synchronized boolean isExecuting() {
        return this.executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() throws InterruptedException {
        DropperQueue dropperQueue = this;
        synchronized (dropperQueue) {
            if (this.sleeping) {
                this.wait();
            }
        }
    }

    public final void die() {
        this.die(true);
    }

    public final synchronized void die(boolean mayInterruptIfRunning) {
        this.stop = true;
        this.signalChange(mayInterruptIfRunning);
    }

    public final synchronized boolean isDying() {
        return this.dieCalled() && this.isExecuting();
    }

    public final boolean isDead() {
        return this.getState().equals((Object)Thread.State.TERMINATED);
    }

    public final synchronized boolean dieCalled() {
        return this.stop;
    }

    @Override
    public void run() {
        while (!this.dieCalled()) {
            try {
                T item;
                this.await();
                this.itemsLock.lockInterruptibly();
                try {
                    while (this.items.isEmpty()) {
                        this.notEmpty.await();
                    }
                    item = this.items.removeFirst();
                }
                finally {
                    this.itemsLock.unlock();
                }
                this.setExecuting(true);
                Thread.interrupted();
                this.process(item);
            }
            catch (InterruptedException item) {
                this.setExecuting(false);
                continue;
            }
            catch (RuntimeException e) {
                try {
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setExecuting(false);
                }
            }
            this.setExecuting(false);
        }
    }

    protected abstract void process(T var1);

    public final void put(T item) {
        this.itemsLock.lock();
        try {
            this.items.add(item);
            this.notEmpty.signal();
        }
        finally {
            this.itemsLock.unlock();
        }
    }

    public final void eachItemDo(final IClosure<T> c) {
        this.itemsDo(new IClosure<Collection<T>>(){

            @Override
            public void executeChecked(Collection<T> items) {
                for (Object t : items) {
                    c.executeChecked(t);
                }
            }
        });
    }

    public final void itemsDo(IClosure<? super Deque<T>> c) {
        this.itemsLock.lock();
        try {
            c.executeChecked(this.items);
            if (!this.items.isEmpty()) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.itemsLock.unlock();
        }
    }
}

