/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.touch;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.touch.Animator;

public class AnimatorManager
implements Runnable {
    static AnimatorManager instance = new AnimatorManager();
    List<Animator> running = new ArrayList<Animator>();
    List<Animator> toRemove = new ArrayList<Animator>();

    AnimatorManager() {
        Thread t = new Thread(this);
        t.setPriority(10);
        t.setDaemon(true);
        t.start();
    }

    public static synchronized AnimatorManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Animator animator) {
        animator.setStartTime(System.currentTimeMillis());
        animator.start();
        this.running.add(animator);
        AnimatorManager animatorManager = this;
        synchronized (animatorManager) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            long currentTimeMillis = System.currentTimeMillis();
            int i = 0;
            while (i < this.running.size()) {
                Animator a = this.running.get(i);
                if (a.pulse(currentTimeMillis - a.getStartTime())) {
                    this.toRemove.add(a);
                }
                ++i;
            }
            int size = this.toRemove.size();
            if (size > 0) {
                int i2 = 0;
                while (i2 < size) {
                    Animator a = this.toRemove.get(i2);
                    this.running.remove(a);
                    ++i2;
                }
                this.toRemove.clear();
            }
            try {
                Thread.sleep(10L, 1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.running.size() != 0) continue;
            try {
                AnimatorManager e = this;
                synchronized (e) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

