/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.SearchContent;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class SearchSpec
implements Transferable {
    private String tableId;
    private List<SearchContent> content = new ArrayList<SearchContent>();

    public SearchSpec(String tableId) {
        this.tableId = tableId;
    }

    public SearchSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public final String getTableId() {
        return this.tableId;
    }

    public final List<SearchContent> getContent() {
        return this.content;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("table-id", this.tableId);
        json.put("content", JSONConverter.getJSON(this.content));
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = JSONConverter.getParameterFromJSON(json, "table-id", String.class);
        JSONArray jsonContent = JSONConverter.getParameterFromJSON(json, "content", JSONArray.class);
        if (jsonContent != null) {
            this.content = new ArrayList<SearchContent>();
            for (Object o : jsonContent) {
                this.content.add(new SearchContent(JSONConverter.getObjectFromJSON(o, JSONObject.class)));
            }
        }
    }
}

