/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.date;

import com.ibm.icu.text.RuleBasedNumberFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.JValidTime;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.component.JRadioButtons;
import org.openconcerto.ui.date.DateRange;
import org.openconcerto.ui.date.DayOfWeek;
import org.openconcerto.ui.date.EventProvider;
import org.openconcerto.ui.date.EventProviders;
import org.openconcerto.ui.date.Period;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringInputStream;
import org.openconcerto.utils.TimeUtils;
import org.openconcerto.utils.i18n.TM;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DateRangePlannerPanel
extends JPanel {
    private static final Object[] WEEK_INDEXES = new Object[]{1, 2, 3, 4, -2, -1};
    private static final long serialVersionUID = 1006612828847678846L;
    private JValidTime timeStart;
    private JValidTime timeEnd;
    private Component currentPanel;
    private JRadioButtons<Period> radioPeriod;
    private Map<Period, Component> panels;
    private JRadioButton dayRadio1;
    private JRadioButton dayRadio2;
    private JDate dateStart;
    private JDate dateEnd;
    private JSpinner duration;
    private JSpinner spinDateRangeCount;
    private JSpinner dayEveryDay;
    private JSpinner weekIncrementSpinner;
    private Set<DayOfWeek> weekDays;
    List<JCheckBox> weekCheckboxes = new ArrayList<JCheckBox>();
    private JRadioButton monthRadio1;
    private JRadioButton monthRadio2;
    private int monthIncrement = -1;
    private JSpinner spinDayOfMonth;
    private JComboBox comboWeekOfMonth;
    private JComboBox comboWeekDayOfMonth;
    private JSpinner spinMonth2;
    private JSpinner spinMonth3;
    private int yearlyMonth = -1;
    private JSpinner yearlyDayOfMonth;
    private JComboBox yearlyComboWeekOfMonth;
    private JComboBox yearlyComboWeekDayOfMonth;
    private JComboBox yearMonthCombo;
    private JComboBox yearMonthCombo2;
    private JRadioButton yearRadio1;
    private JRadioButton yearRadio2;
    private JRadioButton radioPeriodEndAt;
    private JRadioButton radioPeriodRepeat;
    private JRadioButton radioPeriodNeverEnd;
    protected boolean listenersEnabled = true;
    private DayOfWeek[] week;

    public DateRangePlannerPanel() {
        this.weekDays = new HashSet<DayOfWeek>();
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        JLabelBold timeLabel = new JLabelBold("Horaires");
        this.add((Component)timeLabel, c);
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        ++c.gridy;
        this.add(this.createTimePanel(), c);
        ++c.gridy;
        JLabelBold periodLabel = new JLabelBold("P\u00e9riodicit\u00e9");
        this.add((Component)periodLabel, c);
        ++c.gridy;
        this.add(this.createPerdiodPanel(), c);
        ++c.gridy;
        JLabel rangeLabel = new JLabel("Plage de p\u00e9riodicit\u00e9");
        this.add((Component)rangeLabel, c);
        ++c.gridy;
        c.weighty = 1.0;
        this.add(this.createRangePanel(), c);
    }

    private Component createTimePanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(0));
        p.add(new JLabel("Heure de d\u00e9but"));
        this.timeStart = new JValidTime(true);
        p.add(this.timeStart);
        p.add(new JLabel("  Fin"));
        this.timeEnd = new JValidTime(true);
        this.timeEnd.setTimeInMillis(Math.min(86399999L, this.timeStart.getTimeInMillis() + 3600000L));
        p.add(this.timeEnd);
        p.add(new JLabel("  Dur\u00e9e"));
        this.duration = new JSpinner(new SpinnerNumberModel(1, 1, 1439, 1));
        p.add(this.duration);
        p.add(new JLabel("minutes"));
        long delta = this.timeEnd.getTimeInMillis() - this.timeStart.getTimeInMillis();
        if (delta < 60000L) {
            delta = 60000L;
            this.timeStart.setTimeInMillis(this.timeEnd.getTimeInMillis() - delta);
        }
        this.duration.setValue((int)(delta / 60000L));
        this.timeStart.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DateRangePlannerPanel.this.listenersEnabled) {
                    long ms = DateRangePlannerPanel.this.timeStart.getTimeInMillis() + (long)(DateRangePlannerPanel.this.getSpinnerValue(DateRangePlannerPanel.this.duration) * 60 * 1000);
                    DateRangePlannerPanel.this.setTimeEnd(ms %= 86400000L);
                }
            }
        });
        this.timeEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DateRangePlannerPanel.this.listenersEnabled) {
                    long delta = DateRangePlannerPanel.this.timeEnd.getTimeInMillis() - DateRangePlannerPanel.this.timeStart.getTimeInMillis();
                    if (delta < 0L) {
                        delta = 60000L;
                        long ms = DateRangePlannerPanel.this.timeEnd.getTimeInMillis() - (long)(DateRangePlannerPanel.this.getSpinnerValue(DateRangePlannerPanel.this.duration) * 60 * 1000);
                        if (ms < 0L) {
                            ms += 86400000L;
                        }
                        DateRangePlannerPanel.this.setTimeStart(ms);
                    } else {
                        Integer min = (int)(delta / 60000L);
                        DateRangePlannerPanel.this.setDuration(min);
                    }
                }
            }
        });
        this.duration.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DateRangePlannerPanel.this.listenersEnabled) {
                    try {
                        int min = DateRangePlannerPanel.this.getSpinnerValue(DateRangePlannerPanel.this.duration);
                        if (min > 0) {
                            long ms = DateRangePlannerPanel.this.timeStart.getTimeInMillis() + (long)(min * 60 * 1000);
                            DateRangePlannerPanel.this.setTimeEnd(ms %= 86400000L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return p;
    }

    private Component createPerdiodPanel() {
        final JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        final DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        LinkedHashMap<Period, String> choices = new LinkedHashMap<Period, String>();
        choices.put(Period.DAY, "Quotidienne");
        choices.put(Period.WEEK, "Hebdomadaire");
        choices.put(Period.MONTH, "Mensuelle");
        choices.put(Period.YEAR, "Annuelle");
        this.radioPeriod = new JRadioButtons(false, choices);
        this.radioPeriod.setValue(Period.DAY);
        p.add(this.radioPeriod, c);
        ++c.gridx;
        c.fill = 3;
        p.add((Component)new JSeparator(1), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.panels = new HashMap<Period, Component>();
        this.panels.put(Period.DAY, this.createDayPanel());
        this.panels.put(Period.WEEK, this.createWeekPanel());
        this.panels.put(Period.MONTH, this.createMonthPanel());
        this.panels.put(Period.YEAR, this.createYearPanel());
        this.currentPanel = this.panels.get((Object)Period.DAY);
        p.add(this.currentPanel, c);
        this.currentPanel.setPreferredSize(new Dimension(this.currentPanel.getPreferredSize().width + 80, this.currentPanel.getPreferredSize().height));
        this.radioPeriod.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null) {
                    Period id = (Period)((Object)evt.getNewValue());
                    p.remove(DateRangePlannerPanel.this.currentPanel);
                    DateRangePlannerPanel.this.currentPanel = (Component)DateRangePlannerPanel.this.panels.get((Object)id);
                    p.add(DateRangePlannerPanel.this.currentPanel, c);
                    p.revalidate();
                    p.repaint();
                }
            }
        });
        return p;
    }

    private Component createRangePanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        p.add((Component)new JLabel("D\u00e9but"), c);
        c.fill = 0;
        ++c.gridx;
        this.dateStart = new JDate(true, true);
        p.add((Component)this.dateStart, c);
        ++c.gridx;
        this.radioPeriodEndAt = new JRadioButton("Fin le");
        p.add((Component)this.radioPeriodEndAt, c);
        ++c.gridx;
        this.dateEnd = new JDate(false, true);
        Calendar cal = Calendar.getInstance();
        cal.add(6, 7);
        this.dateEnd.setValue(cal.getTime());
        c.gridwidth = 2;
        p.add((Component)this.dateEnd, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 2;
        this.radioPeriodRepeat = new JRadioButton("Fin apr\u00e8s");
        p.add((Component)this.radioPeriodRepeat, c);
        ++c.gridx;
        this.spinDateRangeCount = new JSpinner(new SpinnerNumberModel(1, 1, 36500, 1));
        this.spinDateRangeCount.setEnabled(false);
        p.add((Component)this.spinDateRangeCount, c);
        ++c.gridx;
        c.weightx = 1.0;
        p.add((Component)new JLabel("occurences"), c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 2;
        this.radioPeriodNeverEnd = new JRadioButton("Pas de fin");
        p.add((Component)this.radioPeriodNeverEnd, c);
        ++c.gridx;
        ButtonGroup group = new ButtonGroup();
        group.add(this.radioPeriodEndAt);
        group.add(this.radioPeriodRepeat);
        group.add(this.radioPeriodNeverEnd);
        this.radioPeriodEndAt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
                DateRangePlannerPanel.this.dateEnd.setEnabled(!DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
            }
        });
        this.radioPeriodRepeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
                DateRangePlannerPanel.this.dateEnd.setEnabled(!DateRangePlannerPanel.this.radioPeriodRepeat.isSelected());
            }
        });
        this.radioPeriodNeverEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePlannerPanel.this.spinDateRangeCount.setEnabled(false);
                DateRangePlannerPanel.this.dateEnd.setEnabled(false);
            }
        });
        this.dateEnd.setEnabled(false);
        this.radioPeriodNeverEnd.setSelected(true);
        return p;
    }

    private Component createDayPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 0, 0, 2);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.dayRadio1 = new JRadioButton("Tous les ");
        this.dayRadio1.setSelected(true);
        this.dayEveryDay = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
        final JLabel labelEvery = new JLabel("jour");
        this.dayEveryDay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DateRangePlannerPanel.this.getSpinnerValue(DateRangePlannerPanel.this.dayEveryDay) == 1) {
                    labelEvery.setText("jour");
                } else {
                    labelEvery.setText("jours");
                }
            }
        });
        p1.add(this.dayRadio1);
        p1.add(this.dayEveryDay);
        p1.add(labelEvery);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 2, 0));
        this.dayRadio2 = new JRadioButton("Tous les jours ouvrables");
        p2.add(this.dayRadio2);
        this.dayRadio1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePlannerPanel.this.dayEveryDay.setEnabled(DateRangePlannerPanel.this.dayRadio1.isSelected());
            }
        });
        this.dayRadio2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateRangePlannerPanel.this.dayEveryDay.setEnabled(DateRangePlannerPanel.this.dayRadio1.isSelected());
            }
        });
        ButtonGroup g = new ButtonGroup();
        g.add(this.dayRadio1);
        g.add(this.dayRadio2);
        p1.setOpaque(false);
        p2.setOpaque(false);
        c.anchor = 18;
        c.weightx = 1.0;
        c.fill = 2;
        p.add((Component)p1, c);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        return p;
    }

    private Component createWeekPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        p1.add(new JLabel("Toutes les"));
        this.weekIncrementSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
        final JLabel labelEvery = new JLabel("semaine, le :");
        this.weekIncrementSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (DateRangePlannerPanel.this.getSpinnerValue(DateRangePlannerPanel.this.weekIncrementSpinner) == 1) {
                    labelEvery.setText("semaine, le :");
                } else {
                    labelEvery.setText("semaines, le :");
                }
            }
        });
        p1.add(this.weekIncrementSpinner);
        p1.add(labelEvery);
        c.gridwidth = 4;
        p.add((Component)p1, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
        this.week = DayOfWeek.getWeek(Calendar.getInstance());
        int weekLength = this.week.length;
        int midWeek = weekLength / 2;
        int i = 0;
        while (i < weekLength) {
            final DayOfWeek d = this.week[i];
            c.weightx = i == midWeek ? 1.0 : 0.0;
            final JCheckBox cb = new JCheckBox(namesOfDays[d.getCalendarField()]);
            cb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (cb.isSelected()) {
                        DateRangePlannerPanel.this.weekDays.add(d);
                    } else {
                        DateRangePlannerPanel.this.weekDays.remove((Object)d);
                        if (DateRangePlannerPanel.this.weekDays.isEmpty()) {
                            cb.setSelected(true);
                            DateRangePlannerPanel.this.weekDays.add(d);
                        }
                    }
                }
            });
            p.add((Component)cb, c);
            this.weekCheckboxes.add(cb);
            if (i == midWeek) {
                c.gridx = 0;
                ++c.gridy;
                c.weighty = 1.0;
            } else {
                ++c.gridx;
            }
            ++i;
        }
        this.weekCheckboxes.get(0).setSelected(true);
        this.weekDays.add(this.week[0]);
        return p;
    }

    protected final void setMonthIncrement(Object src) {
        this.monthIncrement = this.getSpinnerValue((JSpinner)src);
    }

    private Component createMonthPanel() {
        Calendar cal = Calendar.getInstance();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        c.weightx = 1.0;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.monthRadio1 = new JRadioButton("Le");
        this.monthRadio1.setSelected(true);
        p1.add(this.monthRadio1);
        this.spinDayOfMonth = this.createDayOfMonthSpinner(cal);
        p1.add(this.spinDayOfMonth);
        p1.add(new JLabel("tous les"));
        this.spinMonth2 = new JSpinner(new SpinnerNumberModel(1, 1, 96, 1));
        ChangeListener setMonthIncrementCL = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DateRangePlannerPanel.this.setMonthIncrement(e.getSource());
            }
        };
        this.spinMonth2.addChangeListener(setMonthIncrementCL);
        p1.add(this.spinMonth2);
        p1.add(new JLabel("mois"));
        p.add((Component)p1, c);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 4, 0));
        this.monthRadio2 = new JRadioButton("Le");
        p2.add(this.monthRadio2);
        this.comboWeekOfMonth = this.createWeekOfMonthCombo();
        p2.add(this.comboWeekOfMonth);
        this.comboWeekDayOfMonth = this.createWeekDayOfMonthCombo(cal);
        p2.add(this.comboWeekDayOfMonth);
        p2.add(new JLabel("tous les"));
        this.spinMonth3 = new JSpinner(new SpinnerNumberModel(1, 1, 96, 1));
        p2.add(this.spinMonth3);
        p2.add(new JLabel("mois"));
        this.spinMonth3.addChangeListener(setMonthIncrementCL);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.monthRadio1);
        g.add(this.monthRadio2);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = DateRangePlannerPanel.this.monthRadio1.isSelected();
                DateRangePlannerPanel.this.spinDayOfMonth.setEnabled(selected);
                DateRangePlannerPanel.this.spinMonth2.setEnabled(selected);
                DateRangePlannerPanel.this.comboWeekOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.comboWeekDayOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.spinMonth3.setEnabled(!selected);
                DateRangePlannerPanel.this.setMonthIncrement(selected ? DateRangePlannerPanel.this.spinMonth2 : DateRangePlannerPanel.this.spinMonth3);
            }
        };
        this.monthRadio1.addActionListener(listener);
        this.monthRadio2.addActionListener(listener);
        listener.actionPerformed(null);
        return p;
    }

    protected JSpinner createDayOfMonthSpinner(Calendar cal) {
        int minDayOfMonth = cal.getMinimum(5);
        int maxDayOfMonth = cal.getMaximum(5);
        return new JSpinner(new SpinnerNumberModel(minDayOfMonth, minDayOfMonth, maxDayOfMonth, 1));
    }

    protected JComboBox createWeekOfMonthCombo() {
        JComboBox<Object> res = new JComboBox<Object>(WEEK_INDEXES);
        final RuleBasedNumberFormat f = new RuleBasedNumberFormat(1);
        String rule = TM.getInstance().translate(TM.MissingMode.NULL, "day.spelloutRule", new Object[0]);
        if (rule != null) {
            f.setDefaultRuleSet(rule);
        }
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String v = DateRangePlannerPanel.getWeekOfMonthTranslation(f, ((Number)value).longValue());
                return super.getListCellRendererComponent((JList<?>)list, v, index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    private static String getWeekOfMonthTranslation(long weekIndex) {
        RuleBasedNumberFormat f = new RuleBasedNumberFormat(1);
        String rule = TM.getInstance().translate(TM.MissingMode.NULL, "day.spelloutRule", new Object[0]);
        if (rule != null) {
            f.setDefaultRuleSet(rule);
        }
        return DateRangePlannerPanel.getWeekOfMonthTranslation(f, weekIndex);
    }

    private static String getWeekOfMonthTranslation(RuleBasedNumberFormat f, long weekIndex) {
        String v = weekIndex == -2L ? TM.getInstance().translate("day.spellout.beforeLast", new Object[0]) : (weekIndex == -1L ? TM.getInstance().translate("day.spellout.last", new Object[0]) : f.format(weekIndex));
        return v;
    }

    protected JComboBox createWeekDayOfMonthCombo(Calendar cal) {
        final String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
        DayOfWeek[] week = DayOfWeek.getWeek(cal);
        JComboBox<DayOfWeek> res = new JComboBox<DayOfWeek>(week);
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, namesOfDays[((DayOfWeek)((Object)value)).getCalendarField()], index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    protected JComboBox createMonthCombo() {
        final String[] namesOfMonths = DateFormatSymbols.getInstance().getMonths();
        Object[] monthsIndex = new Object[namesOfMonths.length];
        int i = 0;
        while (i < namesOfMonths.length) {
            monthsIndex[i] = i;
            ++i;
        }
        JComboBox<Object> res = new JComboBox<Object>(monthsIndex);
        res.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, namesOfMonths[((Number)value).intValue()], index, isSelected, cellHasFocus);
            }
        });
        return res;
    }

    private Component createYearPanel() {
        Calendar cal = Calendar.getInstance();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.insets = new Insets(0, 4, 0, 4);
        c.anchor = 18;
        c.weightx = 1.0;
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0, 4, 0));
        this.yearRadio1 = new JRadioButton("Chaque");
        this.yearRadio1.setSelected(true);
        p1.add(this.yearRadio1);
        this.yearlyDayOfMonth = this.createDayOfMonthSpinner(cal);
        p1.add(this.yearlyDayOfMonth);
        this.yearMonthCombo = this.createMonthCombo();
        p1.add(this.yearMonthCombo);
        p.add((Component)p1, c);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0, 4, 0));
        this.yearRadio2 = new JRadioButton("Le");
        p2.add(this.yearRadio2);
        this.yearlyComboWeekOfMonth = this.createWeekOfMonthCombo();
        p2.add(this.yearlyComboWeekOfMonth);
        this.yearlyComboWeekDayOfMonth = this.createWeekDayOfMonthCombo(cal);
        p2.add(this.yearlyComboWeekDayOfMonth);
        p2.add(new JLabel("de"));
        this.yearMonthCombo2 = this.createMonthCombo();
        p2.add(this.yearMonthCombo2);
        ++c.gridy;
        c.weighty = 1.0;
        p.add((Component)p2, c);
        ButtonGroup g = new ButtonGroup();
        g.add(this.yearRadio1);
        g.add(this.yearRadio2);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = DateRangePlannerPanel.this.yearRadio1.isSelected();
                DateRangePlannerPanel.this.yearlyDayOfMonth.setEnabled(selected);
                DateRangePlannerPanel.this.yearMonthCombo.setEnabled(selected);
                DateRangePlannerPanel.this.yearlyComboWeekOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.yearlyComboWeekDayOfMonth.setEnabled(!selected);
                DateRangePlannerPanel.this.yearMonthCombo2.setEnabled(!selected);
                DateRangePlannerPanel.this.setYearlyMonth(selected ? DateRangePlannerPanel.this.yearMonthCombo : DateRangePlannerPanel.this.yearMonthCombo2);
            }
        };
        this.yearRadio1.addActionListener(listener);
        this.yearRadio2.addActionListener(listener);
        ItemListener monthL = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DateRangePlannerPanel.this.setYearlyMonth(e.getSource());
                }
            }
        };
        this.yearMonthCombo.addItemListener(monthL);
        this.yearMonthCombo2.addItemListener(monthL);
        listener.actionPerformed(null);
        return p;
    }

    protected final void setYearlyMonth(Object comp) {
        this.yearlyMonth = (Integer)((JComboBox)comp).getSelectedItem();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                JFrame f = new JFrame();
                JPanel p = new JPanel();
                final DateRangePlannerPanel planner = new DateRangePlannerPanel();
                p.setLayout(new BorderLayout());
                p.add((Component)planner, "Center");
                JPanel tools = new JPanel();
                p.add((Component)tools, "South");
                JButton b = new JButton("Print ranges");
                tools.add(b);
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<DateRange> ranges = planner.getRanges();
                        System.out.println("Printing " + ranges.size() + " ranges :");
                        for (DateRange dateRange : ranges) {
                            System.out.println(dateRange);
                        }
                        String configXML = planner.getConfigXML();
                        System.out.println(DateRangePlannerPanel.getDescriptionFromXML(configXML));
                    }
                });
                JButton bLoad = new JButton("Load");
                tools.add(bLoad);
                bLoad.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Loading...");
                        try {
                            String configXML = FileUtils.read(new File("test.xml"));
                            System.out.println(configXML);
                            planner.configureFromXML(configXML);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                JButton bSave = new JButton("Save");
                tools.add(bSave);
                bSave.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Saving...");
                        String configXML = planner.getConfigXML();
                        System.out.println(configXML);
                        try {
                            FileUtils.write(configXML, new File("test.xml"));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                f.setContentPane(p);
                f.pack();
                f.setDefaultCloseOperation(3);
                f.setVisible(true);
            }
        });
    }

    public List<DateRange> getRanges() {
        EventProvider prov;
        int incr;
        Calendar c;
        int eventCount;
        Date endDate;
        Period type = this.radioPeriod.getValue();
        Date startDate = this.dateStart.getValue();
        int timeStartInMS = (int)this.timeStart.getTimeInMillis();
        int timeEndInMS = (int)this.timeEnd.getTimeInMillis();
        if (this.radioPeriodEndAt.isSelected()) {
            endDate = this.dateEnd.getValue();
            if (endDate.compareTo(startDate) < 0) {
                throw new IllegalArgumentException("End before start");
            }
            eventCount = -1;
        } else if (this.radioPeriodNeverEnd.isSelected()) {
            c = Calendar.getInstance();
            c.add(1, 20);
            endDate = c.getTime();
            if (endDate.compareTo(startDate) < 0) {
                throw new IllegalArgumentException("End before start");
            }
            eventCount = -1;
        } else {
            endDate = null;
            eventCount = this.getSpinnerValue(this.spinDateRangeCount);
            if (eventCount <= 0) {
                throw new IllegalArgumentException("Negative event count : " + eventCount);
            }
        }
        c = Calendar.getInstance();
        c.setTime(startDate);
        if (type == Period.DAY) {
            if (this.dayRadio1.isSelected()) {
                incr = this.getSpinnerValue(this.dayEveryDay);
                prov = new EventProviders.Daily(incr);
            } else {
                prov = new EventProviders.Weekly(1, DayOfWeek.WORKING_DAYS);
            }
        } else if (type == Period.WEEK) {
            if (this.weekDays.isEmpty()) {
                prov = null;
            } else {
                incr = this.getSpinnerValue(this.weekIncrementSpinner);
                prov = new EventProviders.Weekly(incr, this.weekDays);
            }
        } else if (type == Period.MONTH) {
            prov = this.spinDayOfMonth.isEnabled() ? new EventProviders.Monthly(this.getSpinnerValue(this.spinDayOfMonth), this.monthIncrement) : new EventProviders.MonthlyDayOfWeek((Integer)this.comboWeekOfMonth.getSelectedItem(), (DayOfWeek)((Object)this.comboWeekDayOfMonth.getSelectedItem()), this.monthIncrement);
        } else if (type == Period.YEAR) {
            prov = this.yearlyDayOfMonth.isEnabled() ? new EventProviders.Yearly(this.getSpinnerValue(this.yearlyDayOfMonth), this.yearlyMonth, 1) : new EventProviders.YearlyDayOfWeekEventProvider((Integer)this.yearlyComboWeekOfMonth.getSelectedItem(), (DayOfWeek)((Object)this.yearlyComboWeekDayOfMonth.getSelectedItem()), this.yearlyMonth, 1);
        } else {
            throw new IllegalStateException("invalid type: " + (Object)((Object)type));
        }
        if (prov == null) {
            return new ArrayList<DateRange>(0);
        }
        prov.next(c, true);
        ArrayList<DateRange> result = new ArrayList<DateRange>();
        Calendar startStopCal = (Calendar)c.clone();
        while (this.before(c, endDate) && this.lessThan(result.size(), eventCount)) {
            DateRange r = new DateRange();
            Date currentTime = c.getTime();
            startStopCal.setTime(currentTime);
            this.setStartAndStop(r, startStopCal, timeStartInMS, timeEndInMS);
            result.add(r);
            prov.next(c, false);
            if (currentTime.compareTo(c.getTime()) < 0) continue;
            throw new IllegalStateException("Provider hasn't moved time forward");
        }
        return result;
    }

    private boolean before(Calendar c, Date endDate) {
        if (endDate == null) {
            return true;
        }
        return c.getTime().compareTo(endDate) <= 0;
    }

    private boolean lessThan(int currentEventCount, int eventCount) {
        if (eventCount < 0) {
            return true;
        }
        return currentEventCount < eventCount;
    }

    public void setStartDate(Date dateStart) {
        this.dateStart.setDate(dateStart);
    }

    protected void setStartAndStop(DateRange r, Calendar c, int timeStartInMS, int timeEndInMS) {
        int day = c.get(6);
        TimeUtils.clearTime(c);
        c.add(14, timeStartInMS);
        if (c.get(6) != day) {
            throw new IllegalArgumentException("More than a day : " + timeStartInMS);
        }
        r.setStart(c.getTimeInMillis());
        if (timeEndInMS < timeStartInMS) {
            TimeUtils.clearTime(c);
            c.add(6, 1);
            c.add(14, timeEndInMS);
            assert (c.get(6) == day + 1);
        } else {
            c.add(14, timeEndInMS - timeStartInMS);
            if (c.get(6) != day) {
                throw new IllegalArgumentException("More than a day : " + timeEndInMS);
            }
        }
        r.setStop(c.getTimeInMillis());
    }

    public String getConfigXML() {
        StringBuilder b = new StringBuilder();
        b.append("<planner>");
        b.append("<schedule start=\"");
        b.append(this.timeStart.getTimeInMillis());
        b.append("\" end=\"");
        b.append(this.timeEnd.getTimeInMillis());
        b.append("\" />");
        Period p = this.radioPeriod.getValue();
        int f = p.getCalendarField();
        b.append("<period type=\"");
        b.append(f);
        b.append("\">");
        if (f == Period.DAY.getCalendarField()) {
            b.append("<day every=\"");
            if (this.dayRadio1.isSelected()) {
                b.append(this.getSpinnerValue(this.dayEveryDay));
            } else {
                b.append("wd");
            }
            b.append("\" />");
        } else if (f == Period.WEEK.getCalendarField()) {
            b.append("<week every=\"");
            b.append(this.getSpinnerValue(this.weekIncrementSpinner));
            b.append("\">");
            for (JCheckBox cb : this.weekCheckboxes) {
                if (cb.isSelected()) {
                    b.append("<true/>");
                    continue;
                }
                b.append("<false/>");
            }
            b.append("</week>");
        } else if (f == Period.MONTH.getCalendarField()) {
            if (this.monthRadio1.isSelected()) {
                b.append("<month day=\"");
                b.append(this.getSpinnerValue(this.spinDayOfMonth));
                b.append("\" every=\"");
                b.append(this.getSpinnerValue(this.spinMonth2));
                b.append("\" />");
            } else {
                b.append("<month weekOfMonth=\"");
                b.append(this.comboWeekOfMonth.getSelectedIndex());
                b.append("\" dayOfMonth=\"");
                b.append(this.comboWeekDayOfMonth.getSelectedIndex());
                b.append("\" every=\"");
                b.append(this.getSpinnerValue(this.spinMonth3));
                b.append("\" />");
            }
        } else if (f == Period.YEAR.getCalendarField()) {
            if (this.yearRadio1.isSelected()) {
                b.append("<year day=\"");
                b.append(this.getSpinnerValue(this.yearlyDayOfMonth));
                b.append("\" month=\"");
                b.append(this.yearMonthCombo.getSelectedIndex());
                b.append("\" />");
            } else {
                b.append("<year weekOfMonth=\"");
                b.append(this.yearlyComboWeekOfMonth.getSelectedIndex());
                b.append("\" weekDayOfMonth=\"");
                b.append(this.yearlyComboWeekDayOfMonth.getSelectedIndex());
                b.append("\" month=\"");
                b.append(this.yearMonthCombo2.getSelectedIndex());
                b.append("\" />");
            }
        } else {
            throw new IllegalStateException("Unknown period:" + f);
        }
        b.append("</period>");
        b.append("<range start=\"");
        b.append(this.dateStart.getValue().getTime());
        b.append("\" ");
        if (this.radioPeriodEndAt.isSelected()) {
            b.append("end=\"");
            b.append(this.dateEnd.getValue().getTime());
            b.append("\"");
        } else if (this.radioPeriodRepeat.isSelected()) {
            b.append("repeat=\"");
            b.append(this.getSpinnerValue(this.spinDateRangeCount));
            b.append("\"");
        }
        b.append("/>");
        b.append("</planner>");
        return b.toString();
    }

    public void configureFromXML(String xml) throws Exception {
        Integer weekOfMonth;
        Integer d;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.parse(new StringInputStream(xml, "UTF8"));
        NodeList l1 = dom.getElementsByTagName("schedule");
        Node nSchedule = l1.item(0);
        long tStart = DateRangePlannerPanel.getAttributeAsLong(nSchedule, "start");
        long tStop = DateRangePlannerPanel.getAttributeAsLong(nSchedule, "end");
        this.listenersEnabled = false;
        this.timeStart.setTimeInMillis(tStart);
        this.timeEnd.setTimeInMillis(tStop);
        this.duration.setValue((tStop - tStart) / 60000L);
        this.listenersEnabled = true;
        NodeList l2 = dom.getElementsByTagName("period");
        Node nPeriod = l2.item(0);
        int perioType = Integer.parseInt(nPeriod.getAttributes().getNamedItem("type").getTextContent());
        if (perioType == Period.DAY.getCalendarField()) {
            this.radioPeriod.setValue(Period.DAY);
            Node nDay = nPeriod.getFirstChild();
            Integer l = DateRangePlannerPanel.getAttributeAsInteger(nDay, "every");
            if (l != null) {
                this.dayRadio1.setSelected(true);
                this.dayEveryDay.setValue(l);
                this.dayEveryDay.setEnabled(true);
            } else {
                this.dayRadio2.setSelected(true);
                this.dayEveryDay.setEnabled(false);
            }
        } else if (perioType == Period.WEEK.getCalendarField()) {
            this.radioPeriod.setValue(Period.WEEK);
            Node nWeek = nPeriod.getFirstChild();
            Integer e = DateRangePlannerPanel.getAttributeAsInteger(nWeek, "every");
            this.weekIncrementSpinner.setValue(e);
            NodeList l = nWeek.getChildNodes();
            this.weekDays.clear();
            int i = 0;
            while (i < l.getLength()) {
                Node n = l.item(i);
                boolean selected = n.getNodeName().equals("true");
                this.weekCheckboxes.get(i).setSelected(selected);
                if (selected) {
                    this.weekDays.add(this.week[i]);
                }
                ++i;
            }
        } else if (perioType == Period.MONTH.getCalendarField()) {
            this.radioPeriod.setValue(Period.MONTH);
            Node nMonth = nPeriod.getFirstChild();
            d = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "day");
            if (d != null) {
                this.monthRadio1.setSelected(true);
                Integer every = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "every");
                this.spinDayOfMonth.setEnabled(true);
                this.spinMonth2.setEnabled(true);
                this.comboWeekOfMonth.setEnabled(false);
                this.comboWeekDayOfMonth.setEnabled(false);
                this.spinMonth3.setEnabled(false);
                this.spinDayOfMonth.setValue(d);
                this.spinMonth2.setValue(every);
            } else {
                this.monthRadio2.setSelected(true);
                this.spinDayOfMonth.setEnabled(false);
                this.spinMonth2.setEnabled(false);
                this.comboWeekOfMonth.setEnabled(true);
                this.comboWeekDayOfMonth.setEnabled(true);
                this.spinMonth3.setEnabled(true);
                weekOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "weekOfMonth");
                Integer dayOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "dayOfMonth");
                Integer every = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "every");
                this.comboWeekOfMonth.setSelectedIndex(weekOfMonth);
                this.comboWeekDayOfMonth.setSelectedIndex(dayOfMonth);
                this.spinMonth3.setValue(every);
            }
        } else if (perioType == Period.YEAR.getCalendarField()) {
            this.radioPeriod.setValue(Period.YEAR);
            Node nYear = nPeriod.getFirstChild();
            d = DateRangePlannerPanel.getAttributeAsInteger(nYear, "day");
            if (d != null) {
                this.yearRadio1.setSelected(true);
                Integer m = DateRangePlannerPanel.getAttributeAsInteger(nYear, "month");
                this.yearlyDayOfMonth.setEnabled(true);
                this.yearMonthCombo.setEnabled(true);
                this.yearlyComboWeekOfMonth.setEnabled(false);
                this.yearlyComboWeekDayOfMonth.setEnabled(false);
                this.yearMonthCombo2.setEnabled(false);
                this.yearlyDayOfMonth.setValue(d);
                this.yearMonthCombo.setSelectedIndex(m);
            } else {
                this.yearRadio2.setSelected(true);
                this.yearlyDayOfMonth.setEnabled(false);
                this.yearMonthCombo.setEnabled(false);
                this.yearlyComboWeekOfMonth.setEnabled(true);
                this.yearlyComboWeekDayOfMonth.setEnabled(true);
                this.yearMonthCombo2.setEnabled(true);
                weekOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nYear, "weekOfMonth");
                this.yearlyComboWeekOfMonth.setSelectedIndex(weekOfMonth);
                Integer weekDayOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nYear, "weekDayOfMonth");
                this.yearlyComboWeekDayOfMonth.setSelectedIndex(weekDayOfMonth);
                Integer m = DateRangePlannerPanel.getAttributeAsInteger(nYear, "month");
                this.yearMonthCombo2.setSelectedIndex(m);
            }
        } else {
            throw new IllegalStateException("Unknown period:" + perioType);
        }
        NodeList l3 = dom.getElementsByTagName("range");
        Node nRange = l3.item(0);
        Long start = DateRangePlannerPanel.getAttributeAsLong(nRange, "start");
        Long end = DateRangePlannerPanel.getAttributeAsLong(nRange, "end");
        Integer repeat = DateRangePlannerPanel.getAttributeAsInteger(nRange, "repeat");
        this.dateStart.setValue(new Date(start));
        if (end != null) {
            this.radioPeriodEndAt.setSelected(true);
            this.dateEnd.setEnabled(true);
            this.spinDateRangeCount.setEnabled(false);
            this.dateEnd.setValue(new Date(end));
        } else if (repeat != null) {
            this.radioPeriodRepeat.setSelected(true);
            this.dateEnd.setEnabled(false);
            this.spinDateRangeCount.setEnabled(true);
            this.spinDateRangeCount.setValue(repeat);
        } else {
            this.dateEnd.setEnabled(false);
            this.spinDateRangeCount.setEnabled(false);
            this.radioPeriodNeverEnd.setSelected(true);
        }
    }

    public static String getDescriptionFromXML(String xml) {
        String result = "";
        try {
            Integer d;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new StringInputStream(xml, "UTF8"));
            NodeList l1 = dom.getElementsByTagName("schedule");
            Node nSchedule = l1.item(0);
            long tStart = DateRangePlannerPanel.getAttributeAsLong(nSchedule, "start");
            long tStop = DateRangePlannerPanel.getAttributeAsLong(nSchedule, "end");
            result = String.valueOf(result) + "De " + DateRangePlannerPanel.formatTime(tStart) + " \u00e0 " + DateRangePlannerPanel.formatTime(tStop) + " ";
            NodeList l2 = dom.getElementsByTagName("period");
            Node nPeriod = l2.item(0);
            int perioType = Integer.parseInt(nPeriod.getAttributes().getNamedItem("type").getTextContent());
            if (perioType == Period.DAY.getCalendarField()) {
                Node nDay = nPeriod.getFirstChild();
                Integer l = DateRangePlannerPanel.getAttributeAsInteger(nDay, "every");
                result = l != null ? (l == 1 ? String.valueOf(result) + "tous les jours" : String.valueOf(result) + "tous les " + l + " jours") : String.valueOf(result) + "tous les jours ouvrables";
            } else if (perioType == Period.WEEK.getCalendarField()) {
                Node nWeek = nPeriod.getFirstChild();
                Integer e = DateRangePlannerPanel.getAttributeAsInteger(nWeek, "every");
                result = e == 1 ? String.valueOf(result) + "toutes les semaines, le " : String.valueOf(result) + "toutes les " + e + " semaines, le ";
                NodeList l = nWeek.getChildNodes();
                String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
                DayOfWeek[] week = DayOfWeek.getWeek(Calendar.getInstance());
                int i = 0;
                while (i < l.getLength()) {
                    Node n = l.item(i);
                    if (n.getNodeName().equals("true")) {
                        result = String.valueOf(result) + namesOfDays[week[i].getCalendarField()] + " ";
                    }
                    ++i;
                }
            } else if (perioType == Period.MONTH.getCalendarField()) {
                Node nMonth = nPeriod.getFirstChild();
                d = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "day");
                if (d != null) {
                    result = String.valueOf(result) + "le " + d;
                    int every = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "every");
                    result = every == 1 ? String.valueOf(result) + " tous les mois" : String.valueOf(result) + " tous les " + every + " mois";
                } else {
                    Integer weekOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "weekOfMonth");
                    Integer dayOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "dayOfMonth");
                    int every = DateRangePlannerPanel.getAttributeAsInteger(nMonth, "every");
                    Integer index = (Integer)WEEK_INDEXES[weekOfMonth];
                    result = String.valueOf(result) + "le " + DateRangePlannerPanel.getWeekOfMonthTranslation(index.intValue());
                    String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
                    DayOfWeek[] week = DayOfWeek.getWeek(Calendar.getInstance());
                    result = String.valueOf(result) + " " + namesOfDays[week[dayOfMonth].getCalendarField()];
                    result = every == 1 ? String.valueOf(result) + " tous les mois" : String.valueOf(result) + " tous les " + every + " mois";
                }
            } else if (perioType == Period.YEAR.getCalendarField()) {
                Node nYear = nPeriod.getFirstChild();
                d = DateRangePlannerPanel.getAttributeAsInteger(nYear, "day");
                if (d != null) {
                    result = String.valueOf(result) + "chaque " + d;
                    String[] namesOfMonths = DateFormatSymbols.getInstance().getMonths();
                    Integer m = DateRangePlannerPanel.getAttributeAsInteger(nYear, "month");
                    result = String.valueOf(result) + " " + namesOfMonths[m];
                } else {
                    Integer weekOfMonth = DateRangePlannerPanel.getAttributeAsInteger(nYear, "weekOfMonth");
                    result = String.valueOf(result) + "le ";
                    Integer index = (Integer)WEEK_INDEXES[weekOfMonth];
                    result = String.valueOf(result) + DateRangePlannerPanel.getWeekOfMonthTranslation(index.intValue());
                    String[] namesOfDays = DateFormatSymbols.getInstance().getWeekdays();
                    DayOfWeek[] week = DayOfWeek.getWeek(Calendar.getInstance());
                    int i = DateRangePlannerPanel.getAttributeAsInteger(nYear, "weekDayOfMonth");
                    result = String.valueOf(result) + " " + namesOfDays[week[i].getCalendarField()];
                    String[] namesOfMonths = DateFormatSymbols.getInstance().getMonths();
                    Integer m = DateRangePlannerPanel.getAttributeAsInteger(nYear, "month");
                    result = String.valueOf(result) + " de " + namesOfMonths[m];
                }
            } else {
                throw new IllegalStateException("Unknown period:" + perioType);
            }
            result = String.valueOf(result) + ", ";
            NodeList l3 = dom.getElementsByTagName("range");
            Node nRange = l3.item(0);
            Long start = DateRangePlannerPanel.getAttributeAsLong(nRange, "start");
            Long end = DateRangePlannerPanel.getAttributeAsLong(nRange, "end");
            Integer repeat = DateRangePlannerPanel.getAttributeAsInteger(nRange, "repeat");
            DateFormat df = DateFormat.getDateInstance(0);
            result = String.valueOf(result) + "\u00e0 partir du " + df.format(new Date(start));
            result = end != null ? String.valueOf(result) + " jusqu'au " + df.format(new Date(end)) + "." : (repeat != null ? String.valueOf(result) + " " + repeat + " fois." : String.valueOf(result) + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String formatTime(long time) {
        String m;
        long minutes = time / 60000L;
        String h = String.valueOf((int)(minutes / 60L));
        if (h.length() < 2) {
            h = "0" + h;
        }
        if ((m = String.valueOf((int)(minutes % 60L))).length() < 2) {
            m = "0" + m;
        }
        return String.valueOf(h) + ":" + m;
    }

    private static Long getAttributeAsLong(Node item, String attrName) {
        Node n = item.getAttributes().getNamedItem(attrName);
        if (n == null) {
            return null;
        }
        try {
            long l = Long.parseLong(n.getTextContent());
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Integer getAttributeAsInteger(Node item, String attrName) {
        Node n = item.getAttributes().getNamedItem(attrName);
        if (n == null) {
            return null;
        }
        try {
            int l = Integer.parseInt(n.getTextContent());
            return l;
        }
        catch (Exception e) {
            return null;
        }
    }

    public JDate getJDateStart() {
        return this.dateStart;
    }

    public JDate getJDateEnd() {
        return this.dateEnd;
    }

    public void setTimeEnd(long ms) {
        this.listenersEnabled = false;
        if (this.timeEnd.getTimeInMillis() != ms) {
            this.timeEnd.setTimeInMillis(ms);
        }
        this.listenersEnabled = true;
    }

    public void setTimeStart(long ms) {
        this.listenersEnabled = false;
        if (this.timeStart.getTimeInMillis() != ms) {
            this.timeStart.setTimeInMillis(ms);
        }
        this.listenersEnabled = true;
    }

    public void setDuration(Integer min) {
        this.listenersEnabled = false;
        if (this.getSpinnerValue(this.duration) != min.intValue()) {
            this.duration.setValue(min);
        }
        this.listenersEnabled = true;
    }

    public int getSpinnerValue(JSpinner s) {
        Object o = s.getValue();
        if (o == null) {
            return 0;
        }
        return ((Number)o).intValue();
    }
}

