/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.io.Serializable;
import javax.swing.SpinnerNumberModel;

public class SpinnerCyclicModel
extends SpinnerNumberModel
implements Serializable {
    private long stepSize;
    private long value;
    private long minimum;
    private long maximum;

    public SpinnerCyclicModel(long value, long minimum, long maximum, long stepSize) {
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    public Comparable getMinimum() {
        return Long.valueOf(this.minimum);
    }

    public void setMaximum(long maximum) {
        this.maximum = maximum;
        this.fireStateChanged();
    }

    public Comparable getMaximum() {
        return Long.valueOf(this.maximum);
    }

    public void setStepSize(long stepSize) {
        if (stepSize != this.stepSize) {
            this.stepSize = stepSize;
            this.fireStateChanged();
        }
    }

    @Override
    public Number getStepSize() {
        return this.stepSize;
    }

    private Number incrValue(int dir) {
        long v = this.value + this.stepSize * (long)dir;
        if (v > this.maximum) {
            v = this.minimum;
        }
        if (v < this.minimum) {
            v = this.maximum;
        }
        return v;
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !(value instanceof Number)) {
            throw new IllegalArgumentException("illegal value");
        }
        if (((Number)value).longValue() != this.value) {
            this.value = ((Number)value).longValue();
            this.fireStateChanged();
        }
    }
}

