/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;

public class PositiveIntegerTableCellEditor
extends DefaultCellEditor {
    private final boolean strict;

    public PositiveIntegerTableCellEditor() {
        super(new JTextField());
        this.strict = false;
    }

    public PositiveIntegerTableCellEditor(boolean strict) {
        super(new JTextField());
        this.strict = strict;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getCellEditorValue();
            return super.stopCellEditing();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Object getCellEditorValue() {
        String str = (String)super.getCellEditorValue();
        if (str == null || str.length() == 0) {
            if (this.strict) {
                return 1;
            }
            return 0;
        }
        try {
            int i = Integer.parseInt(str);
            if (i < 0) {
                i = this.strict ? 1 : 0;
            }
            return i;
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }
}

