/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.UserTableCellRenderer;
import org.openconcerto.task.JComponentTableCellRenderer;
import org.openconcerto.task.ModelStateListener;
import org.openconcerto.task.TM;
import org.openconcerto.task.TacheActionManager;
import org.openconcerto.task.TodoListElement;
import org.openconcerto.task.TodoListElementEditorPanel;
import org.openconcerto.task.TodoListModel;
import org.openconcerto.task.UserTaskRight;
import org.openconcerto.task.ui.UserComboBox;
import org.openconcerto.task.ui.UserTableCellEditor;
import org.openconcerto.ui.JMultiLineToolTip;
import org.openconcerto.ui.LightEventJTable;
import org.openconcerto.ui.ReloadPanel;
import org.openconcerto.ui.TitledSeparator;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.IconTableCellRenderer;
import org.openconcerto.ui.table.JCheckBoxTableCellRender;
import org.openconcerto.ui.table.TablePopupMouseListener;
import org.openconcerto.ui.table.TimestampTableCellEditor;
import org.openconcerto.ui.table.TimestampTableCellRenderer;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.cc.ITransformer;

public class TodoListPanel
extends JPanel
implements ModelStateListener {
    private final UserManager uMngr;
    private final JCheckBox detailCheckBox;
    private final JCheckBox hideOldCheckBox;
    private JMenu comboUser;
    private final JButton addButton;
    private final JButton removeButton;
    private final LightEventJTable t;
    private final TodoListModel model;
    private final TimestampTableCellRenderer timestampTableCellRendererCreated;
    private final TimestampTableCellRenderer timestampTableCellRendererDone;
    private final TimestampTableCellRenderer timestampTableCellRendererDeadLine;
    private final IconTableCellRenderer iconEditor;
    private final IconTableCellRenderer iconRenderer;
    private final UserTableCellRenderer userTableCellRenderer;
    private final JCheckBoxTableCellRender a = new JCheckBoxTableCellRender();
    private final ImageIcon iconTache;
    private final ImageIcon iconPriorite;
    private TimestampTableCellEditor timestampTableCellEditorDeadLine;
    private TimestampTableCellEditor timestampTableCellEditorCreated;
    private TimestampTableCellEditor timestampTableCellEditorDone;
    private final Vector<User> users = new Vector();
    final ReloadPanel reloadPanel = new ReloadPanel();
    TableSorter sorter;

    public TodoListPanel(final UserManager uMngr) {
        this.uMngr = uMngr;
        this.setOpaque(false);
        this.iconTache = new ImageIcon(TodoListPanel.class.getResource("tache.png"));
        this.iconPriorite = new ImageIcon(TodoListPanel.class.getResource("priorite.png"));
        this.userTableCellRenderer = new UserTableCellRenderer(uMngr);
        this.timestampTableCellRendererCreated = new TimestampTableCellRenderer();
        this.timestampTableCellRendererDone = new TimestampTableCellRenderer();
        this.timestampTableCellRendererDeadLine = new TimestampTableCellRenderer(true);
        this.timestampTableCellEditorCreated = new TimestampTableCellEditor();
        this.timestampTableCellEditorDone = new TimestampTableCellEditor();
        this.timestampTableCellEditorDeadLine = new TimestampTableCellEditor();
        Vector<URL> l = new Vector<URL>();
        l.add(TodoListPanel.class.getResource("empty.png"));
        l.add(TodoListPanel.class.getResource("high.png"));
        l.add(TodoListPanel.class.getResource("normal.png"));
        l.add(TodoListPanel.class.getResource("low.png"));
        this.iconEditor = new IconTableCellRenderer(l);
        this.iconRenderer = new IconTableCellRenderer(l);
        User currentUser = uMngr.getCurrentUser();
        this.model = new TodoListModel(uMngr);
        this.sorter = new TableSorter(this.model);
        this.t = new LightEventJTable(this.sorter){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }

            @Override
            public String getToolTipText(MouseEvent event) {
                String r = null;
                TodoListElement task = TodoListPanel.this.getTaskAt(event.getPoint());
                if (task != null && task.getCreatorId() > 1) {
                    String comment = task.getComment();
                    if (comment != null) {
                        r = comment;
                        r = String.valueOf(r) + "\n\n";
                    } else {
                        r = "";
                    }
                    r = String.valueOf(r) + TM.getTM().trM("assignedBy", "user", uMngr.getUser(task.getCreatorId()).getFullName(), "date", task.getDate());
                }
                return r;
            }
        };
        this.sorter.setTableHeader(this.t.getTableHeader());
        this.model.setTable(this.t);
        this.comboUser = new JMenu(TM.tr("showTaskAssignedTo", new Object[0]));
        this.initViewableUsers(currentUser);
        this.model.addIdListenerSilently(currentUser.getId());
        int size = this.users.size();
        int i = 0;
        while (i < size) {
            Integer id = this.users.get(i).getId();
            if (this.model.listenToId(id)) {
                ((JCheckBoxMenuItem)this.comboUser.getMenuComponent(i)).setState(true);
            } else {
                ((JCheckBoxMenuItem)this.comboUser.getMenuComponent(i)).setState(false);
            }
            ++i;
        }
        this.addButton = new JButton(TM.tr("addTask", new Object[0]));
        this.removeButton = new JButton();
        this.removeButton.setOpaque(false);
        this.updateDeleteBtn();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 1, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 6;
        TitledSeparator sep = new TitledSeparator(String.valueOf(currentUser.getFirstName()) + " " + currentUser.getName().toUpperCase());
        this.add((Component)sep, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)this.addButton, c);
        ++c.gridx;
        this.add((Component)this.removeButton, c);
        c.anchor = 13;
        ++c.gridx;
        JMenuBar b = new JMenuBar();
        b.setOpaque(false);
        b.setBorderPainted(false);
        b.add(this.comboUser);
        b.setMinimumSize(b.getPreferredSize());
        this.add((Component)b, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.detailCheckBox = new JCheckBox(TM.tr("showDetails", new Object[0]));
        this.detailCheckBox.setOpaque(false);
        this.detailCheckBox.setSelected(false);
        this.add((Component)this.detailCheckBox, c);
        ++c.gridx;
        this.hideOldCheckBox = new JCheckBox(TM.tr("hideHistory", new Object[0]));
        this.hideOldCheckBox.setOpaque(false);
        this.hideOldCheckBox.setSelected(true);
        this.add((Component)this.hideOldCheckBox, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.anchor = 13;
        this.reloadPanel.setOpaque(false);
        this.add((Component)this.reloadPanel, c);
        c.gridwidth = 6;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        this.initPopUp();
        this.initTable(2);
        this.add((Component)new JScrollPane(this.t), c);
        this.initListeners();
        this.model.asynchronousFill();
    }

    public final UserManager getUserManager() {
        return this.uMngr;
    }

    private void initViewableUsers(final User currentUser) {
        SwingWorker<List<User>, Object> worker = new SwingWorker<List<User>, Object>(){

            @Override
            protected List<User> doInBackground() throws Exception {
                ArrayList<Integer> canViewUsers = new ArrayList<Integer>();
                for (UserTaskRight right : UserTaskRight.getUserTaskRight(currentUser)) {
                    if (!right.canRead()) continue;
                    canViewUsers.add(right.getIdToUser());
                }
                SQLTable userT = TodoListPanel.this.getUserManager().getTable();
                SQLSelect select1 = new SQLSelect(false);
                select1.addSelectStar(userT);
                Where meWhere = new Where((FieldRef)userT.getKey(), "=", currentUser.getId());
                Where canViewWhere = new Where(userT.getKey(), canViewUsers);
                select1.setWhere(meWhere.or(canViewWhere));
                ArrayList<User> result = new ArrayList<User>();
                for (SQLRow r : SQLRowListRSH.execute(select1)) {
                    result.add(new User(r));
                }
                return result;
            }

            @Override
            protected void done() {
                try {
                    List tuples = (List)this.get();
                    for (User user : tuples) {
                        String displayName = user.getNickName();
                        if (displayName.length() == 0) {
                            displayName = String.valueOf(user.getFirstName()) + " " + user.getName().toUpperCase();
                        }
                        final JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(displayName);
                        TodoListPanel.this.comboUser.add(checkBoxMenuItem);
                        final int uId = user.getId();
                        TodoListPanel.this.users.add(user);
                        checkBoxMenuItem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                if (checkBoxMenuItem.isSelected()) {
                                    TodoListPanel.this.addUserListenerId(uId);
                                } else {
                                    TodoListPanel.this.removeUserListenerId(uId);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Unable to get tasks users", e);
                }
            }
        };
        worker.execute();
    }

    private void initListeners() {
        this.t.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TodoListPanel.this.updateDeleteBtn();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TodoListPanel.this.removeSelectedTask();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TodoListPanel.this.addTask();
            }
        });
        this.detailCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TodoListPanel.this.detailCheckBoxClicked();
            }
        });
        this.hideOldCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TodoListPanel.this.model.setHistoryVisible(e.getStateChange() == 2);
                TodoListPanel.this.model.asynchronousFill();
            }
        });
        this.model.addModelStateListener(this);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                TodoListPanel.this.model.removeModelStateListener(TodoListPanel.this);
                TodoListPanel.this.model.stopUpdate();
            }
        });
    }

    protected void removeSelectedTask() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TodoListPanel.this.t.editingCanceled(null);
                int index = TodoListPanel.this.t.getSelectedRow();
                while (index >= 0) {
                    if (!TodoListPanel.this.model.deleteTaskAtIndex(TodoListPanel.this.sorter.modelIndex(index))) break;
                    index = TodoListPanel.this.t.getSelectedRow();
                }
                TodoListPanel.this.model.asynchronousFill();
            }
        });
    }

    protected void detailCheckBoxClicked() {
        if (this.detailCheckBox.isSelected()) {
            this.initTable(1);
        } else {
            this.initTable(2);
        }
    }

    private void initTable(int mode) {
        this.t.setBlockRepaint(true);
        this.t.setBlockEventOnColumn(true);
        this.model.setMode(mode);
        this.t.getColumnModel().getColumn(0).setCellRenderer(this.a);
        this.t.getColumnModel().getColumn(0).setCellEditor(this.a);
        this.t.setBlockEventOnColumn(true);
        this.setIconForColumn(0, this.iconTache);
        this.setIconForColumn(1, this.iconPriorite);
        this.t.setBlockEventOnColumn(true);
        this.t.getColumnModel().getColumn(1).setCellEditor(this.iconEditor);
        final JTextField textField = new JTextField(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(TodoListPanel.this.t.getGridColor());
                g.fillRect(this.getWidth() - 19, 0, 1, this.getHeight());
                g.setColor(new Color(250, 250, 250));
                g.fillRect(this.getWidth() - 18, 0, 18, this.getHeight());
                g.setColor(Color.BLACK);
                int i = 0;
                while (i < 3) {
                    int x = this.getWidth() - 14 + i * 4;
                    int y = this.getHeight() - 5;
                    g.fillRect(x, y, 1, 2);
                    ++i;
                }
            }
        };
        textField.setBorder(BorderFactory.createEmptyBorder());
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(textField);
        textField.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getX() > textField.getWidth() - 19) {
                    TodoListElement l = TodoListPanel.this.getTaskAt(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TodoListPanel.this.t));
                    TodoListPanel.this.t.editingCanceled(new ChangeEvent(this));
                    JFrame f = new JFrame(TM.tr("details", new Object[0]));
                    f.setContentPane(new TodoListElementEditorPanel(l));
                    f.setDefaultCloseOperation(2);
                    f.setSize(500, 200);
                    f.setLocation(50, e.getYOnScreen() + TodoListPanel.this.t.getRowHeight());
                    f.setVisible(true);
                }
            }
        });
        this.t.getColumnModel().getColumn(2).setCellEditor(defaultCellEditor);
        this.t.getColumnModel().getColumn(3).setMaxWidth(300);
        this.t.getColumnModel().getColumn(3).setMinWidth(100);
        this.timestampTableCellEditorCreated.stopCellEditing();
        this.timestampTableCellEditorDone.stopCellEditing();
        this.timestampTableCellEditorDeadLine.stopCellEditing();
        if (this.model.getMode() == 1) {
            this.t.getColumnModel().getColumn(3).setCellRenderer(this.timestampTableCellRendererCreated);
            this.t.getColumnModel().getColumn(3).setCellEditor(this.timestampTableCellEditorCreated);
            this.t.getColumnModel().getColumn(4).setCellRenderer(this.timestampTableCellRendererDone);
            this.t.getColumnModel().getColumn(4).setCellEditor(this.timestampTableCellEditorDone);
            this.t.getColumnModel().getColumn(5).setCellRenderer(this.timestampTableCellRendererDeadLine);
            this.t.getColumnModel().getColumn(5).setCellEditor(this.timestampTableCellEditorDeadLine);
        } else {
            this.t.getColumnModel().getColumn(3).setCellRenderer(this.timestampTableCellRendererDeadLine);
            this.t.getColumnModel().getColumn(3).setCellEditor(this.timestampTableCellEditorDeadLine);
        }
        TableColumn userColumn = this.t.getColumnModel().getColumn(this.t.getColumnModel().getColumnCount() - 1);
        userColumn.setCellRenderer(this.userTableCellRenderer);
        userColumn.setMaxWidth(150);
        userColumn.setMinWidth(100);
        this.t.setEnabled(false);
        this.initUserCellEditor(userColumn);
        this.t.setBlockEventOnColumn(false);
        this.t.setBlockRepaint(false);
        this.t.getColumnModel().getColumn(1).setCellRenderer(this.iconRenderer);
        this.t.setShowHorizontalLines(false);
        this.t.setGridColor(new Color(230, 230, 230));
        this.t.setRowHeight(new JTextField((String)" ").getPreferredSize().height + 4);
        AlternateTableCellRenderer.UTILS.setAllColumns(this.t);
        this.t.repaint();
    }

    private void initUserCellEditor(final TableColumn userColumn) {
        new SwingWorker<List<UserTaskRight>, Object>(){

            @Override
            protected List<UserTaskRight> doInBackground() throws Exception {
                return UserTaskRight.getUserTaskRight(TodoListPanel.this.getUserManager().getCurrentUser());
            }

            @Override
            protected void done() {
                try {
                    List rights = (List)this.get();
                    ArrayList<User> canAddUsers = new ArrayList<User>();
                    for (UserTaskRight right : rights) {
                        if (!$assertionsDisabled && right.getIdUser() != TodoListPanel.this.getUserManager().getCurrentUser().getId()) {
                            throw new AssertionError();
                        }
                        if (!right.canAdd()) continue;
                        canAddUsers.add(TodoListPanel.this.getUserManager().getUser(right.getIdToUser()));
                    }
                    userColumn.setCellEditor(new UserTableCellEditor(TodoListPanel.this.getUserManager(), new UserComboBox(canAddUsers)));
                    TodoListPanel.this.t.setEnabled(true);
                }
                catch (Exception e) {
                    ExceptionHandler.handle("Unable to get user task rights", e);
                }
                super.done();
            }
        }.execute();
    }

    void initPopUp() {
        TablePopupMouseListener.add(this.t, new ITransformer<MouseEvent, JPopupMenu>(){

            @Override
            public JPopupMenu transformChecked(MouseEvent evt) {
                final JTable table = (JTable)evt.getSource();
                final int modelIndex = TodoListPanel.this.sorter.modelIndex(table.getSelectedRow());
                JPopupMenu res = new JPopupMenu();
                AbstractAction act = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        final TodoListElement element = TodoListPanel.this.model.getTaskAtRow(modelIndex);
                        if (element != null) {
                            final Date ts = element.getExpectedDate();
                            final Calendar cal = Calendar.getInstance();
                            cal.setTimeInMillis(ts.getTime());
                            cal.add(6, 1);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ts.setTime(cal.getTimeInMillis());
                                    element.setExpectedDate(ts);
                                    element.commitChangesAndWait();
                                    table.repaint();
                                }
                            });
                        }
                    }
                };
                act.putValue("Name", TM.tr("moveOneDay", new Object[0]));
                res.add(act);
                act = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoListElement element = TodoListPanel.this.model.getTaskAtRow(modelIndex);
                        if (element != null) {
                            element.setDone(true);
                            element.commitChangesAndWait();
                            table.repaint();
                        }
                    }
                };
                act.putValue("Name", TM.tr("markDone", new Object[0]));
                res.add(act);
                act = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TodoListPanel.this.model.deleteTaskAtIndex(modelIndex);
                        table.repaint();
                    }
                };
                act.putValue("Name", TM.tr("delete", new Object[0]));
                res.add(act);
                TodoListElement element = TodoListPanel.this.model.getTaskAtRow(modelIndex);
                SQLRowValues rowTache = element.getRowValues();
                List<AbstractAction> actions = TacheActionManager.getInstance().getActionsForTaskRow(rowTache);
                for (AbstractAction abstractAction : actions) {
                    res.add(abstractAction);
                }
                return res;
            }
        });
    }

    private void setIconForColumn(int i, ImageIcon icon) {
        JComponentTableCellRenderer renderer = new JComponentTableCellRenderer(icon);
        TableColumnModel columnModel = this.t.getColumnModel();
        TableColumn column = columnModel.getColumn(i);
        column.setHeaderRenderer(renderer);
        column.setMaxWidth(icon.getIconWidth() + 16);
        column.setMinWidth(icon.getIconWidth() + 8);
    }

    private void addTask() {
        this.model.addNewTask();
    }

    public void addUserListenerId(int id) {
        int i = 0;
        while (i < this.users.size()) {
            Integer idUser = this.users.get(i).getId();
            if (idUser == id) {
                ((JCheckBoxMenuItem)this.comboUser.getMenuComponent(i)).setState(true);
            }
            ++i;
        }
        this.model.addIdListener(id);
    }

    private void removeUserListenerId(int id) {
        this.t.editingCanceled(new ChangeEvent(this));
        this.model.removeIdListener(id);
    }

    public void stopUpdate() {
        this.model.stopUpdate();
    }

    @Override
    public void stateChanged(int state) {
        if (state == 0) {
            this.reloadPanel.setMode(2);
        }
        if (state == 2) {
            this.reloadPanel.setMode(1);
        }
        if (state == 1) {
            this.reloadPanel.setMode(0);
        }
    }

    public void addModelStateListener(ModelStateListener l) {
        this.model.addModelStateListener(l);
    }

    private TodoListElement getTaskAt(Point p) {
        int row = this.t.rowAtPoint(p);
        TodoListElement task = this.model.getTaskAtRow(this.sorter.modelIndex(row));
        return task;
    }

    protected void updateDeleteBtn() {
        int nbRows = this.t.getSelectedRows().length;
        this.removeButton.setEnabled(nbRows > 0);
        this.removeButton.setText(TM.getTM().trM("deleteSelectedTasks", "count", nbRows));
    }
}

