/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.task;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;

public class TodoListElement {
    private final UserManager uMngr;
    private SQLRowValues rowVals;
    Executor executor = Executors.newSingleThreadExecutor();

    public TodoListElement(UserManager uMngr, SQLRowValues rowVals) {
        this.uMngr = uMngr;
        this.rowVals = rowVals;
    }

    public void reloadValues(final SQLRowAccessor row) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TodoListElement.this.rowVals.load(row, null);
            }
        });
    }

    public Date getDate() {
        Calendar date = this.rowVals.getDate("DATE_ENTREE");
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public void setDate(Date date) {
        this.rowVals.put("DATE_ENTREE", date);
    }

    public Boolean isDone() {
        return this.rowVals.getBoolean("FAIT");
    }

    public void setDone(Boolean done) {
        this.rowVals.put("FAIT", done);
        this.setDoneDate(new Date());
    }

    public Date getDoneDate() {
        Calendar date = this.rowVals.getDate("DATE_FAIT");
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public void setDoneDate(Date doneDate) {
        this.rowVals.put("DATE_FAIT", doneDate);
    }

    public Date getExpectedDate() {
        Calendar date = this.rowVals.getDate("DATE_EXP");
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public void setExpectedDate(Date expectedDate) {
        this.rowVals.put("DATE_EXP", expectedDate);
    }

    public String getName() {
        return this.rowVals.getString("NOM");
    }

    public void setName(String name) {
        this.rowVals.put("NOM", name);
    }

    public Integer getPriority() {
        return this.rowVals.getInt("PRIORITE");
    }

    public void setPriority(Integer priority) {
        this.rowVals.put("PRIORITE", priority);
    }

    public Integer getUserId() {
        return this.rowVals.getInt("ID_USER_COMMON_TO");
    }

    public User getUser() {
        return this.uMngr.getUser(this.getUserId());
    }

    public Integer getCreatorId() {
        return this.rowVals.getInt("ID_USER_COMMON_ASSIGN_BY");
    }

    public void setUserId(Integer id) {
        this.rowVals.put("ID_USER_COMMON_TO", id);
    }

    public void commitChanges() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                TodoListElement.this.commitChangesAndWait();
            }
        });
    }

    public void commitChangesAndWait() {
        try {
            SQLRow row = this.rowVals.commit();
            this.rowVals.put(this.rowVals.getTable().getKey().getName(), row.getID());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void archive() {
        this.rowVals.put("ARCHIVE", (Object)1);
        try {
            this.rowVals.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "T\u00e2che:" + this.rowVals.getString("NOM") + "(id:" + this.rowVals.getID() + ") to " + this.getUserId();
    }

    public SQLRowValues getRowValues() {
        return this.rowVals;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TodoListElement) {
            TodoListElement element = (TodoListElement)obj;
            return this.rowVals.equals(element.getRowValues());
        }
        return super.equals(obj);
    }

    public String getComment() {
        return this.rowVals.getString("COMMENT");
    }

    public void setComment(String text) {
        this.rowVals.put("COMMENT", text);
    }
}

