/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.listview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.view.listview.ItemPool;
import org.openconcerto.sql.view.listview.ItemPoolFactory;
import org.openconcerto.sql.view.listview.ListItemSQLView;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.checks.EmptyChangeSupport;
import org.openconcerto.utils.checks.EmptyListener;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidObject;
import org.openconcerto.utils.checks.ValidState;

public class ListSQLView
extends JPanel
implements SQLRowItemView {
    private final SQLComponent parent;
    private final String name;
    private final ItemPool pool;
    private final List<ListItemSQLView> items;
    private final PropertyChangeSupport supp;
    private final EmptyChangeSupport helper;
    private final JButton addBtn;
    private final JPanel itemsPanel;
    private final GridBagConstraints itemsConstraints;

    public ListSQLView(SQLComponent parent, String name, ItemPoolFactory factory) {
        this.parent = parent;
        this.name = name;
        this.pool = factory.create(this);
        this.supp = new PropertyChangeSupport(this);
        this.items = new ArrayList<ListItemSQLView>();
        this.addValidListener(new ValidListener(){

            @Override
            public void validChange(ValidObject src, ValidState newValue) {
            }
        });
        this.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListSQLView.this.addBtn.setEnabled(ListSQLView.this.getPool().availableItem());
            }
        });
        this.helper = new EmptyChangeSupport(this);
        this.addBtn = new JButton("Ajout");
        this.itemsPanel = new JPanel(new GridBagLayout());
        this.itemsConstraints = new GridBagConstraints();
        this.uiInit();
    }

    protected void uiInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 2, 1, 2);
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.add((Component)this.itemsPanel, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.fill = 0;
        c.anchor = 12;
        this.add((Component)this.addBtn, c);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSQLView.this.addNewItem();
            }
        });
        this.itemsConstraints.gridx = 0;
        this.itemsConstraints.gridy = 0;
        this.itemsConstraints.weightx = 1.0;
        this.itemsConstraints.fill = 1;
    }

    protected final ItemPool getPool() {
        return this.pool;
    }

    protected final ListItemSQLView addNewItem() {
        ListItemSQLView newItem = new ListItemSQLView(this, this.getPool().getNewItem());
        this.items.add(newItem);
        newItem.getRowItemView().addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListSQLView.this.supp.firePropertyChange("value", null, null);
            }
        });
        this.readd(newItem);
        return newItem;
    }

    private final void readd(ListItemSQLView newItem) {
        this.itemsPanel.add((Component)newItem, this.itemsConstraints);
        ++this.itemsConstraints.gridy;
        this.supp.firePropertyChange("value", null, null);
        this.helper.fireEmptyChange(this.isEmpty());
    }

    protected final void removeItem(ListItemSQLView viewToRemove) {
        if (!this.items.contains(viewToRemove)) {
            throw new IllegalArgumentException("not mine " + viewToRemove);
        }
        viewToRemove.setVisible(false);
        this.revalidate();
        this.getPool().removeItem(viewToRemove.getRowItemView());
        this.supp.firePropertyChange("value", null, null);
        this.helper.fireEmptyChange(this.isEmpty());
    }

    public final SQLComponent getSQLParent() {
        return this.parent;
    }

    @Override
    public void show(SQLRowAccessor r) {
        this.itemsPanel.removeAll();
        this.itemsPanel.revalidate();
        this.itemsConstraints.gridy = 0;
        this.items.clear();
        this.getPool().show(r);
    }

    @Override
    public void update(SQLRowValues vals) {
        this.getPool().update(vals);
    }

    @Override
    public void insert(SQLRowValues vals) {
        this.getPool().insert(vals);
    }

    @Override
    public void setEditable(final InteractionMode mode) {
        this.addBtn.setEnabled(mode.isEditable());
        this.forAllDo(new Cl(){

            @Override
            public void execute(ListItemSQLView input) {
                input.setEditable(mode);
            }
        });
    }

    private final void forAllDo(Cl c) {
        CollectionUtils.forAllDo(this.items, c);
    }

    public List<ListItemSQLView> getExistantViews() {
        return this.items;
    }

    @Override
    public String getSQLName() {
        return this.name;
    }

    public String getDescription() {
        return this.getSQLName();
    }

    @Override
    public SQLField getField() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<SQLField> getFields() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetValue() {
        this.getPool().reset();
    }

    @Override
    public Component getComp() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getPool().getItems().isEmpty();
    }

    @Override
    public void addEmptyListener(EmptyListener l) {
        this.helper.addEmptyListener(l);
    }

    @Override
    public void removeEmptyListener(EmptyListener l) {
        this.helper.removeEmptyListener(l);
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(l);
    }

    @Override
    public void removeValueListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    @Override
    public ValidState getValidState() {
        return this.getPool().isValidated();
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.getPool().addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.getPool().removeValidListener(l);
    }

    private static abstract class Cl
    implements Closure {
        private Cl() {
        }

        public abstract void execute(ListItemSQLView var1);

        @Override
        public final void execute(Object input) {
            this.execute((ListItemSQLView)input);
        }
    }
}

