/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.list.search;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumns;
import org.openconcerto.sql.view.list.search.SearchQueue;
import org.openconcerto.sql.view.list.search.SearchRunnable;
import org.openconcerto.utils.Tuple2;

public final class SearchAll
extends SearchRunnable {
    public SearchAll(SearchQueue q) {
        super(q);
    }

    @Override
    public void run() {
        final Tuple2<List<ListSQLLine>, SQLTableModelColumns> fullListCopy = this.getAccess().getUpdateQ().copyFullList();
        final List<ListSQLLine> newList = this.filter(fullListCopy.get0());
        if (newList != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SearchAll.this.getAccess().setList(newList, (SQLTableModelColumns)fullListCopy.get1());
                }
            });
        }
    }

    private List<ListSQLLine> filter(List<ListSQLLine> tmp) {
        List<ListSQLLine> res;
        if (tmp == null) {
            throw new NullPointerException();
        }
        if (!this.isFiltered()) {
            res = tmp;
        } else {
            int fullSize = tmp.size();
            ArrayList<ListSQLLine> l = new ArrayList<ListSQLLine>(fullSize);
            for (ListSQLLine line : tmp) {
                if (Thread.interrupted()) {
                    return null;
                }
                if (!this.matchFilterUnsafe(line)) continue;
                l.add(line);
            }
            if (fullSize - l.size() > 15000) {
                l.trimToSize();
            }
            res = l;
        }
        return res;
    }
}

