/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLData;
import org.openconcerto.sql.model.SQLDataListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.request.SQLCache;
import org.openconcerto.sql.request.SQLCacheWatcher;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.users.UserSingleton;
import org.openconcerto.sql.users.UserSingletonManager;
import org.openconcerto.sql.users.rights.LockAdminUserRight;
import org.openconcerto.sql.users.rights.MacroRight;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRights;
import org.openconcerto.utils.CollectionMap2Itf;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.IFutureTask;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.RTInterruptedException;
import org.openconcerto.utils.ThreadFactory;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;
import org.openconcerto.utils.cache.CacheItem;
import org.openconcerto.utils.cache.CacheResult;
import org.openconcerto.utils.cache.CacheWatcher;
import org.openconcerto.utils.cache.CacheWatcherFactory;
import org.openconcerto.utils.cache.ICache;
import org.openconcerto.utils.cache.ICacheSupport;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.cc.ITransformer;

public class UserRightsManager
implements UserSingleton {
    public static final String USER_RIGHT_TABLE = "USER_RIGHT";
    private static final UserSingletonManager<UserRightsManager> sMngr = new UserSingletonManager<UserRightsManager>("USER_RIGHT"){

        @Override
        protected UserRightsManager createInstance(SQLTable t) {
            return new UserRightsManager(t, null);
        }
    };
    public static final String SUPERUSER_FIELD = "SUPERUSER";
    private static final int ADMIN_ID = -1;
    public static final String ADMIN_FIELD = "ADMIN";
    private static final ListMap<String, Tuple2<String, Boolean>> SUPERUSER_RIGHTS = ListMap.singleton(null, Tuple2.create(null, true));
    private static final ListMap<String, Tuple2<String, Boolean>> NO_RIGHTS = ListMap.singleton(null, Tuple2.create(null, false));
    public static final List<MacroRight> DEFAULT_MACRO_RIGHTS = Collections.synchronizedList(new ArrayList());
    private final Map<String, MacroRight> macroRights;
    private final Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> rights;
    private final SQLCache<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> cache;
    private final SQLTable table;
    private final Link toUserLink;
    private final JavaRights javaRights;
    private final Map<Integer, UserRights> userRights;
    private final ExecutorService exec;

    static {
        DEFAULT_MACRO_RIGHTS.add(new LockAdminUserRight());
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(true));
        DEFAULT_MACRO_RIGHTS.add(new TableAllRights(false));
    }

    public static UserSingletonManager<UserRightsManager> getSingletonManager() {
        return sMngr;
    }

    public static UserRightsManager setInstanceFromRoot(DBRoot root) {
        return UserRightsManager.getSingletonManager().setInstanceFromRoot(root);
    }

    public static UserRightsManager setInstance(SQLTable t) {
        return UserRightsManager.getSingletonManager().setInstance(t);
    }

    public static UserRightsManager getInstance() {
        return UserRightsManager.getSingletonManager().getInstance();
    }

    public static final UserRights getCurrentUserRights() {
        UserManager mngr = UserManager.getInstance();
        UserRightsManager rightsMngr = UserRightsManager.getInstance();
        if (rightsMngr == null) {
            return UserRights.ALLOW_ALL;
        }
        return rightsMngr.getUserRights(mngr.getCurrentUser() == null ? null : Integer.valueOf(mngr.getCurrentUser().getId()));
    }

    private UserRightsManager(SQLTable t) {
        if (t == null) {
            throw new NullPointerException("Missing table");
        }
        this.macroRights = Collections.synchronizedMap(new HashMap());
        this.rights = new HashMap<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>>();
        this.cache = new SQLCache<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>>(900, -1, "Cache of rights"){

            @Override
            protected ICacheSupport<SQLData> createSupp(String name) {
                ICacheSupport<SQLData> res = new ICacheSupport<SQLData>(name);
                res.setWatcherFactory(new CacheWatcherFactory<SQLData>(){

                    @Override
                    public CacheWatcher<SQLData> createWatcher(SQLData o) {
                        if (o instanceof JavaRightsUser) {
                            return new JavaRightsWatcher((JavaRightsUser)o);
                        }
                        return new SQLCacheWatcher(o);
                    }
                });
                return res;
            }
        };
        this.javaRights = new JavaRights();
        this.table = t;
        this.toUserLink = t.getFieldGroups().get("ID_USER_COMMON").getKey().getForeignLink();
        this.defaultRegister();
        this.userRights = new HashMap<Integer, UserRights>();
        this.exec = Executors.newSingleThreadExecutor(new ThreadFactory(String.valueOf(this.getClass().getSimpleName()) + " executor for " + t.getSQLName(), true).setPriority(1));
        this.cache.addItemListener(new IClosure<ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, SQLData>>(){

            @Override
            public void executeChecked(ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, SQLData> evt) {
                UserRightsManager.this.cacheChanged(evt);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheChanged(ICache.ItemEvent<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>, ?> evt) {
        if (evt.getPropertyName().equals("itemAdded")) {
            Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
            synchronized (map) {
                this.rights.put((Integer)((CacheItem)evt.getNewValue()).getKey(), (CollectionMap2Itf.ListMapItf)((CacheItem)evt.getNewValue()).getValue());
            }
        }
        if (evt.getPropertyName().equals("itemRemoved")) {
            final Integer userID = (Integer)((CacheItem)evt.getOldValue()).getKey();
            CacheItem.RemovalType removalType = ((CacheItem)evt.getOldValue()).getRemovalType();
            if (removalType == CacheItem.RemovalType.DATA_CHANGE || removalType == CacheItem.RemovalType.TIMEOUT) {
                this.invokeLater(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        UserRightsManager.this.getRightsForUser(userID, false);
                        return null;
                    }
                });
            } else {
                assert (removalType != CacheItem.RemovalType.SIZE_LIMIT);
                Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
                synchronized (map) {
                    this.rights.remove(userID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void defaultRegister() {
        List<MacroRight> list = DEFAULT_MACRO_RIGHTS;
        synchronized (list) {
            for (MacroRight macroRight : DEFAULT_MACRO_RIGHTS) {
                this.register(macroRight);
            }
        }
    }

    public void register(MacroRight userRight) {
        if (userRight == null) {
            throw new IllegalArgumentException("Missing right");
        }
        this.macroRights.put(userRight.getCode(), userRight);
    }

    public void addRight(Integer userID, RightTuple right) {
        this.javaRights.changeRight(true, this.getKey(userID), right);
    }

    public void addRightForAdmins(RightTuple right) {
        this.javaRights.changeRight(true, -1, right);
    }

    private final int getKey(Integer userID) {
        if (userID != null && userID < 0) {
            throw new IllegalArgumentException("invalid ID : " + userID);
        }
        return userID == null ? this.getDefaultUserId() : userID.intValue();
    }

    public void removeRight(Integer userID, RightTuple right) {
        this.javaRights.changeRight(false, this.getKey(userID), right);
    }

    public void removeRightForAdmins(RightTuple right) {
        this.javaRights.changeRight(false, -1, right);
    }

    public final synchronized boolean isValid() {
        return !this.cache.getSupp().isDying();
    }

    @Override
    public final synchronized void destroy() {
        if (this.isValid()) {
            this.cache.getSupp().die();
            this.exec.shutdown();
        }
        assert (!this.isValid());
    }

    @Override
    public final SQLTable getTable() {
        return this.table;
    }

    public final DBRoot getRoot() {
        return this.getTable().getDBRoot();
    }

    private final SQLTable getUserTable() {
        return (SQLTable)this.toUserLink.getTarget();
    }

    public final synchronized <T> Future<T> invokeLater(Callable<T> c) {
        if (!this.isValid()) {
            return null;
        }
        return this.exec.submit(c);
    }

    public final boolean waitForCurrentRefresh() throws InterruptedException {
        Future f;
        block3: {
            try {
                f = this.invokeLater(IFutureTask.getNoOpCallable());
                if (f != null) break block3;
                return false;
            }
            catch (ExecutionException e) {
                throw new IllegalStateException("No-op failed", e);
            }
        }
        f.get();
        return true;
    }

    public final synchronized UserRights getUserRights(Integer userID) {
        UserRights res;
        if (userID == null) {
            userID = this.getDefaultUserId();
        }
        if ((res = this.userRights.get(userID)) == null) {
            res = new UserRights(this, userID);
            this.userRights.put(userID, res);
        }
        return res;
    }

    public final boolean haveRight(int userID, String code) {
        return this.haveRight(userID, code, null);
    }

    public final boolean haveRight(int userID, String code, String object) {
        return this.haveRight(userID, code, object, CompareUtils.OBJECT_EQ);
    }

    public final boolean haveRight(int userID, String code, String requestedObject, CompareUtils.Equalizer<? super String> objectMatcher) {
        Boolean defaultRight;
        HashSet<String> unicity = new HashSet<String>();
        Boolean userRight = this.haveRightP(userID, code, requestedObject, objectMatcher, unicity);
        if (userRight != null) {
            return userRight;
        }
        int defaultUser = this.getDefaultUserId();
        if (defaultUser != userID && (defaultRight = this.haveRightP(defaultUser, code, requestedObject, objectMatcher, unicity)) != null) {
            return defaultRight;
        }
        return false;
    }

    private final Boolean haveRightP(int userID, String code, String object, CompareUtils.Equalizer<? super String> objectMatcher, Set<String> unicity) {
        CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> rightsForUser = this.getRightsForUser(userID);
        if (rightsForUser == SUPERUSER_RIGHTS) {
            return true;
        }
        if (rightsForUser == NO_RIGHTS) {
            return false;
        }
        if (rightsForUser.containsKey(code)) {
            for (Tuple2 t : (List)rightsForUser.getNonNull(code)) {
                if (!unicity.add((String)t.get0())) continue;
                if (t.get0() == null || object != null && this.safeEquals(objectMatcher, t, object)) {
                    return (Boolean)t.get1();
                }
                if (object != null || ((Boolean)t.get1()).booleanValue()) continue;
                return false;
            }
        }
        return null;
    }

    private boolean safeEquals(CompareUtils.Equalizer<? super String> objectMatcher, Tuple2<String, Boolean> t, String requestedObject) {
        String rightObject = t.get0();
        try {
            return objectMatcher.equals(rightObject, requestedObject);
        }
        catch (Exception e) {
            boolean res = t.get1() == false;
            String desc = !res ? "Row ignored." : "Right denied.";
            Log.get().warning("Couldn't compare " + rightObject + " and " + requestedObject + ". " + desc);
            e.printStackTrace();
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Set<Integer> getNonBlockingUsers() {
        Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
        synchronized (map) {
            return Collections.unmodifiableSet(new HashSet<Integer>(this.rights.keySet()));
        }
    }

    private CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> getRightsForUser(int userID) {
        return this.getRightsForUser(userID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> getRightsForUser(int userID, boolean checkMap) {
        CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> res;
        if (checkMap) {
            Map<Integer, CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>>> map = this.rights;
            synchronized (map) {
                if (this.rights.containsKey(userID)) {
                    return this.rights.get(userID);
                }
            }
        }
        HashSet<SQLData> data = new HashSet<SQLData>();
        data.add(new SQLRow(this.getUserTable(), userID));
        data.add(this.getTable());
        data.add(new JavaRightsUser(this.javaRights, userID));
        data.add(new JavaRightsUser(this.javaRights, -1));
        data.add(new JavaRightsUser(this.javaRights, this.getDefaultUserId()));
        CacheResult cached = this.cache.check(userID, data);
        if (cached.getState() == CacheResult.State.INTERRUPTED) {
            throw new RTInterruptedException("interrupted while waiting for the cache");
        }
        if (cached.getState() == CacheResult.State.VALID) {
            return (CollectionMap2Itf.ListMapItf)cached.getRes();
        }
        try {
            res = this.loadRightsForUser(userID);
            this.cache.put(cached, res);
        }
        catch (RuntimeException exn) {
            this.cache.removeRunning((Integer)((Object)cached));
            throw exn;
        }
        assert (res != null);
        return res;
    }

    private final CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> loadRightsForUser(final int userID) {
        CollectionMap2Itf.ListMapItf<Integer, RightTuple> javaRights = this.javaRights.getTuples();
        try {
            int defaultUser;
            SQLRow userRow = new SQLRow(this.getUserTable(), userID).fetchValues(false);
            if (userRow != null && userRow.getBoolean(SUPERUSER_FIELD).booleanValue()) {
                return SUPERUSER_RIGHTS;
            }
            ListMap<String, Tuple2<String, Boolean>> res = new ListMap<String, Tuple2<String, Boolean>>();
            HashSet<Tuple2<String, String>> unicity = new HashSet<Tuple2<String, String>>();
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_MODIF_RIGHTS", this.getTable().getForeignTable("ID_RIGHT"), false));
            boolean isAdmin = userRow != null && userRow.getBoolean(ADMIN_FIELD) != false;
            this.expand(res, unicity, TableAllRights.createRight("TABLE_ALL_RIGHTS", this.getTable(), isAdmin));
            for (RightTuple t : (List)javaRights.getNonNull(userID)) {
                this.expand(res, unicity, t);
            }
            if (isAdmin) {
                for (RightTuple t : (List)javaRights.getNonNull(-1)) {
                    this.expand(res, unicity, t);
                }
            }
            if ((defaultUser = this.getDefaultUserId()) != userID) {
                for (RightTuple t : (List)javaRights.getNonNull(defaultUser)) {
                    this.expand(res, unicity, t);
                }
            }
            SQLRowValues vals = new SQLRowValues(this.getTable()).setAllToNull();
            vals.putRowValues("ID_RIGHT").setAllToNull();
            SQLRowValuesListFetcher sel = new SQLRowValuesListFetcher(vals);
            sel.setOrdered(true);
            sel.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect sel) {
                    sel.setWhere(new Where((FieldRef)UserRightsManager.this.toUserLink.getLabel(), "=", userID));
                    return sel;
                }
            });
            List<SQLRowValues> list = sel.fetch();
            for (SQLRowValues row : list) {
                SQLRowAccessor right = row.getForeign("ID_RIGHT");
                if (row.isUndefined()) {
                    Log.get().warning(row.asRow() + " has undef right");
                    continue;
                }
                String rightCode = right.getString("CODE");
                if (rightCode == null) {
                    Log.get().warning(right + " has null CODE");
                    continue;
                }
                String object = row.getString("OBJECT");
                Boolean haveRight = row.getBoolean("HAVE_RIGHT");
                this.expand(res, unicity, rightCode, object, haveRight);
            }
            return ListMap.unmodifiableMap(res);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Erreur lors du chargement des droits utilisateurs pour l'utilisateur (Id:" + userID + ")", e);
            return NO_RIGHTS;
        }
    }

    private final void expand(ListMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, RightTuple t) {
        this.expand(res, unicity, (String)t.get0(), (String)t.get1(), (Boolean)t.get2());
    }

    private final void expand(ListMap<String, Tuple2<String, Boolean>> res, Set<Tuple2<String, String>> unicity, String rightCode, String object, Boolean haveRight) {
        if (haveRight == null) {
            throw new IllegalStateException("HAVE_RIGHT cannot be null");
        }
        MacroRight macroRight = this.macroRights.get(rightCode);
        if (macroRight != null) {
            for (RightTuple t : macroRight.expand(this, rightCode, object, haveRight)) {
                this.expand(res, unicity, t);
            }
        } else if (unicity.add(Tuple2.create(rightCode, object))) {
            res.add(rightCode, Tuple2.create(object, haveRight));
        }
    }

    public final Set<String> getObjects(int userID, String code, IFactory<Set<String>> allObjects) {
        Set<String> defaultRight;
        if (this.haveRight(userID, code)) {
            return null;
        }
        HashSet<String> unicity = new HashSet<String>();
        Set<String> userRight = this.getObjectsP(userID, code, unicity);
        if (userRight != null && (defaultRight = this.getObjectsP(this.getDefaultUserId(), code, unicity)) != null) {
            userRight.addAll(defaultRight);
            return userRight;
        }
        HashSet<String> res = new HashSet<String>();
        for (String object : allObjects.createChecked()) {
            if (!this.haveRight(userID, code, object)) continue;
            res.add(object);
        }
        return res;
    }

    final int getDefaultUserId() {
        return this.getUserTable().getUndefinedID();
    }

    public void preloadRightsForUserId(int userID) {
        this.getRightsForUser(this.getDefaultUserId());
        this.getRightsForUser(userID);
    }

    public void clearRights() {
        this.cache.clear();
    }

    private final Set<String> getObjectsP(int userID, String code, Set<String> unicity) {
        CollectionMap2Itf.ListMapItf<String, Tuple2<String, Boolean>> rightsForUser = this.getRightsForUser(userID);
        if (rightsForUser == NO_RIGHTS) {
            return null;
        }
        HashSet<String> res = new HashSet<String>();
        if (rightsForUser.containsKey(code)) {
            for (Tuple2 t : (List)rightsForUser.getNonNull(code)) {
                if (!unicity.add((String)t.get0())) continue;
                if (t.get0() == null) {
                    return null;
                }
                if (!((Boolean)t.get1()).booleanValue()) continue;
                res.add((String)t.get0());
            }
        }
        return res;
    }

    public final Set<String> getObjects(int userID, String code, Set<String> objectsToTest, CompareUtils.Equalizer<? super String> objectMatcher) {
        if (this.haveRight(userID, code, null, objectMatcher)) {
            return objectsToTest;
        }
        HashSet<String> res = new HashSet<String>();
        for (String object : objectsToTest) {
            if (!this.haveRight(userID, code, object, objectMatcher)) continue;
            res.add(object);
        }
        return res;
    }

    /* synthetic */ UserRightsManager(SQLTable sQLTable, UserRightsManager userRightsManager) {
        this(sQLTable);
    }

    private static final class JavaRights {
        static final String TUPLES_CHANGED = "tuples";
        static final String TUPLE_CHANGED = "tuple";
        private CollectionMap2Itf.ListMapItf<Integer, RightTuple> tuples;
        private final PropertyChangeSupport propSupp = new PropertyChangeSupport(this);

        public JavaRights() {
            this.tuples = ListMap.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void changeRight(boolean add, Integer userID, RightTuple right) {
            CollectionMap2Itf.ListMapItf newVal;
            CollectionMap2Itf.ListMapItf<Integer, RightTuple> oldVal;
            if (add && right == null) {
                throw new NullPointerException("Null right entry");
            }
            JavaRights javaRights = this;
            synchronized (javaRights) {
                oldVal = this.tuples;
                ListMap<Integer, RightTuple> newMap = new ListMap<Integer, RightTuple>((Map<Integer, Collection<RightTuple>>)this.tuples);
                if (add) {
                    newMap.add(userID, right);
                } else if (right == null) {
                    newMap.remove(userID);
                } else {
                    newMap.removeAllInstancesOfItem(userID, right);
                }
                newVal = ListMap.unmodifiableMap(newMap);
                this.tuples = newVal;
            }
            this.propSupp.firePropertyChange(TUPLES_CHANGED, oldVal, newVal);
            this.propSupp.firePropertyChange(TUPLE_CHANGED, null, userID);
        }

        final synchronized CollectionMap2Itf.ListMapItf<Integer, RightTuple> getTuples() {
            return this.tuples;
        }
    }

    private static class JavaRightsUser
    implements SQLData {
        private final JavaRights rights;
        private final int id;

        public JavaRightsUser(JavaRights rights, int id) {
            this.rights = rights;
            this.id = id;
        }

        @Override
        public SQLTableModifiedListener createTableListener(SQLDataListener l) {
            return null;
        }

        @Override
        public SQLTable getTable() {
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            result = 31 * result + this.rights.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JavaRightsUser other = (JavaRightsUser)obj;
            return this.id == other.id && this.rights.equals(other.rights);
        }
    }

    private static class JavaRightsWatcher
    extends CacheWatcher<SQLData> {
        private final int id;
        private final PropertyChangeListener l;

        public JavaRightsWatcher(JavaRightsUser u) {
            super(u);
            this.id = u.id;
            this.l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (((Number)evt.getNewValue()).intValue() == JavaRightsWatcher.this.id) {
                        JavaRightsWatcher.this.dataChanged(evt);
                    }
                }
            };
        }

        @Override
        protected void startWatching() {
            ((JavaRightsUser)this.getData()).rights.propSupp.addPropertyChangeListener("tuple", this.l);
        }

        @Override
        protected void stopWatching() {
            ((JavaRightsUser)this.getData()).rights.propSupp.removePropertyChangeListener("tuple", this.l);
        }
    }

    public static final class RightTuple
    extends Tuple3<String, String, Boolean> {
        public RightTuple(String code, boolean haveRight) {
            this(code, null, haveRight);
        }

        public RightTuple(String code, String object, boolean haveRight) {
            super(code, object, haveRight);
        }
    }
}

