/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.sqlobject.itemview.RowItemViewComponent;
import org.openconcerto.sql.ui.textmenu.TextFieldCustomMenu;
import org.openconcerto.sql.ui.textmenu.TextFieldWithMenuItemsFetcher;
import org.openconcerto.sql.view.IListButton;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.text.TextComponent;
import org.openconcerto.ui.valuewrapper.ValueChangeSupport;
import org.openconcerto.ui.valuewrapper.ValueWrapper;
import org.openconcerto.utils.checks.ValidListener;
import org.openconcerto.utils.checks.ValidState;
import org.openconcerto.utils.doc.Documented;
import org.openconcerto.utils.text.SimpleDocumentListener;

public class TextFieldWithMenu
extends JPanel
implements RowItemViewComponent,
TextComponent,
ValueWrapper<String>,
Documented {
    private JTextField textField;
    private SQLField field;
    private final ValueChangeSupport<String> supp = new ValueChangeSupport<String>(this);
    protected boolean gained;
    protected boolean mousePressed;
    protected String initialText;
    private TextFieldCustomMenu menu;

    public TextFieldWithMenu(TextFieldWithMenuItemsFetcher itemsFetcher, boolean textCompEditable) {
        this.textField = new JTextField(20);
        this.textField.setEditable(textCompEditable);
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        if (System.getProperties().getProperty("os.name").toLowerCase().contains("linux")) {
            this.textField.setOpaque(false);
        }
        this.setOpaque(false);
        this.add((Component)this.textField, c);
        c.insets = new Insets(0, 4, 0, 4);
        ++c.gridx;
        c.weightx = 0.0;
        this.menu = new TextFieldCustomMenu(this.textField, itemsFetcher);
        final ImageIcon icon = new ImageIcon(IListButton.class.getResource("liste.png"));
        JMenuBar b = new JMenuBar(){

            @Override
            public void paint(Graphics g) {
                icon.paintIcon(this, g, 0, (this.getHeight() - icon.getIconHeight()) / 2);
            }
        };
        b.setOpaque(false);
        b.add(this.menu);
        b.setMinimumSize(b.getPreferredSize());
        this.add((Component)b, c);
        this.textField.getDocument().addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                TextFieldWithMenu.this.supp.fireValidChange();
            }
        });
        this.setPreferredSize(new Dimension(this.getPreferredSize()));
    }

    public void addAction(AbstractAction a) {
        this.menu.addAction(a);
    }

    @Override
    public void init(SQLRowItemView v) {
        this.field = v.getField();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldWithMenu.this.gained = true;
                TextFieldWithMenu.this.initialText = TextFieldWithMenu.this.textField.getText();
                if (!TextFieldWithMenu.this.mousePressed) {
                    TextFieldWithMenu.this.textField.selectAll();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TextFieldWithMenu.this.mousePressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TextFieldWithMenu.this.gained && TextFieldWithMenu.this.textField.getSelectedText() == null) {
                    TextFieldWithMenu.this.textField.selectAll();
                }
                TextFieldWithMenu.this.gained = false;
                TextFieldWithMenu.this.mousePressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\u001b') {
                    TextFieldWithMenu.this.setValue(TextFieldWithMenu.this.initialText);
                    TextFieldWithMenu.this.textField.selectAll();
                }
            }
        });
    }

    public SQLField getField() {
        return this.field;
    }

    @Override
    public void setValue(String val) {
        if (!this.textField.getText().equals(val)) {
            this.textField.setText(val);
        }
    }

    @Override
    public void resetValue() {
        this.setValue("");
    }

    public SQLTable getTable() {
        if (this.field == null) {
            return null;
        }
        return this.field.getTable();
    }

    @Override
    public String toString() {
        return "TextFieldWithMenu on " + this.field;
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public String getValue() throws IllegalStateException {
        return this.textField.getText();
    }

    @Override
    public void addValueListener(PropertyChangeListener l) {
        this.supp.addValueListener(l);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    public String getText() {
        return this.textField.getText();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void setSelectedRow(SQLRow selectedRow) {
        this.menu.setSelectedRow(selectedRow);
    }

    @Override
    public String getDocId() {
        return "TFWM_" + this.field.getFullName();
    }

    @Override
    public String getGenericDoc() {
        return "";
    }

    @Override
    public boolean onScreen() {
        return true;
    }

    @Override
    public boolean isDocTransversable() {
        return false;
    }

    @Override
    public JTextComponent getTextComp() {
        return this.textField;
    }

    @Override
    public JComponent getComp() {
        return this;
    }

    @Override
    public void addValidListener(ValidListener l) {
        this.supp.addValidListener(l);
    }

    @Override
    public void removeValidListener(ValidListener l) {
        this.supp.removeValidListener(l);
    }

    @Override
    public void rmValueListener(PropertyChangeListener l) {
        this.supp.rmValueListener(l);
    }
}

