/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.concurrent.Future;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.ui.light.LightRowValuesTable;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelLinesSourceOffline;
import org.openconcerto.ui.light.LightUIElement;
import org.openconcerto.ui.light.SearchSpec;
import org.openconcerto.ui.light.TableContent;

public class LightForeignRowValuesTableOffline
extends LightRowValuesTable {
    private SQLField foreignField;
    private Number parentRowId;

    public LightForeignRowValuesTableOffline(Configuration configuration, Number userId, String id, ITableModel model, SQLField foreignField, Number parentRowId) {
        super(configuration, userId, id, model);
        this.foreignField = foreignField;
        this.parentRowId = parentRowId;
        this.init();
    }

    public LightForeignRowValuesTableOffline(LightForeignRowValuesTableOffline table) {
        super(table);
        this.foreignField = table.foreignField;
        this.parentRowId = table.parentRowId;
        this.init();
    }

    private final void init() {
        if (this.getTableSpec().getContent() == null) {
            this.getTableSpec().setContent(new TableContent(this.getId()));
        }
    }

    public final SQLField getForeignField() {
        return this.foreignField;
    }

    public final Number getParentRowId() {
        return this.parentRowId;
    }

    public Future<?> commitRows() {
        return ((SQLTableModelLinesSourceOffline)this.getModel().getLinesSource()).commit();
    }

    public void addNewRow(SQLRowValues sqlRow) {
        ((SQLTableModelLinesSourceOffline)this.getModel().getLinesSource()).add(sqlRow);
    }

    @Override
    public void doSearch(Configuration configuration, SearchSpec searchSpec, int offset) {
        this.getModel().fireTableRowsInserted(0, Integer.MAX_VALUE);
    }

    public LightUIElement clone() {
        return new LightForeignRowValuesTableOffline(this);
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        if (this.getTableSpec().getContent() != null) {
            this.getTableSpec().getContent().clearRows();
        }
    }
}

